<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ServiceRequest;
use Illuminate\Support\Facades\Mail;
use App\Mail\ServiceRequestNotification;

class ServiceRequestController extends Controller
{
    public function submit(Request $request)
    {
        // Validate
        $data = $request->validate([
            'name' => 'required|string|max:255',
            'phone' => 'required|string|max:20',
            'service' => 'required|string',
            'area' => 'required|string',
            'message' => 'required|string',
        ]);

        // Save to database
        $serviceRequest = ServiceRequest::create($data);

        // Send notification email
        Mail::to('info@curtainsupplierandmaker.shop')->send(new ServiceRequestNotification($serviceRequest));

        return back()->with('success', 'تم إرسال طلبك بنجاح! سنتواصل معك قريباً.');
    }
}
