<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
 
  <title>مورد وصانع ستائر في الرياض</title>

  <!-- SEO Meta Tags -->
  <meta name="description" content="ستائر فاخرة في الرياض، تفصيل ستائر حسب الطلب، تركيب ستائر بلاك اوت، ستائر رول، ستائر مودرن، بارزة، تفصيل ستائر فندقية بالرياض بخبرة عالية.">
  <meta name="keywords" content="ستائر في الرياض, تفصيل ستائر الرياض, تركيب ستائر الرياض, ستائر فاخرة الرياض, ستائر بلاك اوت الرياض, ستائر حسب الطلب الرياض, محلات ستائر في الرياض">
  <meta name="author" content="Curtain Service Riyadh">

  <!-- Canonical -->
  <link rel="canonical" href="https://curtainsserviceriyadh.shop/">

  <!-- Open Graph -->
  <meta property="og:title" content="تفصيل وتركيب ستائر فاخرة بالرياض | حسب الطلب">
  <meta property="og:description" content="تفصيل وتركيب جميع أنواع الستائر بالرياض، ستائر فاخرة، بلاك أوت، رول، مودرن، ستائر إيطالية وخليجية مع تنفيذ احترافي.">
  <meta property="og:image" content="https://curtainsserviceriyadh.shop/images/og-stairs.jpg">
  <meta property="og:url" content="https://curtainsserviceriyadh.shop/">

  <!-- Twitter -->
  <meta name="twitter:card" content="summary_large_image">

  <!-- Favicons -->
  <link rel="icon" href="data:image/svg+xml,<svg xmlns=%22http://www.w3.org/2000/svg%22 viewBox=%220 0 100 100%22><text y=%22.9em%22 font-size=%2290%22>🎪</text></svg>">

  <!-- Stylesheets -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700;800&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">

  <style>
    :root {
      --primary-color: #3D6B63;   /* main brand color (buttons, headings, links) */
      --secondary-color: #B85C38; /* accent / highlights (badges, icons) */
      --accent-color: #E6C66A;    /* support / call-to-action (buttons hover, highlights) */

      /* --- Neutrals derived from only these three colors --- */
      --bg-color: #FFF9F4;         /* use as background, very light neutral */
      --text-color: #3D6B63;       /* primary text */
      --text-muted: #B85C38;       /* secondary text, subheadings */
    }

    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Tajawal', sans-serif;
      background-color: var(--bg-color);
      color: var(--text-color);
      line-height: 1.7;
      direction: ltr;
    }

    .hero-slider {
      position: relative;
      width: 100%;
      height: 100vh;
      overflow: hidden;
    }

    .hero-slider .slide {
      position: absolute;
      inset: 0;
      width: 100%;
      height: 100%;
      background-size: cover;
      background-position: center;
      background-repeat: no-repeat;
      opacity: 0;
      transition: opacity 1.2s ease-in-out;
      transform: scale(1.05);
    }

    .hero-slider .slide.active {
      opacity: 1;
      transform: scale(1);
    }

    .hero-slider .slide::before {
      content: '';
      position: absolute;
      top: 0;
      right: 0;
      width: 100%;
      height: 100%;
      background: rgba(0, 0, 0, 0.4);
      
      z-index: 1;
    }

    .hero-content {
      position: absolute;
      top: 50%;
      right: 10%;
      transform: translateY(-50%);
      width: 90%;
      max-width: 650px;
      text-align: right;
      color: white;
      padding: 50px 40px;
      border-radius: 20px;
      z-index: 2;
      background: rgba(255, 249, 244, 0.1);
      backdrop-filter: blur(10px);
      border: 1px solid rgba(255, 255, 255, 0.2);
      box-shadow: 0 15px 35px rgba(61, 107, 99, 0.25);
    }

    .hero-content h1 {
      font-size: 3.2rem;
      margin-bottom: 20px;
      font-weight: 800;
      line-height: 1.3;
      color: white;
      text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.3);
    }

    .hero-content h1 span {
      color: var(--accent-color);
      display: block;
      font-size: 2.8rem;
      margin-top: 10px;
    }

    .hero-content p {
      color: rgba(255, 255, 255, 0.95);
      font-size: 1.3rem;
      line-height: 1.8;
      margin-bottom: 35px;
      text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.2);
    }

    .cta-btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      background: var(--accent-color);
      color: var(--text-color);
      padding: 18px 35px;
      font-size: 1.2rem;
      border-radius: 12px;
      text-decoration: none;
      font-weight: 700;
      box-shadow: 0 10px 30px rgba(230, 198, 106, 0.4);
      transition: all 0.3s ease;
      border: 2px solid transparent;
      gap: 12px;
    }

    .cta-btn:hover {
      background: var(--secondary-color);
      color: white;
      transform: translateY(-5px);
      box-shadow: 0 15px 40px rgba(184, 92, 56, 0.5);
    }

    .cta-btn i {
      font-size: 1.4rem;
      transition: transform 0.3s ease;
    }

    .cta-btn:hover i {
      transform: translateX(-5px);
    }

    .service-features {
      display: flex;
      flex-wrap: wrap;
      gap: 15px;
      margin: 25px 0;
    }

    .feature-tag {
      background: rgba(255, 255, 255, 0.2);
      color: white;
      padding: 10px 20px;
      border-radius: 25px;
      font-size: 0.95rem;
      font-weight: 600;
      border: 1px solid rgba(255, 255, 255, 0.3);
      backdrop-filter: blur(5px);
      transition: all 0.3s ease;
    }

    .feature-tag:hover {
      background: var(--accent-color);
      color: var(--text-color);
      transform: translateY(-2px);
      border-color: var(--accent-color);
    }

    .slider-indicators {
      position: absolute;
      bottom: 40px;
      right: 50%;
      transform: translateX(50%);
      display: flex;
      gap: 12px;
      z-index: 3;
      background: rgba(61, 107, 99, 0.3);
      padding: 10px 15px;
      border-radius: 25px;
      backdrop-filter: blur(5px);
    }

    .slider-dot {
      width: 14px;
      height: 14px;
      border-radius: 50%;
      background: rgba(255, 255, 255, 0.5);
      cursor: pointer;
      transition: all 0.3s ease;
      border: 2px solid transparent;
    }

    .slider-dot.active {
      background: var(--accent-color);
      transform: scale(1.3);
      border-color: white;
    }

    /* Navigation Placeholder Styles */
    .nav-placeholder {
      position: fixed;
      top: 0;
      width: 100%;
      background: var(--bg-color);
      padding: 15px 0;
      z-index: 1000;
      box-shadow: 0 2px 15px rgba(61, 107, 99, 0.1);
      border-bottom: 2px solid var(--accent-color);
    }

    .nav-placeholder .container {
      display: flex;
      justify-content: space-between;
      align-items: center;
    }

    .nav-logo {
      font-weight: 800;
      font-size: 1.8rem;
      color: var(--primary-color);
      text-decoration: none;
    }

    .nav-logo span {
      color: var(--secondary-color);
    }

    .nav-contact {
      background: var(--primary-color);
      color: white;
      padding: 10px 20px;
      border-radius: 8px;
      text-decoration: none;
      font-weight: 600;
      transition: all 0.3s ease;
    }

    .nav-contact:hover {
      background: var(--secondary-color);
      transform: translateY(-2px);
    }

    /* --- Responsive --- */
    @media (max-width: 1200px) {
      .hero-content {
        right: 5%;
        padding: 40px 35px;
      }
      
      .hero-content h1 {
        font-size: 2.8rem;
      }
      
      .hero-content h1 span {
        font-size: 2.4rem;
      }
    }

    @media (max-width: 992px) {
      .hero-content {
        right: 50%;
        transform: translate(50%, -50%);
        text-align: center;
        width: 85%;
      }
      
      .hero-content h1 {
        font-size: 2.5rem;
      }
      
      .hero-content h1 span {
        font-size: 2.1rem;
      }
      
      .hero-content p {
        font-size: 1.2rem;
      }

      .service-features {
        justify-content: center;
      }
    }

    @media (max-width: 768px) {
      .hero-slider {
        height: 80vh;
      }
      
      .hero-content {
        padding: 30px 25px;
        width: 90%;
      }
      
      .hero-content h1 {
        font-size: 2rem;
      }
      
      .hero-content h1 span {
        font-size: 1.7rem;
      }
      
      .hero-content p {
        font-size: 1.1rem;
        margin-bottom: 25px;
      }
      
      .cta-btn {
        padding: 16px 30px;
        font-size: 1.1rem;
      }
      
      .feature-tag {
        font-size: 0.9rem;
        padding: 8px 16px;
      }

      .nav-placeholder {
        padding: 12px 0;
      }

      .nav-logo {
        font-size: 1.5rem;
      }

      .nav-contact {
        padding: 8px 16px;
        font-size: 0.9rem;
      }
    }

    @media (max-width: 576px) {
      .hero-slider {
        height: 70vh;
      }
      
      .hero-content {
        padding: 25px 20px;
      }
      
      .hero-content h1 {
        font-size: 1.7rem;
      }
      
      .hero-content h1 span {
        font-size: 1.4rem;
      }
      
      .hero-content p {
        font-size: 1rem;
      }
      
      .cta-btn {
        padding: 14px 25px;
        font-size: 1rem;
      }
      
      .slider-indicators {
        bottom: 25px;
        padding: 8px 12px;
      }

      .service-features {
        gap: 10px;
      }

      .feature-tag {
        font-size: 0.8rem;
        padding: 6px 12px;
      }
    }

    /* Animation for content */
    @keyframes fadeInUp {
      from {
        opacity: 0;
        transform: translateY(30px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .hero-content {
      animation: fadeInUp 1s ease-out;
    }
  </style>
</head>

<body>

  <!-- Navigation Placeholder -->
  @include('nav')

  <section class="hero-slider">
    <!-- Slide 1 - Luxury Curtains -->
    <div class="slide active" style="background-image: url('images/a.webp');"></div>
    
    <!-- Slide 2 - Modern Curtains -->
    <div class="slide" style="background-image: url('images/b.webp');"></div>
    
    <!-- Slide 3 - Blackout Curtains -->
    <div class="slide" style="background-image: url('images/c.webp');"></div>
    
    <!-- Slide 4 - Custom Design -->
    <div class="slide" style="background-image: url('images/d.webp');"></div>

    <div class="hero-content">
      <h1>
مورد وصانع ستائر في الرياض        
<span>بتصاميم حسب الطلب</span>
      </h1>
      <p>
        نقدم تفصيل وتركيب ستائر في الرياض بأعلى جودة،
        ستائر بلاك اوت، ستائر جاهزة، وستائر فاخرة تلائم جميع المساحات. 
        خصومات خاصة لأهل الرياض – اتصل الآن!
      </p>
      
      
      
      <a href="tel:966581495036" class="cta-btn">
        <i class="bi bi-telephone-fill"></i>
        اتصل الآن 0581495036
      </a>
    </div>

    <div class="slider-indicators">
      <div class="slider-dot active" data-slide="0"></div>
      <div class="slider-dot" data-slide="1"></div>
      <div class="slider-dot" data-slide="2"></div>
      <div class="slider-dot" data-slide="3"></div>
    </div>
  </section>

  <script>
    let slides = document.querySelectorAll('.hero-slider .slide');
    let dots = document.querySelectorAll('.slider-dot');
    let currentIndex = 0;

    function changeSlide() {
      slides[currentIndex].classList.remove('active');
      dots[currentIndex].classList.remove('active');
      
      currentIndex = (currentIndex + 1) % slides.length;
      
      slides[currentIndex].classList.add('active');
      dots[currentIndex].classList.add('active');
    }

    // Auto slide change every 5 seconds
    setInterval(changeSlide, 5000);

    // Manual slide control with dots
    dots.forEach((dot, index) => {
      dot.addEventListener('click', () => {
        slides[currentIndex].classList.remove('active');
        dots[currentIndex].classList.remove('active');
        
        currentIndex = index;
        
        slides[currentIndex].classList.add('active');
        dots[currentIndex].classList.add('active');
      });
    });
  </script>
@include('aboutSection')
    <!-- 3thsection -->
  @include('servicesSection')
<!-- معرض أعمال الصيانة -->
 <style>
        :root {
            --primary-color: #3D6B63;   /* main brand color (buttons, headings, links) */
            --secondary-color: #B85C38; /* accent / highlights (badges, icons) */
            --accent-color: #E6C66A;    /* support / call-to-action (buttons hover, highlights) */

            /* --- Neutrals derived from only these three colors --- */
            --bg-color: #FFF9F4;         /* use as background, very light neutral */
            --text-color: #3D6B63;       /* primary text */
            --text-muted: #B85C38;       /* secondary text, subheadings */
        }

       

        .gallery-section {
            background-color: var(--bg-color);
            padding: 80px 0;
            border-top: 3px solid var(--accent-color);
        }

        .section-header {
            text-align: center;
            margin-bottom: 60px;
        }

        .section-decoration {
            display: flex;
            justify-content: center;
            align-items: center;
            margin-bottom: 20px;
            gap: 15px;
        }

        .decoration-star {
            color: var(--primary-color);
            font-size: 1.8rem;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.1); }
        }

        .section-badge {
            color: var(--primary-color);
            font-weight: 700;
            font-size: 1.1rem;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .section-title {
            color: var(--primary-color);
            font-weight: 800;
            margin-bottom: 20px;
            line-height: 1.2;
        }

        .section-subtitle {
            color: var(--text-muted);
            font-size: 1.2rem;
            max-width: 800px;
            margin: 0 auto;
            line-height: 1.6;
        }

        /* Gallery Navigation */
        .gallery-nav {
            display: flex;
            justify-content: center;
            margin-bottom: 40px;
            gap: 15px;
            flex-wrap: wrap;
        }

        .gallery-btn {
            border: 2px solid var(--primary-color);
            color: var(--primary-color);
            padding: 12px 30px;
            border-radius: 30px;
            background-color: transparent;
            font-weight: 700;
            font-size: 1rem;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
        }

        .gallery-btn:hover,
        .gallery-btn.active {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(61, 107, 99, 0.3);
        }

        /* Gallery Cards */
        .gallery-card {
            position: relative;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(61, 107, 99, 0.1);
            height: 320px;
            margin-bottom: 25px;
            transition: all 0.4s ease;
            border: 2px solid transparent;
        }

        .gallery-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(61, 107, 99, 0.2);
            border-color: var(--accent-color);
        }

        .gallery-card img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.4s ease;
        }

        .gallery-card:hover img {
            transform: scale(1.1);
        }

        .gallery-caption {
            position: absolute;
            bottom: 0;
            right: 0;
            left: 0;
            background: linear-gradient(to top, rgba(61, 107, 99, 0.9), transparent);
            color: white;
            padding: 25px 20px;
            text-align: right;
            transform: translateY(10px);
            transition: all 0.3s ease;
        }

        .gallery-card:hover .gallery-caption {
            transform: translateY(0);
        }

        .gallery-caption h5 {
            font-weight: 700;
            margin-bottom: 8px;
            font-size: 1.3rem;
        }

        .gallery-caption p {
            margin-bottom: 0;
            font-size: 0.95rem;
            opacity: 0.9;
            line-height: 1.5;
        }

        /* Call to Action */
        .cta-section {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            border-radius: 20px;
            padding: 50px 40px;
            margin-top: 50px;
            box-shadow: 0 15px 40px rgba(61, 107, 99, 0.3);
            border: 2px solid var(--accent-color);
        }

        .cta-title {
            color: white;
            font-weight: 700;
            margin-bottom: 15px;
        }

        .cta-subtitle {
            color: rgba(255, 255, 255, 0.9);
            margin-bottom: 30px;
            font-size: 1.1rem;
        }

        .cta-buttons {
            display: flex;
            justify-content: center;
            gap: 20px;
            flex-wrap: wrap;
        }

        .cta-btn {
            padding: 14px 30px;
            border-radius: 30px;
            font-weight: 700;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 10px;
            transition: all 0.3s ease;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.2);
        }

        .cta-btn.primary {
            background: white;
            color: var(--text-color);
        }

        .cta-btn.primary:hover {
            background: var(--accent-color);
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(230, 198, 106, 0.4);
        }

        .cta-btn.secondary {
            background: transparent;
            color: white;
            border: 2px solid white;
        }

        .cta-btn.secondary:hover {
            background: white;
            color: var(--text-color);
            transform: translateY(-3px);
        }

        .phone-number {
            direction: ltr;
            font-weight: 700;
            font-size: 1.1rem;
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .gallery-section {
                padding: 60px 0;
            }

            .section-title {
                font-size: 2rem;
            }

            .section-subtitle {
                font-size: 1.1rem;
            }

            .gallery-card {
                height: 280px;
            }

            .gallery-caption {
                padding: 20px 15px;
            }

            .gallery-caption h5 {
                font-size: 1.2rem;
            }

            .cta-section {
                padding: 40px 30px;
                margin-top: 40px;
            }

            .cta-buttons {
                flex-direction: column;
                align-items: center;
            }

            .cta-btn {
                width: 100%;
                justify-content: center;
            }
        }

        @media (max-width: 576px) {
            .gallery-section {
                padding: 40px 0;
            }

            .section-title {
                font-size: 1.7rem;
            }

            .section-subtitle {
                font-size: 1rem;
            }

            .gallery-card {
                height: 250px;
            }

            .gallery-caption {
                padding: 15px 12px;
            }

            .gallery-caption h5 {
                font-size: 1.1rem;
            }

            .gallery-caption p {
                font-size: 0.9rem;
            }

            .cta-section {
                padding: 30px 20px;
                margin-top: 30px;
            }

            .gallery-btn {
                padding: 10px 25px;
                font-size: 0.9rem;
            }
        }
    </style>


 <section class="gallery-section">
    <div class="container">
        <div class="section-header">
            <div class="section-decoration">
                <span class="decoration-star">✦</span>
                <h6 class="section-badge mb-0">معرض أعمال التفصيل</h6>
                <span class="decoration-star">✦</span>
            </div>
            <h2 class="section-title display-5 fw-bold">أحدث مشاريع تفصيل وتركيب الستائر</h2>
            <p class="section-subtitle">
                أعمال تفصيل احترافية وتركيب دقيق تناسب جميع أنواع الستائر والأقمشة في الرياض
            </p>
        </div>

        <!-- Navigation Buttons -->
        <div class="gallery-nav">
            <button class="gallery-btn active" data-gallery="gallery1">تفصيل ستائر حسب الطلب</button>
            <button class="gallery-btn" data-gallery="gallery2">تركيب ستائر بلاك اوت</button>
            <button class="gallery-btn" data-gallery="gallery3">ستائر فاخرة وجاهزة</button>
        </div>

        <!-- Gallery 1 - تفصيل ستائر حسب الطلب (Visible by default) -->
        <div id="gallery1" class="gallery-group">
            <div class="row g-4">
                <div class="col-md-4">
                    <div class="gallery-card">
                        <img src="images/Bedroom Curtains.jpeg" 
                             class="img-fluid" 
                             alt="تفصيل ستائر غرف النوم الرياض">
                        <div class="gallery-caption">
                            <h5>ستائر غرف النوم</h5>
                            <p>تفصيل مخصص لستائر غرف النوم بأقمشة مريحة وألوان هادئة</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="gallery-card">
                        <img src="images/Hall curtains.jpeg" 
                             class="img-fluid" 
                             alt="تفصيل ستائر صالات الرياض">
                        <div class="gallery-caption">
                            <h5>ستائر الصالات</h5>
                            <p>تصميم وتنفيذ ستائر فاخرة للصالات والاستقبال</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="gallery-card">
                        <img src="images/Office Curtains.jpeg" 
                             class="img-fluid" 
                             alt="تفصيل ستائر مكاتب الرياض">
                        <div class="gallery-caption">
                            <h5>ستائر المكاتب</h5>
                            <p>ستائر احترافية للمكاتب تجمع بين الجمال والوظيفية</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Gallery 2 - تركيب ستائر بلاك اوت (Hidden by default) -->
        <div id="gallery2" class="gallery-group" style="display: none;">
            <div class="row g-4">
                <div class="col-md-4">
                    <div class="gallery-card">
                        <img src="images/Luxury Blackout Curtains.jpeg" 
                             class="img-fluid" 
                             alt="تركيب ستائر بلاك اوت الرياض">
                        <div class="gallery-caption">
                            <h5>ستائر بلاك اوت فاخرة</h5>
                            <p>تركيب احترافي لستائر بلاك اوت عازلة للضوء والصوت</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="gallery-card">
                        <img src="images/Thermally insulated curtains.webp" 
                             class="img-fluid" 
                             alt="تركيب ستائر معزولة الرياض">
                        <div class="gallery-caption">
                            <h5>ستائر معزولة حراريًا</h5>
                            <p>تركيب ستائر معزولة للحفاظ على درجة حرارة الغرفة</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="gallery-card">
                        <img src="images/Double-layered curtains.webp" 
                             class="img-fluid" 
                             alt="تركيب ستائر مزدوجة الرياض">
                        <div class="gallery-caption">
                            <h5>ستائر مزدوجة الطبقات</h5>
                            <p>تركيب ستائر مزدوجة للعزل الشامل والخصوصية الكاملة</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Gallery 3 - ستائر فاخرة وجاهزة (Hidden by default) -->
        <div id="gallery3" class="gallery-group" style="display: none;">
            <div class="row g-4">
                <div class="col-md-4">
                    <div class="gallery-card">
                        <img src="images/A variety of ready-made curtains.webp" 
                             class="img-fluid" 
                             alt="ستائر جاهزة الرياض">
                        <div class="gallery-caption">
                            <h5>ستائر جاهزة متنوعة</h5>
                            <p>تشكيلة واسعة من الستائر الجاهزة بمقاسات وألوان متنوعة</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="gallery-card">
                        <img src="images/Luxury Embroidered Curtains.webp" 
                             class="img-fluid" 
                             alt="ستائر مطرزة الرياض">
                        <div class="gallery-caption">
                            <h5>ستائر مطرزة فاخرة</h5>
                            <p>ستائر مطرزة بتصاميم فاخرة تضيف لمسة من الأناقة</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="gallery-card">
                        <img src="images/Curtains with modern designs.webp" 
                             class="img-fluid" 
                             alt="ستائر حديثة الرياض">
                        <div class="gallery-caption">
                            <h5>ستائر بتصاميم حديثة</h5>
                            <p>ستائر عصرية بتصاميم مبتكرة تناسب الديكورات الحديثة</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Separate Video Section -->
<section class="video-section">
    <div class="container">
        <div class="section-header">
            <div class="section-decoration">
                <span class="decoration-star">✦</span>
                <h6 class="section-badge mb-0">فيديوهات تعليمية</h6>
                <span class="decoration-star">✦</span>
            </div>
            <h2 class="section-title display-5 fw-bold">شاهد عملية التفصيل والتركيب</h2>
            <p class="section-subtitle">
                تعرف على مراحل تفصيل وتركيب الستائر من البداية إلى النهاية
            </p>
        </div>

        <div class="row g-4">
            <div class="col-md-4">
                <div class="video-card">
                    <div class="video-wrapper">
                        <video autoplay muted loop playsinline controls poster="images/video-poster-1.jpg">
                            <source src="images/curtain-customization-process.mp4" type="video/mp4">
                            <source src="videos/curtain-customization-process.webm" type="video/webm">
                            متصفحك لا يدعم تشغيل الفيديو.
                        </video>
                        <div class="video-overlay">
                            <span class="play-indicator">▶ تشغيل تلقائي</span>
                        </div>
                    </div>
                    <div class="video-caption">
                        <h5>عملية تفصيل الستائر</h5>
                        <p>شاهد عملية تفصيل الستائر خطوة بخطوة في ورشتنا بالرياض</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="video-card">
                    <div class="video-wrapper">
                        <video autoplay muted loop playsinline controls poster="images/video-poster-2.jpg">
                            <source src="images/curtain-installation-guide.mp4" type="video/mp4">
                            <source src="videos/curtain-installation-guide.webm" type="video/webm">
                            متصفحك لا يدعم تشغيل الفيديو.
                        </video>
                        <div class="video-overlay">
                            <span class="play-indicator">▶ تشغيل تلقائي</span>
                        </div>
                    </div>
                    <div class="video-caption">
                        <h5>دليل تركيب الستائر</h5>
                        <p>تعرف على الطريقة الصحيحة لتركيب الستائر بأنواعها المختلفة</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="video-card">
                    <div class="video-wrapper">
                        <video autoplay muted loop playsinline controls poster="images/video-poster-3.jpg">
                            <source src="images/fabric-selection-tips.mp4" type="video/mp4">
                            <source src="videos/fabric-selection-tips.webm" type="video/webm">
                            متصفحك لا يدعم تشغيل الفيديو.
                        </video>
                        <div class="video-overlay">
                            <span class="play-indicator">▶ تشغيل تلقائي</span>
                        </div>
                    </div>
                    <div class="video-caption">
                        <h5>نصائح اختيار الأقمشة</h5>
                        <p>دليل شامل لاختيار أفضل أنواع الأقمشة لستائر منزلك أو مكتبك</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
    .gallery-section {
        padding: 80px 0;
        background-color: #f8f9fa;
    }
    
    .video-section {
        padding: 80px 0;
        background-color: #ffffff;
    }
    
    .section-header {
        text-align: center;
        margin-bottom: 50px;
    }
    
    .section-decoration {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 15px;
        margin-bottom: 15px;
    }
    
    .decoration-star {
        color: #8B7355;
        font-size: 18px;
    }
    
    .section-badge {
        color: #8B7355;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 1px;
    }
    
    .section-title {
        color: #2c3e50;
        margin-bottom: 20px;
    }
    
    .section-subtitle {
        color: #6c757d;
        max-width: 600px;
        margin: 0 auto;
        font-size: 1.1rem;
    }
    
    .gallery-nav {
        display: flex;
        justify-content: center;
        flex-wrap: wrap;
        gap: 15px;
        margin-bottom: 40px;
    }
    
    .gallery-btn {
        background-color: white;
        border: 1px solid #dee2e6;
        padding: 12px 24px;
        border-radius: 30px;
        font-weight: 500;
        color: #495057;
        transition: all 0.3s ease;
        cursor: pointer;
    }
    
    .gallery-btn:hover {
        background-color: #f1f3f5;
    }
    
    .gallery-btn.active {
        background-color: #8B7355;
        color: white;
        border-color: #8B7355;
    }
    
    .gallery-card, .video-card {
        background-color: white;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 5px 15px rgba(0,0,0,0.05);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        height: 100%;
    }
    
    .gallery-card:hover, .video-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px rgba(0,0,0,0.1);
    }
    
    .gallery-card img {
        width: 100%;
        height: 250px;
        object-fit: cover;
    }
    
    .gallery-caption, .video-caption {
        padding: 20px;
    }
    
    .gallery-caption h5, .video-caption h5 {
        color: #2c3e50;
        margin-bottom: 10px;
    }
    
    .gallery-caption p, .video-caption p {
        color: #6c757d;
        margin-bottom: 0;
    }
    
    .video-wrapper {
        position: relative;
        padding-top: 56.25%; /* 16:9 Aspect Ratio */
        background-color: #000;
        overflow: hidden;
    }
    
    .video-wrapper video {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        object-fit: cover;
    }
    
    .video-overlay {
        position: absolute;
        top: 10px;
        right: 10px;
        background: rgba(0, 0, 0, 0.7);
        color: white;
        padding: 4px 8px;
        border-radius: 4px;
        font-size: 12px;
        z-index: 2;
    }
    
    .play-indicator {
        display: flex;
        align-items: center;
        gap: 4px;
    }
    
    @media (max-width: 768px) {
        .gallery-nav {
            flex-direction: column;
            align-items: center;
        }
        
        .gallery-btn {
            width: 100%;
            max-width: 300px;
        }
        
        .video-section .col-md-4 {
            margin-bottom: 20px;
        }
        
        .video-overlay {
            top: 5px;
            right: 5px;
            font-size: 10px;
            padding: 2px 6px;
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const buttons = document.querySelectorAll('.gallery-btn');
        
        buttons.forEach(button => {
            button.addEventListener('click', function() {
                // Remove active class from all buttons
                buttons.forEach(btn => btn.classList.remove('active'));
                
                // Add active class to clicked button
                this.classList.add('active');
                
                // Hide all galleries
                document.querySelectorAll('.gallery-group').forEach(gallery => {
                    gallery.style.display = 'none';
                });
                
                // Show selected gallery
                const galleryId = this.getAttribute('data-gallery');
                document.getElementById(galleryId).style.display = 'block';
            });
        });
        
        // Auto-play videos in the separate video section
        const videos = document.querySelectorAll('.video-section video');
        videos.forEach(video => {
            video.muted = true;
            video.play().catch(e => {
                console.log('Video autoplay failed:', e);
            });
        });
    });
</script>
   @include('newSection')
 <!-- 6th section -->


<!-- 7th section -->


@include('newSection2')

<!-- Google Map -->
<div class="container-fluid p-0 my-5">
  <div style="height: 300px;">
    <iframe
      loading="lazy"
      src="https://maps.google.com/maps?q=الرياض&amp;t=m&amp;z=12&amp;output=embed&amp;iwloc=near"
      title="مركز صيانة المكيفات والغسالات - الرياض"
      aria-label="مركز صيانة المكيفات والغسالات - الرياض"
      style="width: 100%; height: 100%; border: 0; filter: grayscale(0.2) contrast(1.1);"
    ></iframe>
  </div>
</div>

<!-- Testimonial Section -->
 <style>
        :root {
            --primary-color: #3D6B63;   /* main brand color (buttons, headings, links) */
            --secondary-color: #B85C38; /* accent / highlights (badges, icons) */
            --accent-color: #E6C66A;    /* support / call-to-action (buttons hover, highlights) */

            /* --- Neutrals derived from only these three colors --- */
            --bg-color: #FFF9F4;         /* use as background, very light neutral */
            --text-color: #3D6B63;       /* primary text */
            --text-muted: #B85C38;       /* secondary text, subheadings */
        }

      

        .reviews-section {
            background: linear-gradient(135deg, var(--bg-color) 0%, rgba(255, 249, 244, 0.8) 100%);
            padding: 80px 0;
            border-top: 3px solid var(--accent-color);
        }

        .section-header {
            text-align: center;
            margin-bottom: 60px;
        }

        .section-decoration {
            display: flex;
            justify-content: center;
            align-items: center;
            margin-bottom: 20px;
            gap: 15px;
        }

        .decoration-star {
            color: var(--primary-color);
            font-size: 1.8rem;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.1); }
        }

        .section-badge {
            color: var(--primary-color);
            font-weight: 700;
            font-size: 1.1rem;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .section-title {
            color: var(--primary-color);
            font-weight: 800;
            margin-bottom: 20px;
            line-height: 1.2;
        }

        .section-subtitle {
            color: var(--text-muted);
            font-size: 1.2rem;
            max-width: 800px;
            margin: 0 auto;
            line-height: 1.6;
        }

        /* Reviews Slider */
        .reviews-slider {
            position: relative;
            max-width: 1200px;
            margin: 0 auto;
            overflow: hidden;
        }

        .reviews-container {
            display: flex;
            transition: transform 0.5s ease-in-out;
        }

        .review-card {
            flex: 0 0 33.333%;
            padding: 0 15px;
            transition: all 0.3s ease;
        }

        .review-content {
            background: white;
            border-radius: 20px;
            padding: 30px;
            box-shadow: 0 10px 30px rgba(61, 107, 99, 0.1);
            border: 2px solid transparent;
            height: 100%;
            transition: all 0.3s ease;
            position: relative;
        }

        .review-content:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 40px rgba(61, 107, 99, 0.2);
            border-color: var(--accent-color);
        }

        .review-header {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
            gap: 15px;
        }

        .reviewer-avatar {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 700;
            font-size: 1.5rem;
            box-shadow: 0 4px 15px rgba(61, 107, 99, 0.2);
        }

        .reviewer-info {
            flex: 1;
        }

        .reviewer-name {
            color: var(--primary-color);
            font-weight: 700;
            margin-bottom: 5px;
            font-size: 1.1rem;
        }

        .review-date {
            color: var(--text-muted);
            font-size: 0.9rem;
        }

        .review-stars {
            color: var(--accent-color);
            font-size: 1.1rem;
            margin-bottom: 15px;
        }

        .review-text {
            color: var(--text-color);
            line-height: 1.7;
            margin-bottom: 0;
            font-size: 1rem;
        }

        /* Slider Controls */
        .slider-controls {
            display: flex;
            justify-content: center;
            align-items: center;
            margin-top: 40px;
            gap: 20px;
        }

        .slider-btn {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: var(--primary-color);
            color: white;
            border: none;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(61, 107, 99, 0.3);
        }

        .slider-btn:hover {
            background: var(--secondary-color);
            transform: scale(1.1);
            box-shadow: 0 6px 20px rgba(184, 92, 56, 0.4);
        }

        .slider-dots {
            display: flex;
            gap: 10px;
        }

        .slider-dot {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            background: rgba(61, 107, 99, 0.3);
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .slider-dot.active {
            background: var(--secondary-color);
            transform: scale(1.2);
        }

        /* Google Business Link */
        .google-business-link {
            text-align: center;
            margin-top: 50px;
        }

        .gmb-btn {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 15px 35px;
            border-radius: 30px;
            text-decoration: none;
            font-weight: 700;
            display: inline-flex;
            align-items: center;
            gap: 10px;
            transition: all 0.3s ease;
            box-shadow: 0 6px 20px rgba(61, 107, 99, 0.3);
        }

        .gmb-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(184, 92, 56, 0.4);
            color: white;
        }

        /* Loading State */
        .loading {
            text-align: center;
            padding: 40px;
            color: var(--text-muted);
        }

        .spinner {
            width: 40px;
            height: 40px;
            border: 4px solid rgba(61, 107, 99, 0.1);
            border-left: 4px solid var(--secondary-color);
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin: 0 auto 20px;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .reviews-section {
                padding: 60px 0;
            }

            .section-title {
                font-size: 2rem;
            }

            .section-subtitle {
                font-size: 1.1rem;
            }

            .review-card {
                flex: 0 0 100%;
            }

            .review-content {
                padding: 25px;
            }

            .review-header {
                flex-direction: column;
                text-align: center;
                gap: 10px;
            }

            .slider-controls {
                margin-top: 30px;
            }
        }

        @media (max-width: 576px) {
            .reviews-section {
                padding: 40px 0;
            }

            .section-title {
                font-size: 1.7rem;
            }

            .section-subtitle {
                font-size: 1rem;
            }

            .review-content {
                padding: 20px;
            }

            .slider-btn {
                width: 45px;
                height: 45px;
                font-size: 1rem;
            }

            .gmb-btn {
                padding: 12px 25px;
                font-size: 0.9rem;
            }
        }
    </style>


    <section class="reviews-section">
        <div class="container">
            <div class="section-header">
                <div class="section-decoration">
                    <span class="decoration-star">✦</span>
                    <h6 class="section-badge mb-0">آراء العملاء</h6>
                    <span class="decoration-star">✦</span>
                </div>
                <h2 class="section-title display-5 fw-bold">ماذا يقول عملاؤنا عن خدماتنا</h2>
                <p class="section-subtitle">
                    آراء حقيقية من عملائنا الكرام الذين استفادوا من خدمات تفصيل وتركيب الستائر في الرياض
                </p>
            </div>

            <!-- Reviews Slider -->
            <div class="reviews-slider">
                <div id="reviewsContainer" class="reviews-container">
                    <!-- Reviews will be loaded dynamically here -->
                    <div class="loading">
                        <div class="spinner"></div>
                        <p>جاري تحميل آراء العملاء...</p>
                    </div>
                </div>

                <!-- Slider Controls -->
                <div class="slider-controls">
                    <button class="slider-btn prev-btn">
                        <i class="bi bi-chevron-right"></i>
                    </button>
                    <div class="slider-dots" id="sliderDots">
                        <!-- Dots will be generated dynamically -->
                    </div>
                    <button class="slider-btn next-btn">
                        <i class="bi bi-chevron-left"></i>
                    </button>
                </div>
            </div>

            <!-- Google Business Link -->
            <div class="google-business-link">
                <a href="https://g.page/r/CUCGqvIHSb3oEBI/review" target="_blank" class="gmb-btn">
                    <i class="bi bi-google"></i>
                    اترك رأيك على Google Business
                </a>
            </div>
        </div>
    </section>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const reviewsContainer = document.getElementById('reviewsContainer');
            const sliderDots = document.getElementById('sliderDots');
            const prevBtn = document.querySelector('.prev-btn');
            const nextBtn = document.querySelector('.next-btn');
            
            let currentSlide = 0;
            let totalSlides = 0;
            let reviews = [];

            // Sample reviews data (in a real scenario, this would come from Google Business API)
            const sampleReviews = [
                {
                    name: "أحمد محمد",
                    date: "2024-01-15",
                    rating: 5,
                    text: "خدمة ممتازة وجودة عالية في تفصيل الستائر. فريق محترف وتركيب دقيق بدون أي تلف للجدران. أنصح الجميع بالتعامل معهم.",
                    initial: "أ"
                },
                {
                    name: "فاطمة العلي",
                    date: "2024-01-12",
                    rating: 5,
                    text: "ستائر غرفة النوم التي طلبتها رائعة! الأقمشة فاخرة والتفصيل دقيق جداً. شكراً على الاحترافية في العمل.",
                    initial: "ف"
                },
                {
                    name: "خالد السعد",
                    date: "2024-01-10",
                    rating: 4,
                    text: "خدمة جيدة وسريعة. الستائر البلاك اوت التي طلبتها تعمل بشكل ممتاز في عزل الضوء. شكراً للفريق.",
                    initial: "خ"
                },
                {
                    name: "نورة القحطاني",
                    date: "2024-01-08",
                    rating: 5,
                    text: "ما شاء الله تبارك الله! التفصيل كان حسب الطلب تماماً والتركيب محترف. أسعار مناسبة وجودة عالية.",
                    initial: "ن"
                },
                {
                    name: "محمد الحربي",
                    date: "2024-01-05",
                    rating: 5,
                    text: "فريق متخصص ومحترف. استشارة الديكور المجانية ساعدتني كثيراً في اختيار الستائر المناسبة لمنزلي.",
                    initial: "م"
                },
                {
                    name: "لطيفة الشمري",
                    date: "2024-01-03",
                    rating: 4,
                    text: "خدمة سريعة واستجابة فورية. الستائر الجاهزة كانت بمقاسات مناسبة وأسعار معقولة. شكراً لكم.",
                    initial: "ل"
                }
            ];

            // Function to fetch reviews (simulated)
            function fetchReviews() {
                return new Promise((resolve) => {
                    setTimeout(() => {
                        resolve(sampleReviews);
                    }, 1000);
                });
            }

            // Function to render reviews
            function renderReviews(reviewsData) {
                reviews = reviewsData;
                totalSlides = Math.ceil(reviews.length / 3);
                
                reviewsContainer.innerHTML = '';
                sliderDots.innerHTML = '';

                // Create review cards
                reviews.forEach((review, index) => {
                    const reviewCard = document.createElement('div');
                    reviewCard.className = 'review-card';
                    
                    const stars = '★'.repeat(review.rating) + '☆'.repeat(5 - review.rating);
                    
                    reviewCard.innerHTML = `
                        <div class="review-content">
                            <div class="review-header">
                                <div class="reviewer-avatar">${review.initial}</div>
                                <div class="reviewer-info">
                                    <div class="reviewer-name">${review.name}</div>
                                    <div class="review-date">${review.date}</div>
                                </div>
                            </div>
                            <div class="review-stars">${stars}</div>
                            <p class="review-text">${review.text}</p>
                        </div>
                    `;
                    
                    reviewsContainer.appendChild(reviewCard);
                });

                // Create slider dots
                for (let i = 0; i < totalSlides; i++) {
                    const dot = document.createElement('div');
                    dot.className = `slider-dot ${i === 0 ? 'active' : ''}`;
                    dot.addEventListener('click', () => goToSlide(i));
                    sliderDots.appendChild(dot);
                }

                updateSlider();
            }

            // Function to update slider position
            function updateSlider() {
                const translateX = currentSlide * -100;
                reviewsContainer.style.transform = `translateX(${translateX}%)`;
                
                // Update active dot
                document.querySelectorAll('.slider-dot').forEach((dot, index) => {
                    dot.classList.toggle('active', index === currentSlide);
                });
            }

            // Function to go to specific slide
            function goToSlide(slideIndex) {
                currentSlide = slideIndex;
                updateSlider();
            }

            // Next slide function
            function nextSlide() {
                currentSlide = (currentSlide + 1) % totalSlides;
                updateSlider();
            }

            // Previous slide function
            function prevSlide() {
                currentSlide = (currentSlide - 1 + totalSlides) % totalSlides;
                updateSlider();
            }

            // Event listeners
            prevBtn.addEventListener('click', prevSlide);
            nextBtn.addEventListener('click', nextSlide);

            // Auto slide every 5 seconds
            let autoSlide = setInterval(nextSlide, 5000);

            // Pause auto slide on hover
            reviewsContainer.addEventListener('mouseenter', () => clearInterval(autoSlide));
            reviewsContainer.addEventListener('mouseleave', () => {
                autoSlide = setInterval(nextSlide, 5000);
            });

            // Initialize reviews
            fetchReviews().then(renderReviews);
        });
    </script>
@include('workingSection')

@include('footer')

 
    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- WOW.js for animations -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/wow/1.1.2/wow.min.js"></script>
<script>
        new WOW().init();
    </script>
<script>
  document.addEventListener('DOMContentLoaded', function() {
    const container = document.querySelector('.ba-container');
    const before = container.querySelector('.ba-before');
    const handle = container.querySelector('.ba-handle');

    const onMove = e => {
      const rect = container.getBoundingClientRect();
      const x = (e.touches ? e.touches[0].clientX : e.clientX) - rect.left;
      const pct = Math.max(0, Math.min(x, rect.width));
      before.style.width = pct + 'px';
      handle.style.left = pct + 'px';
    };
    handle.addEventListener('mousedown', () => {
      document.addEventListener('mousemove', onMove);
    });
    document.addEventListener('mouseup', () => {
      document.removeEventListener('mousemove', onMove);
    });
    // Touch events
    handle.addEventListener('touchstart', () => {
      document.addEventListener('touchmove', onMove);
    });
    document.addEventListener('touchend', () => {
      document.removeEventListener('touchmove', onMove);
    });
  });
</script>


    <script>
        // Initialize WOW.js
        new WOW().init();
        
        // Auto-rotate carousel every 5 seconds
        document.addEventListener('DOMContentLoaded', function() {
            var myCarousel = document.getElementById('heroCarousel');
            var carousel = new bootstrap.Carousel(myCarousel, {
                interval: 5000,
                ride: 'carousel'
            });
        });
    </script>
    <!-- Add this JavaScript -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const dropdownElement = document.getElementById('servicesDropdown');
    const dropdownLink = document.getElementById('servicesDropdownLink');
    
    // Hover functionality
    dropdownElement.addEventListener('mouseenter', function() {
        const dropdown = new bootstrap.Dropdown(dropdownLink);
        dropdown.show();
    });
    
    dropdownElement.addEventListener('mouseleave', function() {
        const dropdown = bootstrap.Dropdown.getInstance(dropdownLink);
        dropdown.hide();
    });
    
    // Click functionality - navigate to services page
    dropdownLink.addEventListener('click', function(e) {
        // Only navigate if clicking directly on the main link (not when dropdown is open)
        if (!dropdownElement.classList.contains('show')) {
            window.location.href = this.href;
        }
    });
});
</script>

</body>
</html>