  <style>
        :root {
            --primary-color: #3D6B63;   /* main brand color (buttons, headings, links) */
            --secondary-color: #B85C38; /* accent / highlights (badges, icons) */
            --accent-color: #E6C66A;    /* support / call-to-action (buttons hover, highlights) */

            /* --- Neutrals derived from only these three colors --- */
            --bg-color: #FFF9F4;         /* use as background, very light neutral */
            --text-color: #3D6B63;       /* primary text */
            --text-muted: #B85C38;       /* secondary text, subheadings */
        }

    
        /* Contact Section Styling */
        .contact-section {
            background: linear-gradient(135deg, var(--bg-color) 0%, rgba(255, 249, 244, 0.8) 100%);
            border-radius: 20px;
            margin: 60px 0;
            position: relative;
            z-index: 2;
            padding: 40px 0;
            border: 2px solid var(--accent-color);
        }

        .contact-info-card {
            background: white;
            border-radius: 15px;
            padding: 40px;
            box-shadow: 0 15px 40px rgba(61, 107, 99, 0.1);
            height: 100%;
            border: 2px solid var(--primary-color);
            position: relative;
            overflow: hidden;
        }

        .contact-info-card::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100%;
            height: 4px;
            background: linear-gradient(90deg, var(--primary-color), var(--secondary-color));
        }

        .contact-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.2rem;
            margin-left: 15px;
            box-shadow: 0 4px 15px rgba(61, 107, 99, 0.2);
        }

        .service-badge {
            background: var(--accent-color);
            color: var(--text-color);
            padding: 10px 20px;
            border-radius: 25px;
            font-size: 14px;
            font-weight: 700;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            margin-bottom: 20px;
            box-shadow: 0 4px 15px rgba(230, 198, 106, 0.3);
        }

        /* Form Styling */
        #cs_form {
            background: white;
            border-radius: 15px;
            padding: 40px;
            box-shadow: 0 15px 40px rgba(61, 107, 99, 0.1);
            border: 2px solid var(--primary-color);
            height: 100%;
            position: relative;
            overflow: hidden;
        }

        #cs_form::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100%;
            height: 4px;
            background: linear-gradient(90deg, var(--secondary-color), var(--primary-color));
        }
        
        #cs_form .form-control {
            border: 2px solid rgba(61, 107, 99, 0.2);
            border-radius: 10px;
            padding: 15px 20px;
            font-size: 16px;
            transition: all 0.3s ease;
            height: 55px;
            background: var(--bg-color);
        }
        
        #cs_form .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(61, 107, 99, 0.1);
            background: white;
        }
        
        #cs_form textarea.form-control {
            height: auto;
            min-height: 140px;
            resize: vertical;
        }
        
        #cs_form select.form-control {
            appearance: none;
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='%233D6B63' d='M7.247 11.14L2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z'/%3e%3c/svg%3e");
            background-repeat: no-repeat;
            background-position: left 15px center;
            background-size: 16px 12px;
            padding-left: 45px;
        }
        
        #cs_form label {
            display: block;
            margin-bottom: 10px;
            font-weight: 600;
            color: var(--primary-color);
            font-size: 15px;
        }
        
        #cs_form .form-group {
            margin-bottom: 25px;
        }
        
        #cs_form .btn-submit {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            border: none;
            border-radius: 10px;
            padding: 16px 32px;
            font-weight: 700;
            font-size: 17px;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 100%;
            box-shadow: 0 8px 25px rgba(61, 107, 99, 0.3);
        }
        
        #cs_form .btn-submit:hover {
            background: linear-gradient(135deg, var(--secondary-color), var(--primary-color));
            transform: translateY(-3px);
            box-shadow: 0 12px 35px rgba(184, 92, 56, 0.4);
        }
        
        #cs_form .btn-submit i {
            margin-right: 10px;
            transition: transform 0.3s ease;
        }
        
        #cs_form .btn-submit:hover i {
            transform: translateX(5px);
        }
        
        /* Form Header */
        .form-header {
            text-align: center;
            margin-bottom: 35px;
        }
        
        .form-header h3 {
            color: var(--primary-color);
            font-weight: 800;
            margin-bottom: 12px;
            font-size: 28px;
        }
        
        .form-header p {
            color: var(--text-muted);
            font-size: 16px;
            line-height: 1.6;
        }

        /* Service Features */
        .service-features {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
            margin-top: 25px;
        }

        .feature-item {
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 14px;
            color: var(--text-color);
            padding: 8px 0;
        }

        .feature-item i {
            color: var(--secondary-color);
            font-size: 16px;
            background: rgba(184, 92, 56, 0.1);
            width: 24px;
            height: 24px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* Contact Details */
        .contact-details .d-flex {
            padding: 15px 0;
            border-bottom: 1px solid rgba(61, 107, 99, 0.1);
        }

        .contact-details .d-flex:last-child {
            border-bottom: none;
        }

        .contact-details h6 {
            color: var(--primary-color);
            font-weight: 700;
            margin-bottom: 5px;
        }

        .contact-details a {
            color: var(--text-color);
            text-decoration: none;
            transition: color 0.3s ease;
            font-weight: 600;
        }

        .contact-details a:hover {
            color: var(--secondary-color);
        }

        /* Responsive adjustments */
        @media (max-width: 991px) {
            .contact-section {
                margin: 40px 0;
            }
            
            .contact-info-card,
            #cs_form {
                padding: 30px;
            }
        }
        
        @media (max-width: 767px) {
            .contact-section {
                margin: 30px 0;
                border-radius: 15px;
            }
            
            .contact-info-card,
            #cs_form {
                padding: 25px;
                border-radius: 12px;
            }
            
            .service-features {
                grid-template-columns: 1fr;
            }
            
            .form-header h3 {
                font-size: 24px;
            }
        }

        @media (max-width: 575px) {
            .contact-info-card,
            #cs_form {
                padding: 20px;
            }
            
            #cs_form .form-control {
                padding: 12px 15px;
                height: 50px;
            }
        }
    </style>
</head>
<body>

    <section class="position-relative contact-section" style="direction: rtl;">
        <div class="container">
            <div class="row g-5 align-items-stretch">
                <!-- Contact Information -->
                <div class="col-lg-6">
                    <div class="contact-info-card">
                        <div class="service-badge">
                            <i class="bi bi-star-fill"></i>خدمة تفصيل وتركيب احترافية
                        </div>
                        
                        <h1 class="h2 mb-4 fw-bold" style="color: var(--primary-color);">
                            مركز تفصيل الستائر الفاخرة 
                            <span class="d-block" style="color: var(--text-muted); font-size: 1.5rem; margin-top: 10px;">لأجمل الستائر في الرياض</span>
                        </h1>
                        
                        <p class="mb-4 fs-6" style="color: var(--text-color); line-height: 1.8;">
                            نقدم خدمات <strong>تفصيل ستائر الرياض</strong> و<strong>تركيب ستائر بلاك اوت</strong> بجودة عالية وأقمشة فاخرة. فريقنا من <strong>متخصصي الستائر</strong> جاهز لخدمتك في جميع مناطق الرياض.
                        </p>
                        
                        <!-- Contact Details -->
                        <div class="contact-details">
                            <div class="d-flex mb-4 align-items-start">
                                <div class="contact-icon">
                                    <i class="bi bi-geo-alt-fill"></i>
                                </div>
                                <div>
                                    <h6 class="fw-bold mb-1">موقعنا</h6>
                                    <p class="mb-0" style="color: var(--text-color);">الرياض<br>
                                    <small style="color: var(--text-muted);">نغطي جميع مناطق الرياض</small></p>
                                </div>
                            </div>
                            
                            <div class="d-flex mb-4 align-items-start">
                                <div class="contact-icon">
                                    <i class="bi bi-envelope-fill"></i>
                                </div>
                                <div>
                                    <h6 class="fw-bold mb-1">البريد الإلكتروني</h6>
                                    <a href="mailto:info@curtainsserviceriyadh.shop" 
                                       style="color: var(--text-color); text-decoration: none; font-size: 15px;">
                                        info@curtainsserviceriyadh.shop
                                    </a>
                                </div>
                            </div>
                            
                            <div class="d-flex align-items-start">
                                <div class="contact-icon">
                                    <i class="bi bi-telephone-fill"></i>
                                </div>
                                <div>
                                    <h6 class="fw-bold mb-1">اتصل بنا</h6>
                                    <a href="tel:+966581495036" 
                                       style="color: var(--secondary-color); text-decoration: none; font-size: 18px; font-weight: 700;">
                                            581495036
                                    </a>
                                    <p class="mb-0" style="color: var(--text-muted); font-size: 14px;">استشارة مجانية وخدمة سريعة</p>
                                </div>
                            </div>
                        </div>

                        <!-- Service Features -->
                        <div class="service-features mt-4">
                            <div class="feature-item">
                                <i class="bi bi-check-lg"></i>
                                <span>تفصيل ستائر حسب الطلب</span>
                            </div>
                            <div class="feature-item">
                                <i class="bi bi-check-lg"></i>
                                <span>تركيب ستائر بلاك اوت</span>
                            </div>
                            <div class="feature-item">
                                <i class="bi bi-check-lg"></i>
                                <span>ستائر جاهزة متنوعة</span>
                            </div>
                            <div class="feature-item">
                                <i class="bi bi-check-lg"></i>
                                <span>أقمشة فاخرة ومتنوعة</span>
                            </div>
                            <div class="feature-item">
                                <i class="bi bi-check-lg"></i>
                                <span>تركيب احترافي</span>
                            </div>
                            <div class="feature-item">
                                <i class="bi bi-check-lg"></i>
                                <span>استشارة مجانية</span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Contact Form -->
              <div class="col-lg-6">
    <form id="cs_form" method="POST" action="{{ route('service.submit') }}">
        @csrf
        <div class="form-header">
            <h3>طلب خدمة تفصيل الستائر</h3>
            <p>املأ النموذج وسنتصل بك لتحديد موعد</p>
        </div>
        
        <div class="row g-3">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="name">الاسم الكامل</label>
                    <input type="text" id="name" name="name" class="form-control" placeholder="أدخل اسمك بالكامل" required>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="form-group">
                    <label for="phone">رقم الهاتف</label>
                    <input type="tel" id="phone" name="phone" class="form-control" placeholder="مثال: 0581495036" required>
                </div>
            </div>
            
            <div class="col-12">
                <div class="form-group">
                    <label for="service">نوع الخدمة المطلوبة</label>
                    <select id="service" name="service" class="form-control" required>
                        <option value="" disabled selected>اختر نوع الخدمة</option>
                        <option value="تفصيل ستائر حسب الطلب">تفصيل ستائر حسب الطلب</option>
                        <option value="تركيب ستائر بلاك اوت">تركيب ستائر بلاك اوت</option>
                        <option value="شراء ستائر جاهزة">شراء ستائر جاهزة</option>
                        <option value="استشارة ديكور">استشارة ديكور مجانية</option>
                        <option value="صيانة وتنظيف ستائر">صيانة وتنظيف ستائر</option>
                        <option value="تركيب ستائر جديدة">تركيب ستائر جديدة</option>
                    </select>
                </div>
            </div>

            <div class="col-12">
                <div class="form-group">
                    <label for="area">المنطقة</label>
                    <select id="area" name="area" class="form-control" required>
                        <option value="" disabled selected>اختر منطقتك</option>
                        <option value="شمال الرياض">شمال الرياض</option>
                        <option value="غرب الرياض">غرب الرياض</option>
                        <option value="شرق الرياض">شرق الرياض</option>
                        <option value="جنوب الرياض">جنوب الرياض</option>
                        <option value="وسط الرياض">وسط الرياض</option>
                    </select>
                </div>
            </div>
            
            <div class="col-12">
                <div class="form-group">
                    <label for="message">تفاصيل الطلب</label>
                    <textarea id="message" name="message" class="form-control" rows="4" 
                              placeholder="صف ما تريد بالتفصيل (نوع الستائر، القياسات، الألوان المفضلة...)" required></textarea>
                </div>
            </div>
            
            <div class="col-12 mt-2">
                <button type="submit" class="btn-submit">
                    <i class="bi bi-send-fill"></i>
                    إرسال طلب الخدمة
                </button>
            </div>
        </div>
    </form>
</div>

            </div>
        </div>
    </section>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.getElementById('cs_form').addEventListener('submit', function(e) {
            e.preventDefault();
            alert('شكراً لك! تم استلام طلبك وسنتصل بك قريباً.');
            this.reset();
        });
    </script>