<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
 
  <title>مورد وصانع ستائر في الرياض</title>

  <!-- SEO Meta Tags -->
  <meta name="description" content="ستائر فاخرة في الرياض، تفصيل ستائر حسب الطلب، تركيب ستائر بلاك اوت، ستائر رول، ستائر مودرن، بارزة، تفصيل ستائر فندقية بالرياض بخبرة عالية.">
  <meta name="keywords" content="ستائر في الرياض, تفصيل ستائر الرياض, تركيب ستائر الرياض, ستائر فاخرة الرياض, ستائر بلاك اوت الرياض, ستائر حسب الطلب الرياض, محلات ستائر في الرياض">
  <meta name="author" content="Curtain Service Riyadh">

  <!-- Canonical -->
  <link rel="canonical" href="https://curtainsserviceriyadh.shop/">

  <!-- Open Graph -->
  <meta property="og:title" content="تفصيل وتركيب ستائر فاخرة بالرياض | حسب الطلب">
  <meta property="og:description" content="تفصيل وتركيب جميع أنواع الستائر بالرياض، ستائر فاخرة، بلاك أوت، رول، مودرن، ستائر إيطالية وخليجية مع تنفيذ احترافي.">
  <meta property="og:image" content="https://curtainsserviceriyadh.shop/images/og-stairs.jpg">
  <meta property="og:url" content="https://curtainsserviceriyadh.shop/">

  <!-- Twitter -->
  <meta name="twitter:card" content="summary_large_image">

  <!-- Favicons -->
  <link rel="icon" href="data:image/svg+xml,<svg xmlns=%22http://www.w3.org/2000/svg%22 viewBox=%220 0 100 100%22><text y=%22.9em%22 font-size=%2290%22>🎪</text></svg>">

  <!-- Stylesheets -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700;800&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">

  <style>
    :root {
      --primary-color: #3D6B63;   /* main brand color (buttons, headings, links) */
      --secondary-color: #B85C38; /* accent / highlights (badges, icons) */
      --accent-color: #E6C66A;    /* support / call-to-action (buttons hover, highlights) */

      /* --- Neutrals derived from only these three colors --- */
      --bg-color: #FFF9F4;         /* use as background, very light neutral */
      --text-color: #3D6B63;       /* primary text */
      --text-muted: #B85C38;       /* secondary text, subheadings */
    }

    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Tajawal', sans-serif;
      background-color: var(--bg-color);
      color: var(--text-color);
      line-height: 1.7;
      direction: ltr;
    }

    .hero-slider {
      position: relative;
      width: 100%;
      height: 100vh;
      overflow: hidden;
    }

    .hero-slider .slide {
      position: absolute;
      inset: 0;
      width: 100%;
      height: 100%;
      background-size: cover;
      background-position: center;
      background-repeat: no-repeat;
      opacity: 0;
      transition: opacity 1.2s ease-in-out;
      transform: scale(1.05);
    }

    .hero-slider .slide.active {
      opacity: 1;
      transform: scale(1);
    }

    .hero-slider .slide::before {
      content: '';
      position: absolute;
      top: 0;
      right: 0;
      width: 100%;
      height: 100%;
      background: rgba(0, 0, 0, 0.4);
      
      z-index: 1;
    }

    .hero-content {
      position: absolute;
      top: 50%;
      right: 10%;
      transform: translateY(-50%);
      width: 90%;
      max-width: 650px;
      text-align: right;
      color: white;
      padding: 50px 40px;
      border-radius: 20px;
      z-index: 2;
      background: rgba(255, 249, 244, 0.1);
      backdrop-filter: blur(10px);
      border: 1px solid rgba(255, 255, 255, 0.2);
      box-shadow: 0 15px 35px rgba(61, 107, 99, 0.25);
    }

    .hero-content h1 {
      font-size: 3.2rem;
      margin-bottom: 20px;
      font-weight: 800;
      line-height: 1.3;
      color: white;
      text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.3);
    }

    .hero-content h1 span {
      color: var(--accent-color);
      display: block;
      font-size: 2.8rem;
      margin-top: 10px;
    }

    .hero-content p {
      color: rgba(255, 255, 255, 0.95);
      font-size: 1.3rem;
      line-height: 1.8;
      margin-bottom: 35px;
      text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.2);
    }

    .cta-btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      background: var(--accent-color);
      color: var(--text-color);
      padding: 18px 35px;
      font-size: 1.2rem;
      border-radius: 12px;
      text-decoration: none;
      font-weight: 700;
      box-shadow: 0 10px 30px rgba(230, 198, 106, 0.4);
      transition: all 0.3s ease;
      border: 2px solid transparent;
      gap: 12px;
    }

    .cta-btn:hover {
      background: var(--secondary-color);
      color: white;
      transform: translateY(-5px);
      box-shadow: 0 15px 40px rgba(184, 92, 56, 0.5);
    }

    .cta-btn i {
      font-size: 1.4rem;
      transition: transform 0.3s ease;
    }

    .cta-btn:hover i {
      transform: translateX(-5px);
    }

    .service-features {
      display: flex;
      flex-wrap: wrap;
      gap: 15px;
      margin: 25px 0;
    }

    .feature-tag {
      background: rgba(255, 255, 255, 0.2);
      color: white;
      padding: 10px 20px;
      border-radius: 25px;
      font-size: 0.95rem;
      font-weight: 600;
      border: 1px solid rgba(255, 255, 255, 0.3);
      backdrop-filter: blur(5px);
      transition: all 0.3s ease;
    }

    .feature-tag:hover {
      background: var(--accent-color);
      color: var(--text-color);
      transform: translateY(-2px);
      border-color: var(--accent-color);
    }

    .slider-indicators {
      position: absolute;
      bottom: 40px;
      right: 50%;
      transform: translateX(50%);
      display: flex;
      gap: 12px;
      z-index: 3;
      background: rgba(61, 107, 99, 0.3);
      padding: 10px 15px;
      border-radius: 25px;
      backdrop-filter: blur(5px);
    }

    .slider-dot {
      width: 14px;
      height: 14px;
      border-radius: 50%;
      background: rgba(255, 255, 255, 0.5);
      cursor: pointer;
      transition: all 0.3s ease;
      border: 2px solid transparent;
    }

    .slider-dot.active {
      background: var(--accent-color);
      transform: scale(1.3);
      border-color: white;
    }

    /* Navigation Placeholder Styles */
    .nav-placeholder {
      position: fixed;
      top: 0;
      width: 100%;
      background: var(--bg-color);
      padding: 15px 0;
      z-index: 1000;
      box-shadow: 0 2px 15px rgba(61, 107, 99, 0.1);
      border-bottom: 2px solid var(--accent-color);
    }

    .nav-placeholder .container {
      display: flex;
      justify-content: space-between;
      align-items: center;
    }

    .nav-logo {
      font-weight: 800;
      font-size: 1.8rem;
      color: var(--primary-color);
      text-decoration: none;
    }

    .nav-logo span {
      color: var(--secondary-color);
    }

    .nav-contact {
      background: var(--primary-color);
      color: white;
      padding: 10px 20px;
      border-radius: 8px;
      text-decoration: none;
      font-weight: 600;
      transition: all 0.3s ease;
    }

    .nav-contact:hover {
      background: var(--secondary-color);
      transform: translateY(-2px);
    }

    /* --- Responsive --- */
    @media (max-width: 1200px) {
      .hero-content {
        right: 5%;
        padding: 40px 35px;
      }
      
      .hero-content h1 {
        font-size: 2.8rem;
      }
      
      .hero-content h1 span {
        font-size: 2.4rem;
      }
    }

    @media (max-width: 992px) {
      .hero-content {
        right: 50%;
        transform: translate(50%, -50%);
        text-align: center;
        width: 85%;
      }
      
      .hero-content h1 {
        font-size: 2.5rem;
      }
      
      .hero-content h1 span {
        font-size: 2.1rem;
      }
      
      .hero-content p {
        font-size: 1.2rem;
      }

      .service-features {
        justify-content: center;
      }
    }

    @media (max-width: 768px) {
      .hero-slider {
        height: 80vh;
      }
      
      .hero-content {
        padding: 30px 25px;
        width: 90%;
      }
      
      .hero-content h1 {
        font-size: 2rem;
      }
      
      .hero-content h1 span {
        font-size: 1.7rem;
      }
      
      .hero-content p {
        font-size: 1.1rem;
        margin-bottom: 25px;
      }
      
      .cta-btn {
        padding: 16px 30px;
        font-size: 1.1rem;
      }
      
      .feature-tag {
        font-size: 0.9rem;
        padding: 8px 16px;
      }

      .nav-placeholder {
        padding: 12px 0;
      }

      .nav-logo {
        font-size: 1.5rem;
      }

      .nav-contact {
        padding: 8px 16px;
        font-size: 0.9rem;
      }
    }

    @media (max-width: 576px) {
      .hero-slider {
        height: 70vh;
      }
      
      .hero-content {
        padding: 25px 20px;
      }
      
      .hero-content h1 {
        font-size: 1.7rem;
      }
      
      .hero-content h1 span {
        font-size: 1.4rem;
      }
      
      .hero-content p {
        font-size: 1rem;
      }
      
      .cta-btn {
        padding: 14px 25px;
        font-size: 1rem;
      }
      
      .slider-indicators {
        bottom: 25px;
        padding: 8px 12px;
      }

      .service-features {
        gap: 10px;
      }

      .feature-tag {
        font-size: 0.8rem;
        padding: 6px 12px;
      }
    }

    /* Animation for content */
    @keyframes fadeInUp {
      from {
        opacity: 0;
        transform: translateY(30px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .hero-content {
      animation: fadeInUp 1s ease-out;
    }
  </style>
</head>

<body>

  <!-- Navigation Placeholder -->
  @include('nav')

  <div class="container py-5" dir="rtl" >
    <div class="privacy-policy">
      <h1 class="mb-4">سياسة الخصوصية</h1>

      <h2>من نحن</h2>
      <p><strong>النص المقترح:</strong> عنوان موقعنا الإلكتروني هو: 
        <a href="https://curtainsserviceriyadh.shop" target="_blank">
         https://curtainsserviceriyadh.shop
        </a>.
      </p>

      <h2>التعليقات</h2>
      <p><strong>النص المقترح:</strong> عندما يترك الزوار تعليقات على الموقع، نقوم بجمع البيانات المعروضة في نموذج التعليقات، بالإضافة إلى عنوان الـ IP الخاص بالزائر وسلسلة بيانات متصفح المستخدم للمساعدة في اكتشاف الرسائل المزعجة.</p>

      <p>قد يتم تقديم سلسلة مجهولة تم إنشاؤها من عنوان بريدك الإلكتروني (تُسمى أيضًا Hash) إلى خدمة Gravatar لمعرفة ما إذا كنت تستخدمها. سياسة الخصوصية لخدمة Gravatar متاحة هنا: 
        <a href="https://curtainsserviceriyadh.shop/privacy-policy/" target="_blank">
         https://curtainsserviceriyadh.shop/privacy-policy/
        </a>. بعد الموافقة على تعليقك، ستظهر صورة ملفك الشخصي للعامة في سياق تعليقك.
      </p>

      <h2>الوسائط</h2>
      <p><strong>النص المقترح:</strong> إذا قمت بتحميل صور إلى الموقع الإلكتروني، يجب عليك تجنب تحميل الصور التي تحتوي على بيانات مواقع مدمجة (EXIF GPS). بإمكان زوار الموقع تحميل واستخراج أي بيانات موقع من الصور الموجودة على الموقع.</p>

      <h2>ملفات تعريف الارتباط (Cookies)</h2>
      <p><strong>النص المقترح:</strong> إذا تركت تعليقًا على موقعنا، يمكنك اختيار حفظ اسمك، وعنوان بريدك الإلكتروني، وموقعك الإلكتروني في ملفات تعريف الارتباط. هذه لمساعدتك حتى لا تضطر لإعادة ملء بياناتك عند ترك تعليق آخر. ستستمر هذه الملفات لمدة عام.</p>

      <p>إذا زرت صفحة تسجيل الدخول الخاصة بنا، سنقوم بتعيين ملف تعريف ارتباط مؤقت لتحديد ما إذا كان متصفحك يقبل ملفات تعريف الارتباط. لا يحتوي هذا الملف على أي بيانات شخصية وسيتم حذفه عند إغلاق المتصفح.</p>

      <p>عند تسجيل الدخول، سنقوم بإعداد عدة ملفات تعريف ارتباط لحفظ معلومات تسجيل الدخول وخيارات عرض الشاشة الخاصة بك. تدوم ملفات تعريف ارتباط تسجيل الدخول ليومين، وتدوم ملفات تعريف الارتباط الخاصة بخيارات العرض لمدة عام. إذا اخترت "تذكرني"، سيظل تسجيل دخولك مستمرًا لمدة أسبوعين. عند تسجيل الخروج من حسابك، ستتم إزالة ملفات تعريف ارتباط تسجيل الدخول.</p>

      <p>إذا قمت بتحرير أو نشر مقال، سيتم حفظ ملف تعريف ارتباط إضافي في متصفحك. لا يحتوي هذا الملف على أي بيانات شخصية ويدل فقط على معرف المنشور الخاص بالمقال الذي قمت بتحريره للتو. تنتهي صلاحيته بعد يوم واحد.</p>

      <h2>المحتوى المضمن من مواقع أخرى</h2>
      <p><strong>النص المقترح:</strong> قد تتضمن المقالات على هذا الموقع محتوى مضمّن (مثل مقاطع الفيديو، الصور، المقالات، وما إلى ذلك). يتصرف المحتوى المضمّن من مواقع أخرى بنفس الطريقة كما لو أن الزائر قد زار الموقع الآخر.</p>

      <p>قد تقوم هذه المواقع بجمع بيانات عنك، واستخدام ملفات تعريف الارتباط، وتضمين تتبع إضافي من طرف ثالث، ومراقبة تفاعلك مع هذا المحتوى المضمّن، بما في ذلك تتبع تفاعلك مع المحتوى المضمّن إذا كان لديك حساب وقمت بتسجيل الدخول إلى ذلك الموقع.</p>

      <h2>مع من نشارك بياناتك</h2>
      <p><strong>النص المقترح:</strong> إذا طلبت إعادة تعيين كلمة المرور، سيتم تضمين عنوان IP الخاص بك في رسالة إعادة التعيين.</p>

      <h2>مدة احتفاظنا ببياناتك</h2>
      <p><strong>النص المقترح:</strong> إذا تركت تعليقًا، فسيتم الاحتفاظ بالتعليق وبياناته الوصفية إلى أجل غير مسمى. هذا حتى نتمكن من التعرف على التعليقات والموافقة عليها تلقائيًا بدلاً من الاحتفاظ بها في قائمة انتظار المراجعة.</p>

      <p>بالنسبة للمستخدمين الذين يسجلون على موقعنا (إن وجد)، نقوم أيضًا بتخزين المعلومات الشخصية التي يقدمونها في ملفاتهم الشخصية. يمكن لجميع المستخدمين رؤية أو تعديل أو حذف معلوماتهم الشخصية في أي وقت (باستثناء عدم تمكنهم من تغيير اسم المستخدم). كما يمكن لمسؤولي الموقع رؤية وتعديل تلك المعلومات.</p>

      <h2>ما هي الحقوق التي لديك على بياناتك</h2>
      <p><strong>النص المقترح:</strong> إذا كان لديك حساب على هذا الموقع، أو تركت تعليقات، يمكنك طلب الحصول على ملف مُصدَّر للبيانات الشخصية التي نحتفظ بها عنك، بما في ذلك أي بيانات قدمتها لنا. يمكنك أيضًا طلب مسح أي بيانات شخصية نحتفظ بها عنك. لا يشمل ذلك أي بيانات نحن ملزمون بالاحتفاظ بها لأغراض إدارية أو قانونية أو أمنية.</p>

      <h2>أين تُرسل بياناتك</h2>
      <p><strong>النص المقترح:</strong> قد يتم التحقق من تعليقات الزوار من خلال خدمة كشف الرسائل المزعجة التلقائية.</p>
    </div>
  </div>



@include('footer')

 
    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- WOW.js for animations -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/wow/1.1.2/wow.min.js"></script>
<script>
        new WOW().init();
    </script>
<script>
  document.addEventListener('DOMContentLoaded', function() {
    const container = document.querySelector('.ba-container');
    const before = container.querySelector('.ba-before');
    const handle = container.querySelector('.ba-handle');

    const onMove = e => {
      const rect = container.getBoundingClientRect();
      const x = (e.touches ? e.touches[0].clientX : e.clientX) - rect.left;
      const pct = Math.max(0, Math.min(x, rect.width));
      before.style.width = pct + 'px';
      handle.style.left = pct + 'px';
    };
    handle.addEventListener('mousedown', () => {
      document.addEventListener('mousemove', onMove);
    });
    document.addEventListener('mouseup', () => {
      document.removeEventListener('mousemove', onMove);
    });
    // Touch events
    handle.addEventListener('touchstart', () => {
      document.addEventListener('touchmove', onMove);
    });
    document.addEventListener('touchend', () => {
      document.removeEventListener('touchmove', onMove);
    });
  });
</script>


    <script>
        // Initialize WOW.js
        new WOW().init();
        
        // Auto-rotate carousel every 5 seconds
        document.addEventListener('DOMContentLoaded', function() {
            var myCarousel = document.getElementById('heroCarousel');
            var carousel = new bootstrap.Carousel(myCarousel, {
                interval: 5000,
                ride: 'carousel'
            });
        });
    </script>
    <!-- Add this JavaScript -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const dropdownElement = document.getElementById('servicesDropdown');
    const dropdownLink = document.getElementById('servicesDropdownLink');
    
    // Hover functionality
    dropdownElement.addEventListener('mouseenter', function() {
        const dropdown = new bootstrap.Dropdown(dropdownLink);
        dropdown.show();
    });
    
    dropdownElement.addEventListener('mouseleave', function() {
        const dropdown = bootstrap.Dropdown.getInstance(dropdownLink);
        dropdown.hide();
    });
    
    // Click functionality - navigate to services page
    dropdownLink.addEventListener('click', function(e) {
        // Only navigate if clicking directly on the main link (not when dropdown is open)
        if (!dropdownElement.classList.contains('show')) {
            window.location.href = this.href;
        }
    });
});
</script>

</body>
</html>