
<!-- resources/views/layouts/app.blade.php -->
<!DOCTYPE html>
<html lang="en">
<head>
   <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
     <title>FAJ Technical Services LLC</title>
    <link rel="icon" href="<?php echo e(asset('assets/image.jpg')); ?>">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <!-- Animate.css for wow effects -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #333;
        }
        .navbar-top {
  background-color: #050b23;
  color: #fff;
  font-size: 0.9rem;
  padding: 0.4rem 20px; /* Reduced padding for smaller height */
}

/* Center content in the top bar */
.navbar-top .contact-center {
  flex: 1;
  display: flex;
  justify-content: center;
  gap: 2rem;
}

.navbar-top a {
  color: #fff;
  text-decoration: none;
  margin-left: 1rem;
}

/* ☑️ Main Navbar - Increased Height */
.navbar-main {
  background-color: #f8f9fa;
  padding: 1.5rem 30px; /* Increased padding for height */
   box-shadow: inset 0 -2px 0 #050b23;  /* Bottom black line (like black border) */
  position: relative;
  z-index: 10;
}

/* Navigation links */
.navbar-main .nav-link {
  color: #0e1d40;
  font-weight: 500;
  margin: 0 0.5rem;
  padding-bottom: 4px;
}

.navbar-main .nav-link:hover,
.navbar-main .nav-link:focus {
  color: #003d5c;
}

/* ☑️ Book Now Button */
.book-btn {
  background-color: #003d5c;
  color: #fff;
  font-weight: 600;
  padding: 0.5rem 1.25rem;
  border-radius: 0.25rem;
}

.book-btn:hover {
  background-color: #00557a;
  color: #fff;
}

.book-btn .bi {
  font-size: 1.1rem;
  vertical-align: middle;
  margin-left: 0.25rem;
}

/* ☑️ Logo Styling */
.faj-logo {
  height: 140px;
  width: auto;
  object-fit: contain;
  padding: 0;
  margin: 0;
  display: block;
  position: relative;
  top: -20px;
}

/* ☑️ Responsive Logo */
@media (max-width: 768px) {
 .navbar-collapse {
    background-color: #000 !important; /* Set background color to black */
  }

  .navbar-nav .nav-link {
    color: #fff !important; /* Make the menu links white for contrast */
  }
  .faj-logo {
    height: 100px;         /* Not too small like 50px */
    width: auto;
    top: -10px;
    margin: 0;
    padding: 0;
    object-fit: contain;
    display: block;
        background-color: #000 !important;

  }
}

        .cs_hero {
            min-height: 80vh;
            background-size: cover;
            background-position: center;
            display: flex;
            align-items: center;
            position: relative;
            padding: 80px 0;
        }
        
        .cs_hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
        }
        
        .cs_hero_text {
            position: relative;
            z-index: 2;
            color: white;
            text-align: center;
        }
        
        .cs_hero_title {
            font-weight: 700;
            line-height: 1.2;
        }
        
        .cs_hero_subtitle {
            font-size: 1.2rem;
            max-width: 700px;
            margin-left: auto;
            margin-right: auto;
        }
        
        .cs_hero_btns {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 30px;
            flex-wrap: wrap;
        }
        
        .cs_btn {
            display: inline-flex;
            align-items: center;
            padding: 12px 30px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .cs_btn.cs_style_1 {
            background-color: #fff;
            color: #333;
        }
        
        .cs_btn.cs_style_1:hover {
            background-color: #f8f9fa;
            transform: translateY(-3px);
        }
        
        .cs_btn i {
            margin-left: 8px;
        }
        
        .cs_hero_number {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .cs_hero_number_icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .cs_hero_number a {
            color: white;
            text-decoration: none;
        }
        
        /* Slider dots customization */
        .carousel-indicators button {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            margin: 0 5px;
            border: none;
            background-color: rgba(255, 255, 255, 0.5);
        }
        
        .carousel-indicators .active {
            background-color: white;
        }
        .btn1 {
  margin-left: 250px;
}
.text1 {
  margin-left: 130px;
}

         .hero-banner {
        background-color: rgba(0, 0, 0, 0.6);
        background-blend-mode: overlay;
        padding: 80px 0;
        position: relative;
         }
    
       .hero-banner::before {
        content: "";
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.5);
        z-index: -1;
        }
    
      .hero-banner h1 {
        font-size: 2.5rem;
        font-weight: 600;
       }
    
        .hero-banner p {
        font-size: 1.1rem;
        line-height: 1.6;
       }
    
       .hero-banner .btn-primary {
        background-color: #0d6efd;
        border-color: #0d6efd;
        font-weight: 500;
        border-radius: 4px;
        transition: all 0.3s;
       }
    
       .hero-banner .btn-primary:hover {
        background-color: #0b5ed7;
        border-color: #0b5ed7;
        transform: translateY(-2px);
      }
        
        .navbar {
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }
        
        .main-heading {
            color: #4a5568;
            font-weight: 600;
        }
        
        .sub-heading {
            color: #718096;
            font-weight: 400;
        }
        
        .filter-section {
            display: flex;
            justify-content: flex-end;
            align-items: center;
            margin-bottom: 2rem;
        }
        
        .job-type-heading {
            display: flex;
            align-items: baseline;
            margin-bottom: 1.5rem;
        }
        
        .job-count {
            color: #718096;
            font-size: 0.9rem;
            margin-left: 0.75rem;
            font-weight: normal;
        }
        
        .job-card {
            border: 1px solid #e2e8f0;
            border-radius: 0.375rem;
            padding: 1.25rem;
            margin-bottom: 1.5rem;
            transition: all 0.2s;
        }
        
        .job-card:hover {
            box-shadow: 0 4px 6px rgba(0,0,0,0.05);
            transform: translateY(-2px);
        }
        
        .job-position-type {
            color: #718096;
            font-size: 0.875rem;
            margin-bottom: 0.5rem;
        }
        
        .job-title {
            color: #3182ce;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }
        
        .job-title a {
            color: #3182ce;
            text-decoration: none;
        }
        
        .job-title a:hover {
            text-decoration: underline;
        }
        
        .job-location {
            color: #4a5568;
            font-size: 0.9rem;
        }
        
        .more-button {
            display: inline-block;
            border: 1px solid #3182ce;
            color: #3182ce;
            padding: 0.5rem 2rem;
            border-radius: 2rem;
            font-size: 0.875rem;
            transition: all 0.2s;
        }
        
        .more-button:hover {
            background-color: #3182ce;
            color: white;
        }
        
        .breadcrumb {
            color: #3182ce;
            text-decoration: none;
            display: flex;
            align-items: center;
            margin-bottom: 2rem;
        }
        
        .breadcrumb a {
            color: #3182ce;
            text-decoration: none;
        }
        
        .breadcrumb a:hover {
            text-decoration: underline;
        }
        
        .job-description h5 {
            color: #2d3748;
            font-weight: 600;
            margin-top: 2rem;
            margin-bottom: 1rem;
        }
        
        .job-description ul {
            margin-top: 1rem;
            padding-left: 1.5rem;
        }
        
        .job-description li {
            margin-bottom: 0.75rem;
        }
        
        .interested-button {
            background-color: #3182ce;
            color: white;
            padding: 0.5rem 2rem;
            border: none;
            border-radius: 0.25rem;
            font-size: 1rem;
            cursor: pointer;
            transition: all 0.2s;
        }
        
        .interested-button:hover {
            background-color: #2c5282;
        }
        
        .job-info-card {
            background-color: #f7fafc;
            border-radius: 0.375rem;
            padding: 1.5rem;
        }
        
        .job-info-title {
            color: #2d3748;
            font-weight: 600;
            margin-bottom: 1.5rem;
        }
        
        .job-info-item {
            margin-bottom: 1rem;
        }
        
        .job-info-label {
            color: #4a5568;
            font-weight: 600;
            font-size: 0.9rem;
        }
        
        .job-info-value {
            color: #4a5568;
            font-size: 0.9rem;
        }
        
        .form-card {
            background-color: white;
            border-radius: 0.375rem;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            padding: 2rem;
        }
        
        .form-title {
            color: #2d3748;
            font-weight: 600;
            margin-bottom: 1.5rem;
        }
        
        .form-control {
            padding: 0.75rem;
            border: 1px solid #e2e8f0;
            border-radius: 0.25rem;
        }
        
        .submit-button {
            background-color: #3182ce;
            color: white;
            padding: 0.75rem;
            border: none;
            border-radius: 0.25rem;
            font-size: 1rem;
            cursor: pointer;
            transition: all 0.2s;
            width: 100%;
        }
        
        .submit-button:hover {
            background-color: #2c5282;
        }
    </style>
    
    </head>
<body>
      <div class="navbar-top d-flex justify-content-between align-items-center">
    <!-- Left padding space is already handled by padding -->
    <div class="contact-center">
      <span><i class="bi bi-telephone-fill"></i> +971 4 330 0002</span>
      <span><i class="bi bi-whatsapp"></i> +971 50 746 4712</span>
      <span><i class="bi bi-geo-alt-fill"></i> Dubai – United Arab Emirates</span>
    </div>
    <div class="d-flex align-items-center">
      <a href="#"><i class="bi bi-instagram"></i></a>
      <a href="#" class="ms-3"><i class="bi bi-twitter"></i></a>
      <a href="#" class="ms-3"><i class="bi bi-youtube"></i></a>
      <a href="#" class="ms-3"><i class="bi bi-facebook"></i></a>
    </div>
  </div>

  <!-- 📌 Main Navbar -->
 <nav class="navbar navbar-expand-lg navbar-main shadow-sm" style="height: 80px; padding: 0;">
  <div class="container-fluid px-0">

    <!-- ✅ Logo: Smaller height & proportional width -->
<a class="navbar-brand d-flex align-items-center" href="<?php echo e(url('/')); ?>">
  <img src="<?php echo e(asset('Assets/logo.png')); ?>" alt="FAJ Logo" class="faj-logo" style="margin-top: 3px;">
</a>

      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNavbar">
        <span class="navbar-toggler-icon"></span>
      </button>

      <div class="collapse navbar-collapse" id="mainNavbar">
        <ul class="navbar-nav mx-auto mb-2 mb-lg-0">
          <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/')); ?>">Home</a></li>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">Services</a>
            <ul class="dropdown-menu">
              <li><a class="dropdown-item" href="<?php echo e(url('/services')); ?>">All Services</a></li>
            </ul>
          </li>
          <li class="nav-item"><a class="nav-link" href="<?php echo e(route('careers')); ?>">Careers</a></li>
          <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/blogs')); ?>">Blogs</a></li>
          <li class="nav-item"><a class="nav-link" href="<?php echo e(route('about')); ?>">About Us</a></li>
          <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/contact')); ?>">Contact Us</a></li>
        </ul>

        <a href="#" class="book-btn text-decoration-none d-flex align-items-center">
          BOOK NOW <i class="bi bi-arrow-up-right"></i>
        </a>
      </div>
    </div>
  </nav>
    <div class="hero-banner" style="background-image: url('Assets/background.jpg'); background-size: cover; background-position: center;">
    <div class="container text-center text-white py-5">
        <div class="py-5">
            <h5 class="mb-4">Find the career of your dreams</h5>
            <h1 class="mb-3">We're more than just a workplace. We're a family.</h1>
            <p class="mx-auto" style="max-width: 800px;">
                We know that finding a meaningful and rewarding job can be a long journey. Our goal is to make that process as easy as possible for you, and to create a work environment that's satisfying - one where you'll look forward to coming to every day. Start your journey with us by browsing available jobs.
            </p>
            <a href="/" class="btn btn-primary mt-4 px-4 py-2">View Openings</a>
        </div>
    </div>
</div>
    <main>
        <div class="container mt-5">
    <div class="text-center mb-5">
        <h1 class="main-heading mb-2">Join us at F A J</h1>
        <h3 class="sub-heading">Current Openings</h3>
    </div>

    <div class="filter-section">
        <div class="d-flex align-items-center">
            <span class="me-2">Filter by</span>
            <select class="form-select" style="width: 150px;">
                <option selected>All</option>
                <option>Full time</option>
                <option>Temporary</option>
                                <option>F A J Technical Service</option>
                                <option>F A J Trading LLC</option>
                                <option>F A J IT Solutions</option>
                                <option>FAJ TEAM</option>
                            </select>
        </div>
    </div>

    <!-- Display jobs organized by company -->
                                <div class="job-type-heading mt-5">
            <h2>F A J Trading LLC</h2>
            <span class="job-count">2 JOBS</span>
        </div>
        
        <div class="row">
                        <div class="col-md-4 mb-4">
                <div class="job-card h-100">
                    <div class="job-position-type">Full time</div>
                    <h5 class="job-title">
                    <a href="/">Operations Assistant for Sales and Purchase Department for E-commerce Inquiries</a>
                    </h5>
                    <p class="job-location mb-0">Islamabad, Pakistan</p>
                </div>
            </div>
                        <div class="col-md-4 mb-4">
                <div class="job-card h-100">
                    <div class="job-position-type">Full time</div>
                    <h5 class="job-title">
                    <a href="/">Receptionist and Administrative Assistant</a>
                    </h5>
                    <p class="job-location mb-0">Islamabad, Pakistan</p>
                </div>
            </div>
                    </div>
                            <div class="job-type-heading mt-5">
            <h2>F A J IT Solutions</h2>
            <span class="job-count">2 JOBS</span>
        </div>
        
        <div class="row">
                        <div class="col-md-4 mb-4">
                <div class="job-card h-100">
                    <div class="job-position-type">Full time</div>
                    <h5 class="job-title">
                    <a href="/">Senior SEO Specialist</a>
                    </h5>
                    <p class="job-location mb-0">Islamabad, Pakistan</p>
                </div>
            </div>
                        <div class="col-md-4 mb-4">
                <div class="job-card h-100">
                    <div class="job-position-type">Full time</div>
                    <h5 class="job-title">
                    <a href="/">Outreach SEO Link Builder</a>
                    </h5>
                    <p class="job-location mb-0">Islamabad, Pakistan</p>
                </div>
            </div>
                    </div>
                            
    <!-- Jobs without companies -->
    
    <!-- No jobs message -->
    </div>
    </main>

<footer class="bg-dark text-white" style="background-image: url('Assets/footer_bg.avif'); background-size: cover;">
  <div class="container py-5">
    <div class="row">
      <!-- About Column -->
      <div class="col-md-6 col-lg-3 mb-4">
        <div class="footer-widget">
          <h4 class="h5 mb-3">About</h4>
          <div class="d-flex mb-3">
            <span class="bg-primary" style="width: 30px; height: 2px;"></span>
            <span class="bg-white mx-1" style="width: 15px; height: 2px;"></span>
            <span class="bg-white" style="width: 15px; height: 2px;"></span>
          </div>
          <p class="mb-4">Reach out to our knowledgeable and friendly customer service team for assistance. We are just a call away.</p>
          <div class="social-icons d-flex">
            <a href="https://www.instagram.com/fajtechnicalservicesllc/" class="text-white me-3"><i class="bi bi-instagram fs-5"></i></a>
            <a href="https://twitter.com/FAJTechnical/" class="text-white me-3"><i class="bi bi-twitter fs-5"></i></a>
            <a href="https://www.youtube.com/@fajtechnicalservicesllc" class="text-white me-3"><i class="bi bi-youtube fs-5"></i></a>
            <a href="https://www.facebook.com/FAJTechnicalServicesLLC" class="text-white"><i class="bi bi-facebook fs-5"></i></a>
          </div>
        </div>
      </div>

      <!-- Explore Column -->
      <div class="col-md-6 col-lg-3 mb-4">
        <div class="footer-widget">
          <h4 class="h5 mb-3">Explore</h4>
          <div class="d-flex mb-3">
            <span class="bg-primary" style="width: 30px; height: 2px;"></span>
            <span class="bg-white mx-1" style="width: 15px; height: 2px;"></span>
            <span class="bg-white" style="width: 15px; height: 2px;"></span>
          </div>
          <ul class="list-unstyled">
            <li class="mb-2"><a href="/" class="text-white text-decoration-none">AC Service in Dubai</a></li>
            <li class="mb-2"><a href="/" class="text-white text-decoration-none">Refrigerator Repair</a></li>
            <li class="mb-2"><a href="/" class="text-white text-decoration-none">Washing Machine Repair</a></li>
            <li class="mb-2"><a href="/" class="text-white text-decoration-none">Coffee Machine Repair & Maintenance</a></li>
            <li><a href="/" class="text-white text-decoration-none">Vacuum Cleaner Repair & Robot Vacuum Service</a></li>
          </ul>
        </div>
      </div>

      <!-- Contact Us Column -->
      <div class="col-md-6 col-lg-3 mb-4">
        <div class="footer-widget">
          <h4 class="h5 mb-3">Contact Us</h4>
          <div class="d-flex mb-3">
            <span class="bg-primary" style="width: 30px; height: 2px;"></span>
            <span class="bg-white mx-1" style="width: 15px; height: 2px;"></span>
            <span class="bg-white" style="width: 15px; height: 2px;"></span>
          </div>
          <ul class="list-unstyled">
            <li class="mb-3 d-flex">
              <i class="bi bi-geo-alt-fill me-2"></i>
              <span>Warehouse # 2, Street 18b, Al Quoz Industrial Area # 4, Dubai, UAE</span>
            </li>
            <li class="mb-3 d-flex">
              <i class="bi bi-telephone-fill me-2"></i>
              <div>
                <a href="tel:+97143300002" class="text-white text-decoration-none d-block">+971 4 330 0002</a>
                <a href="tel:+971507464712" class="text-white text-decoration-none">+971 50 746 4712</a>
              </div>
            </li>
            <li class="d-flex">
              <i class="bi bi-envelope-fill me-2"></i>
              <a href="mailto:info@fajservices.ae" class="text-white text-decoration-none">info@fajservices.ae</a>
            </li>
          </ul>
        </div>
      </div>

      <!-- Working Hours Column -->
      <div class="col-md-6 col-lg-3 mb-4">
        <div class="footer-widget">
          <h4 class="h5 mb-3">Working Hours</h4>
          <div class="d-flex mb-3">
            <span class="bg-primary" style="width: 30px; height: 2px;"></span>
            <span class="bg-white mx-1" style="width: 15px; height: 2px;"></span>
            <span class="bg-white" style="width: 15px; height: 2px;"></span>
          </div>
          <ul class="list-unstyled">
            <li class="d-flex justify-content-between mb-2">
              <span>Mon - Sat</span>
              <span>8:00 AM - 6:00 PM</span>
            </li>
            <li class="d-flex justify-content-between">
              <span>Sunday</span>
              <span>12:00 PM - 6:00 PM</span>
            </li>
          </ul>
        </div>
      </div>
    </div>
  </div>

  <!-- Footer Bottom -->
  <div class="bg-primary py-3">
    <div class="container">
      <div class="d-md-flex justify-content-between align-items-center">
        <div class="mb-3 mb-md-0">
          <span class="text-light">Copyright © 2025 <a href="https://www.fajitsolutions.com/" class="text-light text-decoration-none">FAJ IT SOLUTIONS</a>. All Rights Reserved.</span>
        </div>
        <div>
          <img src="Assets/payment_card.png" alt="Payment Icon FAJ" class="img-fluid">
        </div>
      </div>
    </div>
  </div>

  <!-- Mobile WhatsApp/Call Buttons -->
  <div class="d-block d-lg-none fixed-bottom d-flex justify-content-end p-3" style="z-index: 1000;">
    <div class="d-flex">
      <a href="tel:+97143300002" class="btn btn-primary rounded-circle me-2 d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
        <i class="bi bi-telephone fs-5"></i>
      </a>
      <a href="https://api.whatsapp.com/send?phone=+971507464712&amp;text=FAJ-Services" class="btn btn-success rounded-circle d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
        <i class="bi bi-whatsapp fs-5"></i>
      </a>
    </div>
  </div>

  <!-- Floating Menu -->
  <div class="position-fixed bottom-0 end-0 mb-3 me-3" style="z-index: 1000;">
    <div id="ai-handset-widget" class="d-flex flex-column align-items-end">
      <div id="ai-popup" class="bg-primary text-white px-3 py-2 rounded-pill mb-2 shadow small d-none">Need Help? Let's Talk!</div>
      <div class="rounded-circle bg-primary d-flex align-items-center justify-content-center shadow" style="width: 50px; height: 50px;">
        <img id="ai-icon" src="Assets/aiicon-D8CSMah2.png" alt="AI" style="width: 30px; height: 30px;">
      </div>
    </div>
  </div>

  <!-- Floating WhatsApp/Call -->
 <div class="position-fixed bottom-0 d-none d-lg-block" style="z-index: 999;">
  <!-- Left side (call button) -->
  <div class="start-0 mb-5 ms-5" style="position: fixed; bottom: 0; left: 0;">
    <a href="tel:+97143300002" class="d-flex align-items-center text-decoration-none">
      <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-2" style="width: 40px; height: 40px;">
        <i class="bi bi-telephone"></i>
      </div>
      <span class="bg-dark text-white px-3 py-2 rounded">+97143300002</span>
    </a>
  </div>
  
  <!-- Right side (WhatsApp) -->
  <div class="position-fixed d-none d-lg-block" style="z-index: 999;">
  <!-- WhatsApp (Right Side, Adjusted Position) -->
  <div style="position: fixed; bottom: 80px; right: 4px;">
    <a href="https://api.whatsapp.com/send?phone=+971507464712&amp;text=Hello-FAJ-Services" class="d-flex align-items-center text-decoration-none">
      <div class="bg-success text-white rounded-circle d-flex align-items-center justify-content-center me-2" style="width: 40px; height: 40px;">
        <i class="bi bi-whatsapp"></i>
      </div>
    </a>
  </div>

    </a>
  </div>
</div>
</footer>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- WOW.js for animations -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/wow/1.1.2/wow.min.js"></script>
<script>
    </body>
</html><?php /**PATH E:\fajservices\fajservices\resources\views/careers.blade.php ENDPATH**/ ?>