  <style>
        :root {
            --primary-color: #3D6B63;   /* main brand color (buttons, headings, links) */
            --secondary-color: #B85C38; /* accent / highlights (badges, icons) */
            --accent-color: #E6C66A;    /* support / call-to-action (buttons hover, highlights) */

            /* --- Neutrals derived from only these three colors --- */
            --bg-color: #FFF9F4;         /* use as background, very light neutral */
            --text-color: #3D6B63;       /* primary text */
            --text-muted: #B85C38;       /* secondary text, subheadings */
        }

        

        /* Top Contact Bar (Desktop Only) */
        .navbar-top {
            background: var(--primary-color);
            color: white;
            padding: 10px 0;
            border-bottom: 2px solid var(--accent-color);
        }

        .navbar-top a {
            color: white !important;
            text-decoration: none;
            transition: all 0.3s ease;
            font-weight: 500;
        }

        .navbar-top a:hover {
            color: var(--accent-color) !important;
            transform: translateY(-1px);
        }

        .social-icons a {
            color: white !important;
            font-size: 1.1rem;
            transition: all 0.3s ease;
            width: 36px;
            height: 36px;
            border-radius: 50%;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            background: rgba(255, 255, 255, 0.1);
        }

        .social-icons a:hover {
            background: var(--accent-color);
            color: var(--text-color) !important;
            transform: translateY(-2px);
        }

        /* Main Navbar */
        .navbar-main {
            background: var(--bg-color);
            min-height: 85px;
            box-shadow: 0 4px 20px rgba(61, 107, 99, 0.12);
            border-bottom: 3px solid var(--accent-color);
        }

        /* Logo */
        .navbar-brand {
            font-weight: 800;
            font-size: 1.8rem;
            color: var(--primary-color);
            text-decoration: none;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
        }

        .navbar-brand:hover {
            color: var(--secondary-color);
            transform: scale(1.05);
        }

        .navbar-brand span {
            color: var(--secondary-color);
        }

        .logo-placeholder {
            width: 180px;
            height: 50px;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 700;
            font-size: 1.2rem;
        }

        /* Nav Links */
        .nav-link {
            font-weight: 600;
            color: var(--text-color) !important;
            position: relative;
            padding: 10px 18px !important;
            margin: 0 6px;
            border-radius: 8px;
            transition: all 0.3s ease;
            font-size: 1.05rem;
        }

        .nav-link:hover {
            color: var(--secondary-color) !important;
            background: rgba(184, 92, 56, 0.08);
            transform: translateY(-2px);
        }

        .nav-link::after {
            content: '';
            position: absolute;
            bottom: -3px;
            right: 18px;
            width: 0;
            height: 3px;
            background: var(--secondary-color);
            transition: width 0.3s ease;
            border-radius: 2px;
        }

        .nav-link:hover::after {
            width: calc(100% - 36px);
        }

        /* WhatsApp Button */
        .book-btn {
            background: var(--secondary-color);
            color: white !important;
            border-radius: 12px;
            border: 2px solid var(--secondary-color);
            padding: 12px 28px;
            font-weight: 700;
            transition: all 0.3s ease;
            box-shadow: 0 6px 20px rgba(184, 92, 56, 0.3);
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            font-size: 1.1rem;
        }

        .book-btn:hover {
            background: var(--accent-color);
            color: var(--text-color) !important;
            border-color: var(--accent-color);
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(230, 198, 106, 0.4);
        }

        /* Custom Toggle Button */
        .navbar-toggler {
            width: 32px;
            height: 26px;
            border: none;
            padding: 0;
            position: relative;
            background: transparent;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        .toggler-icon {
            display: block;
            width: 100%;
            height: 3px;
            background: var(--primary-color);
            transition: all 0.3s ease;
            border-radius: 3px;
        }

        .navbar-toggler:not(.collapsed) .top-bar {
            transform: rotate(45deg) translate(6px, 6px);
            background: var(--secondary-color);
        }

        .navbar-toggler:not(.collapsed) .middle-bar {
            opacity: 0;
        }

        .navbar-toggler:not(.collapsed) .bottom-bar {
            transform: rotate(-45deg) translate(6px, -6px);
            background: var(--secondary-color);
        }

        /* Mobile Menu Overlay */
        .mobile-menu-overlay {
            position: fixed;
            top: 0;
            right: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 1049;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }

        .mobile-menu-overlay.show {
            opacity: 1;
            visibility: visible;
        }

        /* Slide-in Mobile Menu */
        @media (max-width: 991.98px) {
            .navbar-collapse {
                position: fixed;
                top: 0;
                right: -100%;
                width: 320px;
                height: 100vh;
                background: white;
                padding: 80px 30px 30px;
                box-shadow: -5px 0 25px white
                transition: right 0.4s ease-in-out;
                z-index: 1050;
                overflow-y: auto;
                border-left: 3px solid var(--accent-color);
            }

            .navbar-collapse.show {
                right: 0;
            }

            .navbar-nav {
                margin-top: 2rem;
                width: 100%;
            }

            .nav-item {
                margin-bottom: 1rem;
                width: 100%;
            }

            .nav-link {
                padding: 15px 20px !important;
                border-radius: 10px;
                text-align: right;
                font-size: 1.1rem;
                border: 2px solid transparent;
                width: 100%;
                margin: 0;
                display: block;
            }

            .nav-link:hover {
                border-color: var(--secondary-color);
                background: rgba(184, 92, 56, 0.05);
            }

            .book-btn {
                margin-top: 2rem;
                width: 100%;
                justify-content: center;
                padding: 15px;
                font-size: 1.1rem;
            }

            /* Mobile Close Button */
            .mobile-menu-close {
                position: absolute;
                top: 25px;
                left: 25px;
                background: var(--secondary-color);
                color: white;
                border: none;
                border-radius: 50%;
                width: 40px;
                height: 40px;
                font-size: 1.2rem;
                cursor: pointer;
                transition: all 0.3s ease;
                display: flex;
                align-items: center;
                justify-content: center;
                z-index: 1051;
            }

            .mobile-menu-close:hover {
                background: var(--accent-color);
                color: var(--text-color);
                transform: rotate(90deg);
            }
        }

        /* Desktop specific styles */
        @media (min-width: 992px) {
            .navbar-nav {
                gap: 8px;
            }

            .nav-link {
                font-size: 1rem;
            }

            .mobile-menu-overlay {
                display: none !important;
            }
        }

        /* Container adjustments */
        .container-fluid {
            padding-right: 1.5rem;
            padding-left: 1.5rem;
        }

        /* Active state for current page */
        .nav-link.active {
            color: var(--secondary-color) !important;
            background: rgba(184, 92, 56, 0.1);
        }

        .nav-link.active::after {
            width: calc(100% - 36px);
        }

        /* Demo content styles */
     
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .container-fluid {
                padding-right: 1rem;
                padding-left: 1rem;
            }

            .navbar-brand {
                font-size: 1.5rem;
            }

            .logo-placeholder {
                width: 150px;
                height: 45px;
                font-size: 1.1rem;
            }

            .navbar-top .contact-center {
                flex-direction: column;
                gap: 8px;
            }

            .navbar-top .contact-center span {
                margin: 0 !important;
            }
        }

        @media (max-width: 576px) {
            .navbar-collapse {
                width: 280px;
            }

            .logo-placeholder {
                width: 130px;
                height: 40px;
                font-size: 1rem;
            }

            .navbar-toggler {
                width: 28px;
                height: 24px;
            }
        }
    </style>


    <!-- Top Contact Bar (Desktop Only) -->
    <div class="navbar-top d-none d-lg-flex justify-content-between align-items-center py-2 px-4">
        <div class="contact-center d-flex align-items-center">
            <span class="me-5">
                <i class="bi bi-telephone-fill me-2"></i>
                <a href="tel:+966533681853">0533681853</a>
            </span>
            <span>
                <i class="bi bi-envelope-fill me-2"></i>
                <a href="mailto:info@curtainsupplierandmaker.shop">
                    info@curtainsupplierandmaker.shop
                </a>
            </span>
        </div>
        <div class="social-icons">
            <a href="#" class="mx-2"><i class="bi bi-instagram"></i></a>
            <a href="#" class="mx-2"><i class="bi bi-twitter"></i></a>
            <a href="#" class="mx-2"><i class="bi bi-youtube"></i></a>
            <a href="#" class="mx-2"><i class="bi bi-facebook"></i></a>
        </div>
    </div>

    <!-- Main Navbar -->
    <nav class="navbar navbar-expand-lg navbar-main py-3">
        <div class="container-fluid px-lg-4">

            <!-- Logo -->
           <a href="/" class="footer-logo">
        <img src="<?php echo e(asset('images/Curtains Maker & Supplier  Logo  A.png')); ?>" alt="ستائر الرياض Logo" style="height:60px;">
    </a>

            <!-- Mobile Toggle Button -->
            <button class="navbar-toggler collapsed" type="button" data-bs-toggle="collapse"
                    data-bs-target="#mainNavbar" aria-expanded="false" aria-label="Toggle navigation">
                <span class="toggler-icon top-bar"></span>
                <span class="toggler-icon middle-bar"></span>
                <span class="toggler-icon bottom-bar"></span>
            </button>

            <!-- Mobile Menu Overlay -->
            <div class="mobile-menu-overlay" id="mobileMenuOverlay"></div>

            <!-- Navbar Links -->
            <div class="collapse navbar-collapse" id="mainNavbar">
                <!-- Mobile close button -->
                <button class="mobile-menu-close d-lg-none" type="button" data-bs-toggle="collapse" 
                        data-bs-target="#mainNavbar" aria-expanded="false" aria-label="Close menu">
                    <i class="bi bi-x-lg"></i>
                </button>

                <ul class="navbar-nav mx-auto mb-2 mb-lg-0">
                   <li class="nav-item">
    <a class="nav-link <?php echo e(request()->routeIs('home') ? 'active' : ''); ?>" href="<?php echo e(route('home')); ?>">الرئيسية</a>
</li>
<li class="nav-item">
    <a class="nav-link <?php echo e(request()->routeIs('services') ? 'active' : ''); ?>" href="<?php echo e(route('services')); ?>">خدماتنا</a>
</li>
<li class="nav-item">
    <a class="nav-link <?php echo e(request()->routeIs('about') ? 'active' : ''); ?>" href="<?php echo e(route('about')); ?>">من نحن</a>
</li>
<li class="nav-item">
    <a class="nav-link <?php echo e(request()->routeIs('contact') ? 'active' : ''); ?>" href="<?php echo e(route('contact')); ?>">اتصل بنا</a>
</li>

                </ul>

                <!-- WhatsApp Button -->
                <div class="d-flex justify-content-center pb-3 pb-lg-0">
                    <a href="https://wa.me/966533681853"
                       class="book-btn btn px-4 py-2 text-decoration-none">
                        <i class="bi bi-whatsapp me-2"></i>
                        احجز الآن
                    </a>
                </div>
            </div>
        </div>
    </nav>

  
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const navLinks = document.querySelectorAll('.nav-link');
            const navbarCollapse = document.querySelector('.navbar-collapse');
            const mobileMenuOverlay = document.getElementById('mobileMenuOverlay');
            const mobileCloseBtn = document.querySelector('.mobile-menu-close');
            
            // Toggle mobile menu overlay
            navbarCollapse.addEventListener('show.bs.collapse', function () {
                mobileMenuOverlay.classList.add('show');
                document.body.style.overflow = 'hidden';
            });
            
            navbarCollapse.addEventListener('hide.bs.collapse', function () {
                mobileMenuOverlay.classList.remove('show');
                document.body.style.overflow = '';
            });
            
            // Close menu when clicking on overlay
            mobileMenuOverlay.addEventListener('click', function() {
                const bsCollapse = new bootstrap.Collapse(navbarCollapse);
                bsCollapse.hide();
            });
            
            // Close mobile menu when clicking on a link
            navLinks.forEach(link => {
                link.addEventListener('click', () => {
                    if (window.innerWidth < 992) {
                        const bsCollapse = new bootstrap.Collapse(navbarCollapse);
                        bsCollapse.hide();
                    }
                    
                    // Update active state
                    navLinks.forEach(nav => nav.classList.remove('active'));
                    link.classList.add('active');
                });
            });
            
            // Handle window resize
            window.addEventListener('resize', function() {
                if (window.innerWidth >= 992) {
                    document.body.style.overflow = '';
                }
            });
        });
    </script><?php /**PATH E:\project\6thmonths\curtainsupplierandmaker.shop\resources\views/nav.blade.php ENDPATH**/ ?>