<style>
        :root {
            --primary-color: #3D6B63;   /* main brand color (buttons, headings, links) */
            --secondary-color: #B85C38; /* accent / highlights (badges, icons) */
            --accent-color: #E6C66A;    /* support / call-to-action (buttons hover, highlights) */

            /* --- Neutrals derived from only these three colors --- */
            --bg-color: #FFF9F4;         /* use as background, very light neutral */
            --text-color: #3D6B63;       /* primary text */
            --text-muted: #B85C38;       /* secondary text, subheadings */
        }

      

        .process-section {
            background: linear-gradient(135deg, var(--bg-color) 0%, rgba(255, 249, 244, 0.8) 100%);
            padding: 80px 0;
            border-top: 3px solid var(--accent-color);
            border-bottom: 3px solid var(--accent-color);
        }

        .section-header {
            text-align: center;
            margin-bottom: 60px;
        }

        .section-decoration {
            display: flex;
            justify-content: center;
            align-items: center;
            margin-bottom: 20px;
            gap: 15px;
        }

        .decoration-star {
            color: var(--primary-color);
            font-size: 1.8rem;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.1); }
        }

        .section-badge {
            color: var(--primary-color);
            font-weight: 700;
            font-size: 1.1rem;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .section-title {
            color: var(--primary-color);
            font-weight: 800;
            margin-bottom: 20px;
            line-height: 1.2;
        }

        .section-subtitle {
            color: var(--text-muted);
            font-size: 1.2rem;
            max-width: 800px;
            margin: 0 auto;
            line-height: 1.6;
        }

        .section-subtitle strong {
            color: var(--secondary-color);
        }

        /* Process Cards */
        .process-card {
            background: white;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(61, 107, 99, 0.1);
            transition: all 0.4s ease;
            border: 2px solid transparent;
            height: 100%;
            position: relative;
        }

        .process-card:hover {
            transform: translateY(-12px);
            box-shadow: 0 20px 40px rgba(61, 107, 99, 0.2);
            border-color: var(--accent-color);
        }

        .step-number {
            position: absolute;
            top: 20px;
            right: 20px;
            font-size: 4rem;
            font-weight: 900;
            color: rgba(61, 107, 99, 0.08);
            line-height: 1;
            z-index: 1;
        }

        .step-icon {
            position: relative;
            z-index: 2;
            margin-bottom: 25px;
        }

        .icon-wrapper {
            width: 90px;
            height: 90px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto;
            color: white;
            font-size: 2.2rem;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
            transition: all 0.3s ease;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
        }

        .process-card:hover .icon-wrapper {
            transform: scale(1.15) rotate(8deg);
            box-shadow: 0 15px 30px rgba(184, 92, 56, 0.3);
        }

        .card-content {
            padding: 40px 30px 30px;
            text-align: center;
            position: relative;
            z-index: 2;
        }

        .step-title {
            color: var(--primary-color);
            font-weight: 700;
            margin-bottom: 20px;
            font-size: 1.4rem;
        }

        .step-description {
            color: var(--text-color);
            line-height: 1.8;
            margin-bottom: 0;
            font-size: 1rem;
        }

        .step-description strong {
            color: var(--secondary-color);
        }

        .phone-number {
            color: var(--secondary-color);
            font-weight: 700;
            font-size: 1.1rem;
            direction: ltr;
            display: inline-block;
            margin: 5px 0;
        }

        /* Additional Info */
        .additional-info {
            background: white;
            border-radius: 15px;
            padding: 30px;
            margin-top: 50px;
            box-shadow: 0 10px 30px rgba(61, 107, 99, 0.1);
            border: 2px solid var(--primary-color);
        }

        .info-title {
            color: var(--primary-color);
            font-weight: 700;
            margin-bottom: 20px;
            text-align: center;
        }

        .info-list {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .info-list li {
            padding: 12px 0;
            border-bottom: 1px solid rgba(61, 107, 99, 0.1);
            color: var(--text-color);
            display: flex;
            align-items: center;
            gap: 10px;
            transition: all 0.3s ease;
        }

        .info-list li:last-child {
            border-bottom: none;
        }

        .info-list li:hover {
            transform: translateX(-5px);
            color: var(--secondary-color);
        }

        .info-list li i {
            color: var(--secondary-color);
            font-size: 1.1rem;
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .process-section {
                padding: 60px 0;
            }

            .section-title {
                font-size: 2rem;
            }

            .section-subtitle {
                font-size: 1.1rem;
            }

            .step-number {
                font-size: 3rem;
            }

            .icon-wrapper {
                width: 80px;
                height: 80px;
                font-size: 2rem;
            }

            .card-content {
                padding: 30px 20px 25px;
            }
        }

        @media (max-width: 576px) {
            .process-section {
                padding: 40px 0;
            }

            .section-title {
                font-size: 1.7rem;
            }

            .section-subtitle {
                font-size: 1rem;
            }

            .step-number {
                font-size: 2.5rem;
            }

            .icon-wrapper {
                width: 70px;
                height: 70px;
                font-size: 1.8rem;
            }

            .step-title {
                font-size: 1.2rem;
            }

            .additional-info {
                padding: 20px;
                margin-top: 30px;
            }
        }
    </style>


    <section class="process-section">
        <div class="container">
            <div class="section-header">
                <div class="section-decoration">
                    <span class="decoration-star">✦</span>
                    <h6 class="section-badge mb-0">كيفية العمل</h6>
                    <span class="decoration-star">✦</span>
                </div>
                <h2 class="section-title display-5 fw-bold">خطوات الحصول على خدمة تفصيل الستائر</h2>
                <p class="section-subtitle lead">
                    4 خطوات بسيطة للحصول على أفضل خدمات <strong>تفصيل ستائر</strong> و<strong>تركيب ستائر فاخرة</strong> في الرياض بجودة واحترافية
                </p>
            </div>

            <div class="row g-4">
                
                <!-- Step 1 -->
                <div class="col-xl-3 col-md-6">
                    <div class="process-card">
                        <div class="step-number">01</div>
                        <div class="card-content">
                            <div class="step-icon">
                                <div class="icon-wrapper">
                                    <i class="bi bi-telephone-fill"></i>
                                </div>
                            </div>
                            <h5 class="step-title">اتصل بنا</h5>
                            <p class="step-description">
                                اتصل على <span class="phone-number">0533681853</span> لطلب خدمة <strong>تفصيل ستائر الرياض</strong> أو <strong>تركيب ستائر بلاك اوت</strong>. نقدم خدمة <strong>استشارة مجانية</strong> لجميع مناطق الرياض.
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Step 2 -->
                <div class="col-xl-3 col-md-6">
                    <div class="process-card">
                        <div class="step-number">02</div>
                        <div class="card-content">
                            <div class="step-icon">
                                <div class="icon-wrapper">
                                    <i class="bi bi-rulers"></i>
                                </div>
                            </div>
                            <h5 class="step-title">القياس والتصميم</h5>
                            <p class="step-description">
                                نزور منزلك للقياس الدقيق و<strong>تصميم الستائر</strong> المناسبة. نقدم <strong>استشارات ديكور</strong> مجانية لاختيار الأقمشة والألوان التي تناسب مساحتك.
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Step 3 -->
                <div class="col-xl-3 col-md-6">
                    <div class="process-card">
                        <div class="step-number">03</div>
                        <div class="card-content">
                            <div class="step-icon">
                                <div class="icon-wrapper">
                                    <i class="bi bi-scissors"></i>
                                </div>
                            </div>
                            <h5 class="step-title">التفصيل والتنفيذ</h5>
                            <p class="step-description">
                                <strong>تفصيل ستائر حسب الطلب</strong> بأعلى معايير الجودة. نستخدم <strong>أقمشة فاخرة</strong> ونتقن جميع تفاصيل <strong>التصميم والتنفيذ</strong>.
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Step 4 -->
                <div class="col-xl-3 col-md-6">
                    <div class="process-card">
                        <div class="step-number">04</div>
                        <div class="card-content">
                            <div class="step-icon">
                                <div class="icon-wrapper">
                                    <i class="bi bi-house-check"></i>
                                </div>
                            </div>
                            <h5 class="step-title">التركيب والضمان</h5>
                            <p class="step-description">
                                <strong>تركيب احترافي</strong> للستائر مع <strong>ضمان على العمل</strong>. نضمن لك <strong>جودة التصنيع</strong> و<strong>دقة التركيب</strong> مع متابعة بعد الخدمة.
                            </p>
                        </div>
                    </div>
                </div>

            </div>

            <!-- Additional Info -->
           
        </div>
    </section><?php /**PATH E:\project\6thmonths\curtainsupplierandmaker.shop\resources\views/workingSection.blade.php ENDPATH**/ ?>