<style>
    /* Custom CSS with your color scheme */
    .cs_height_80, .cs_height_lg_80 {
        height: 80px;
    }
    .cs_height_60 {
        height: 60px;
    }
    .cs_section_subtitle {
        font-size: 18px;
        margin-bottom: 12px;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        text-transform: uppercase;
        color: var(--secondary-color);
    }
    .cs_section_title {
        font-size: 40px;
        margin-bottom: 0;
        font-weight: 700;
        color: var(--primary-color);
    }
    .cs_row_gap_60 {
        row-gap: 60px;
    }
    .cs_card {
        position: relative;
        height: 100%;
        transition: all 0.3s ease;
        background-color: white;
        border-radius: 10px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.05);
    }
    .cs_card_thumbnail {
        position: relative;
        display: block;
        overflow: hidden;
        border-radius: 10px 10px 0 0;
    }
    .cs_card_thumbnail img {
        width: 100%;
        height: auto;
        transition: transform 0.3s ease;
    }
    .cs_card:hover .cs_card_thumbnail img {
        transform: scale(1.05);
    }
    .cs_card_info {
        padding: 25px;
    }
    .cs_card_title {
        font-size: 20px;
        margin-bottom: 15px;
        font-weight: 600;
        color: var(--primary-color);
    }
    .cs_card_subtitle {
        color: var(--text-color);
        margin-bottom: 20px;
        line-height: 1.6;
    }
    .form-control {
        border: 1px solid var(--border-color);
        padding: 12px 15px;
    }
    .form-control:focus {
        border-color: var(--secondary-color);
        box-shadow: 0 0 0 0.25rem rgba(197, 179, 88, 0.25);
    }
</style>

<section class="position-relative" style="margin-top: -170px; direction: rtl; background-color: var(--bg-color);">
  <div class="container mt-5">
    <div class="row">
      <div class="col-lg-6">
        <div class="position-relative">
          <div class="bg-white p-4 shadow-sm rounded">
            <div class="mb-4" style="height: 2px; width: 50px; background-color: var(--secondary-color);"></div>
            <h1 class="h3 mb-3" style="color: var(--primary-color);">متخصصون في أعمال الجبس بورد والأسقف المعلقة بالرياض</h1>
            <p class="mb-4" style="color: var(--text-color);">
              نقدم خدمات تركيب وتصميم <strong>ألواح الجبس بورد</strong> بجودة عالية وأسعار تنافسية في الرياض. نوفر جميع أنواع ألواح الجبس بورد بما في ذلك المقاومة للرطوبة وضد الحريق، مع تنفيذ احترافي لأعمال الأسقف المعلقة والديكورات الداخلية.
            </p>
            
            <div class="d-flex mb-3 align-items-center">
              <div class="ms-3">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="var(--secondary-color)" xmlns="http://www.w3.org/2000/svg">
                  <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"/>
                </svg>
              </div>
              <div>
                <p class="mb-0" style="color: var(--text-color);">الرياض، المملكة العربية السعودية</p>
              </div>
            </div>
            
            <div class="d-flex mb-3 align-items-center">
              <div class="ms-3">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="var(--secondary-color)" xmlns="http://www.w3.org/2000/svg">
                  <path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"/>
                </svg>
              </div>
              <div>
                <a href="mailto:info@falseceilingandgypsumwork.shop" style="color: var(--primary-color);">info@falseceilingandgypsumwork.shop</a>
              </div>
            </div>
            
            <div class="d-flex align-items-center">
              <div class="ms-3">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="var(--secondary-color)" xmlns="http://www.w3.org/2000/svg">
                  <path d="M20.01 15.38c-1.23 0-2.42-.2-3.53-.56-.35-.12-.74-.03-1.01.24l-1.57 1.97c-2.83-1.35-5.48-3.9-6.89-6.83l1.95-1.66c.27-.28.35-.67.24-1.02-.37-1.11-.56-2.3-.56-3.53 0-.54-.45-.99-.99-.99H4.19C3.65 3 3 3.24 3 3.99 3 13.28 10.73 21 20.01 21c.71 0 .99-.63.99-1.18v-3.45c0-.54-.45-.99-.99-.99z"/>
                </svg>
              </div>
              <div>
                <a href="tel:+966550220842" style="color: var(--primary-color);">0550220842</a>
              </div>
            </div>
          </div>
          
          
        </div>
      </div>
      
      <div class="col-lg-6">
        <div class="mb-4">
        
              <h2 class="h1 mb-0" style="color: var(--primary-color);">اطلب خدمة تركيب أو صيانة الجبس بورد</h2>
            </div>
            
           <style>
    /* Form Styling */
    #cs_form {
        background-color: white;
        border-radius: 12px;
        padding: 30px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--border-color);
    }
    
    #cs_form .form-control {
        border: 1px solid #8d6e63;
        border-radius: 8px;
        padding: 12px 15px;
        font-size: 15px;
        transition: all 0.3s ease;
        height: 48px;
    }
    
    #cs_form .form-control:focus {
        border-color: var(--secondary-color);
        box-shadow: 0 0 0 3px rgba(197, 179, 88, 0.2);
    }
    
    #cs_form textarea.form-control {
        height: auto;
        min-height: 120px;
    }
    
    #cs_form select.form-control {
        appearance: none;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='%235a4e3c' d='M7.247 11.14L2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 0.75rem center;
        background-size: 16px 12px;
    }
    
    #cs_form label {
        display: block;
        margin-bottom: 8px;
        font-weight: 500;
        color:#8d6e63;
    }
    
    #cs_form .form-group {
        margin-bottom: 20px;
    }
    
    #cs_form .btn-submit {
        background-color:#8d6e63;
        color: white;
        border: none;
        border-radius: 8px;
        padding: 12px 28px;
        font-weight: 600;
        font-size: 16px;
        transition: all 0.3s ease;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 100%;
    }
    
    #cs_form .btn-submit:hover {
        background-color:#8d6e63;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(90, 78, 60, 0.2);
    }
    
    #cs_form .btn-submit i {
        margin-right: 8px;
        transition: transform 0.3s ease;
    }
    
    #cs_form .btn-submit:hover i {
        transform: translateX(3px);
    }
    
    /* Form Header */
    .form-header {
        text-align: center;
        margin-bottom: 30px;
    }
    
    .form-header h3 {
        color:#8d6e63;
        font-weight: 700;
        margin-bottom: 10px;
    }
    
    .form-header p {
        color: var(--text-muted);
    }
    
    /* Responsive adjustments */
    @media (max-width: 767px) {
        #cs_form {
            padding: 20px;
        }
    }
</style>

<form id="cs_form">
    <div class="form-header">
        <h3>طلب خدمة الجبس بورد</h3>
        <p>املأ النموذج وسنتصل بك خلال 24 ساعة</p>
    </div>
    
    <div class="row g-3">
        <div class="col-md-6">
            <div class="form-group">
                <label for="name">الاسم الكامل</label>
                <input type="text" id="name" name="name" class="form-control" placeholder="أدخل اسمك بالكامل" required>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="form-group">
                <label for="phone">رقم الهاتف</label>
                <input type="tel" id="phone" name="phone" class="form-control" placeholder="مثال: 0550220842" required>
            </div>
        </div>
        
        <div class="col-12">
            <div class="form-group">
                <label for="service">نوع الخدمة المطلوبة</label>
                <select id="service" name="service" class="form-control" required>
                    <option value="" disabled selected>اختر من القائمة</option>
                    <option value="تركيب جبس بورد">تركيب جبس بورد</option>
                    <option value="أسقف معلقة">تصميم أسقف معلقة</option>
                    <option value="ديكورات جبس">ديكورات جبس داخلي</option>
                    <option value="صيانة جبس">صيانة وإصلاح الجبس</option>
                    <option value="استشارة فنية">استشارة فنية مجانية</option>
                </select>
            </div>
        </div>
        
        <div class="col-12">
            <div class="form-group">
                <label for="message">تفاصيل الطلب</label>
                <textarea id="message" name="message" class="form-control" rows="4" placeholder="أدخل تفاصيل المشروع أو الاستفسار" required></textarea>
            </div>
        </div>
        
        <div class="col-12 mt-2">
            <button type="submit" class="btn-submit">
                <i class="fas fa-paper-plane"></i>
                إرسال الطلب
            </button>
        </div>
    </div>
</form>
          </div>
        </div>
      </div>
    </section><?php /**PATH E:\project\3thMonths\Gypsum board\resources\views/newSection2.blade.php ENDPATH**/ ?>