<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <title>Gypsum Board Gypsum Selling | Best Gypsum Services in Riyadh</title>

  <!-- SEO Meta Tags -->
  <meta name="description" content="Specialists in all gypsum board and interior decoration work in Riyadh. High quality gypsum board services at affordable prices. Contact us for ceiling designs, wall partitions, and more.">
  <meta name="keywords" content="gypsum board, gypsum services, Riyadh gypsum, ceiling designs, gypsum partition, gypsum decoration, gypsum price Saudi Arabia">
  <meta name="author" content="Innovative Technologies">

  <!-- Canonical URL -->
  <link rel="canonical" href="https://www.gypsumboardandceilingworks.shop/">

  <!-- Open Graph Meta Tags (Facebook, etc.) -->
  <meta property="og:title" content="Gypsum Board Gypsum Selling | Best Gypsum Services in Riyadh">
  <meta property="og:description" content="We specialize in all gypsum board and interior decoration services in Riyadh. Get top quality designs and installations at the best prices.">
  <meta property="og:image" content="https://www.gypsumboardandceilingworks.shop/images/og-image.jpg">
  <meta property="og:url" content="https://www.gypsumboardandceilingworks.shop/">
  <meta property="og:type" content="website">

  <!-- Twitter Card -->
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="Gypsum Board Gypsum Selling | Best Gypsum Services in Riyadh">
  <meta name="twitter:description" content="Specialists in gypsum board and interior decoration work in Riyadh. Affordable prices and top quality service.">
  <meta name="twitter:image" content="https://www.gypsumboardandceilingworks.shop/images/og-image.jpg">

  <!-- Favicons -->
  <link rel="icon" href="images/cropped-WhatsApp-Image-2025-05-16-at-5.44.02-PM-32x32.jpeg" type="image/png" sizes="32x32">
  <link rel="icon" type="image/png" sizes="16x16" href="images/favicon-16x16.png">
  <link rel="icon" type="image/png" sizes="32x32" href="images/favicon-32x32.png">
  <link rel="apple-touch-icon" sizes="180x180" href="images/apple-touch-icon.png">

  <!-- Stylesheets -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>

  <!-- Robots -->
  <meta name="robots" content="index, follow">

   <meta name="google-site-verification" content="your-verification-code"> 
    <style>
        html, body {
    max-width: 100%;
    overflow-x: hidden;
}

/* Optional: Ensure all elements stay within viewport */
.container, .container-fluid {
    width: 100%;
    padding-right: 15px;
    padding-left: 15px;
    margin-right: auto;
    margin-left: auto;
}

.navbar-top {
  background-color: #050b23;
  color: #fff;
  font-size: 0.9rem;
  padding: 0.4rem 20px; /* Reduced padding for smaller height */
}

/* Center content in the top bar */
.navbar-top .contact-center {
  flex: 1;
  display: flex;
  justify-content: center;
  gap: 2rem;
}

.navbar-top a {
  color: #fff;
  text-decoration: none;
  margin-left: 1rem;
}

/* ☑️ Main Navbar - Increased Height */
.navbar-main {
  background-color: #f8f9fa;
  padding: 1.5rem 30px; /* Increased padding for height */
   box-shadow: inset 0 -2px 0  #003d5c;  /* Bottom black line (like black border) */
  position: relative;
  z-index: 10;
}

/* Navigation links */
.navbar-main .nav-link {
  color: #0e1d40;
  font-weight: 500;
  margin: 0 0.5rem;
  padding-bottom: 4px;
}

.navbar-main .nav-link:hover,
.navbar-main .nav-link:focus {
  color: #003d5c;
}

/* ☑️ Book Now Button */
.book-btn {
  background-color: #003d5c;
  color: #fff;
  font-weight: 600;
  padding: 0.5rem 1.25rem;
  border-radius: 0.25rem;
}

.book-btn:hover {
  background-color: #00557a;
  color: #fff;
}

.book-btn .bi {
  font-size: 1.1rem;
  vertical-align: middle;
  margin-left: 0.25rem;
}

/* ☑️ Logo Styling */
.faj-logo {
  height: 140px;
  width: auto;
  object-fit: contain;
  padding: 0;
  margin: 0;
  display: block;
  position: relative;
  top: -20px;
}

/* ☑️ Responsive Logo */
@media (max-width: 768px) {
 .navbar-collapse {
    background-color: #000 !important; /* Set background color to black */
  }

  .navbar-nav .nav-link {
    color: #fff !important; /* Make the menu links white for contrast */
  }
  .faj-logo {
    height: 100px;         /* Not too small like 50px */
    width: auto;
    top: -10px;
    margin: 0;
    padding: 0;
    object-fit: contain;
    display: block;
        background-color: #000 !important;

  }
}

        .cs_hero {
            min-height: 80vh;
            background-size: cover;
            background-position: center;
            display: flex;
            align-items: center;
            position: relative;
            padding: 80px 0;
        }
        
        .cs_hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
        }
        
        .cs_hero_text {
            position: relative;
            z-index: 2;
            color: white;
            text-align: center;
        }
        
        .cs_hero_title {
            font-weight: 700;
            line-height: 1.2;
        }
        
        .cs_hero_subtitle {
            font-size: 1.2rem;
            max-width: 700px;
            margin-left: auto;
            margin-right: auto;
        }
        
        .cs_hero_btns {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 30px;
            flex-wrap: wrap;
        }
        
        .cs_btn {
            display: inline-flex;
            align-items: center;
            padding: 12px 30px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .cs_btn.cs_style_1 {
            background-color: #fff;
            color: #333;
        }
        
        .cs_btn.cs_style_1:hover {
            background-color: #f8f9fa;
            transform: translateY(-3px);
        }
        
        .cs_btn i {
            margin-left: 8px;
        }
        
        .cs_hero_number {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .cs_hero_number_icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .cs_hero_number a {
            color: white;
            text-decoration: none;
        }
        
        /* Slider dots customization */
        .carousel-indicators button {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            margin: 0 5px;
            border: none;
            background-color: rgba(255, 255, 255, 0.5);
        }
        
        .carousel-indicators .active {
            background-color: white;
        }
        .btn1 {
  margin-left: 10px;
}
.text1 {
  margin-left: 10px;
}
.text2 {
  margin-left: 10px;
}

    </style>
</head>
<body>
   <?php echo $__env->make('nav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<section class="hero-slider">
    <div class="slider-container">
        <!-- Slide 1 - أعمال جبس بورد -->
        <div class="slide active" style="background-image: url('images/gypsum-board-installation.webp');">
            <div class="slide-content right">
                <div class="sub-title">أعمال الجبس بورد</div>
                <h1 class="title">تركيب ألواح جبس بورد بالرياض</h1>
                <div class="desc text-white">
                    <p>نقدم خدمات تركيب ألواح الجبس بورد بجميع المقاسات والتصاميم العصرية</p>
                    <p>أسعار تنافسية - جودة عالية - تنفيذ سريع</p>
                </div>
                <a href="tel:+966501434156" class="btn btn-slider">اتصل الآن</a>
            </div>
        </div>
        
        <!-- Slide 2 - ديكورات جبس -->
        <div class="slide" style="background-image: url('images/gypsum-decorations.webp');">
            <div class="slide-content left">
                <div class="sub-title">ديكورات جبس</div>
                <h1 class="title">أعمال الديكور والجبس للأسقف والجدران</h1>
                <div class="desc text-white">
                    <p>أحدث أشكال الديكورات الداخلية باستخدام ألواح جبس بورد سعودي ضد الرطوبة والحريق</p>
                    <p>ابتكار في التصاميم - تنفيذ احترافي - أسعار مناسبة</p>
                </div>
                <a href="https://api.whatsapp.com/send?phone=+966501434156" class="btn btn-slider">واتساب الآن</a>
            </div>
        </div>
        
        <!-- Slide 3 - أسعار ألواح الجبس -->
        <div class="slide" style="background-image: url('images/gypsum-board-prices.webp');">
            <div class="slide-content center">
                <div class="sub-title">أسعار الجبس بورد</div>
                <h1 class="title">أفضل أسعار ألواح الجبس بورد في الرياض</h1>
                <div class="desc text-white">
                    <p>نوفر لك جميع أنواع وأشكال ألواح الجبس بورد بأسعار مميزة وخامات عالية الجودة</p>
                    <p>أماكن بيع معروفة - مقاسات متعددة - أسعار تبدأ من 10 ريال للوح</p>
                </div>
            
               <a href="tel:+966501434156" class="btn btn-slider rounded-pill d-inline-flex align-items-center justify-content-center">
  <span>استفسر الآن</span>
  <i class="bi bi-arrow-left ms-2"></i> <!-- Bootstrap Icons arrow -->
</a>

<style>
  .btn-slider {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    padding: 12px 30px;
    background-color: #4CAF50;
    color: white;
    border: none;
    border-radius: 50px; /* Fully rounded */
    font-weight: 600;
    font-size: 1.1rem;
    text-decoration: none;
    transition: all 0.3s ease;
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    min-width: 160px; /* Ensures consistent round shape */
    text-align: center;
  }
  
  .btn-slider:hover {
    background-color: #3e8e41;
    color: white;
    transform: translateY(-3px);
    box-shadow: 0 6px 12px rgba(0,0,0,0.15);
  }
  
  .btn-slider:active {
    transform: translateY(1px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
  }
  
  /* RTL adjustments */
  .btn-slider i {
    margin-right: 8px;
    margin-left: 0;
  }
  
  /* Mobile responsiveness */
  @media (max-width: 768px) {
    .btn-slider {
      padding: 10px 25px;
      font-size: 1rem;
      min-width: 140px;
    }
  }
</style>
            </div>
        </div>
        
        <!-- Improved Slider Controls -->
        <div class="slider-controls">
            <div class="slider-dot active" data-slide="0"></div>
            <div class="slider-dot" data-slide="1"></div>
            <div class="slider-dot" data-slide="2"></div>
        </div>
    </div>
</section>

<style>
    /* Hero Slider Styles */
    .hero-slider {
        position: relative;
        width: 100%;
        height: 80vh;
        overflow: hidden;
        font-family: 'Tajawal', sans-serif;
        direction: rtl;
    }
    
    .slider-container {
        height: 100%;
        position: relative;
    }
    
    .slide {
        position: absolute;
        width: 100%;
        height: 100%;
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        opacity: 0;
        transition: opacity 1s ease-in-out;
        display: flex;
        align-items: center;
        padding: 0 5%;
    }
    
    .slide.active {
        opacity: 1;
        z-index: 1;
    }
    
    .slide-content {
        max-width: 600px;
        color: white;
        position: relative;
        z-index: 2;
        padding: 40px;
        background-color: rgba(0, 0, 0, 0.7);
        border-radius: 10px;
        animation: fadeInUp 1s ease-out;
    }
    
    /* Improved Slider Controls */
    .slider-controls {
        position: absolute;
        bottom: 30px;
        left: 50%;
        transform: translateX(-50%);
        z-index: 10;
        display: flex;
        gap: 8px;
        padding: 5px;
        background-color: rgba(0, 0, 0, 0.3);
        border-radius: 20px;
    }
    
    .slider-dot {
        width: 10px;
        height: 10px;
        border-radius: 50%;
        background-color: rgba(255, 255, 255, 0.5);
        cursor: pointer;
        transition: all 0.3s ease;
    }
    
    .slider-dot.active {
        background-color: #4CAF50;
        transform: scale(1.3);
    }
    
    /* Responsive adjustments */
    @media (max-width: 768px) {
        .hero-slider {
            height: 70vh;
        }
        
        .slide {
            padding: 0 15px;
            background-position: center center;
        }
        
        .slide-content {
            padding: 20px;
            width: 100%;
            max-width: 100%;
            margin: 0 auto !important;
            text-align: center;
        }
        
        .slide .title {
            font-size: 1.8rem;
            margin-bottom: 15px;
        }
        
        .slide .desc {
            font-size: 1rem;
            margin-bottom: 20px;
        }
        
        .btn-slider {
            padding: 10px 25px;
            font-size: 0.9rem;
        }
        
        /* Improved mobile dots */
        .slider-controls {
            bottom: 20px;
            padding: 4px;
            gap: 6px;
        }
        
        .slider-dot {
            width: 8px;
            height: 8px;
        }
        
        .slider-dot.active {
            transform: scale(1.2);
        }
    }
    
    @media (max-width: 480px) {
        .hero-slider {
            height: 60vh;
        }
        
        .slide .title {
            font-size: 1.5rem;
        }
        
        .slide .sub-title {
            font-size: 1rem;
        }
        
        .slider-controls {
            bottom: 15px;
        }
    }
    
    /* Animations (keep your existing animations) */
    @keyframes slideInRight {
        from {
            transform: translateX(100px);
            opacity: 0;
        }
        to {
            transform: translateX(0);
            opacity: 1;
        }
    }
    
    @keyframes slideInLeft {
        from {
            transform: translateX(-100px);
            opacity: 0;
        }
        to {
            transform: translateX(0);
            opacity: 1;
        }
    }
    
    @keyframes fadeInUp {
        from {
            transform: translateY(50px);
            opacity: 0;
        }
        to {
            transform: translateY(0);
            opacity: 1;
        }
    }
</style>

<script>
    // Slider functionality
    document.addEventListener('DOMContentLoaded', function() {
        const slides = document.querySelectorAll('.slide');
        const dots = document.querySelectorAll('.slider-dot');
        let currentSlide = 0;
        let slideInterval;
        
        function initSlider() {
            if (slides.length === 0) return;
            
            // Start auto slide
            slideInterval = setInterval(nextSlide, 5000);
        }
        
        function goToSlide(n) {
            slides[currentSlide].classList.remove('active');
            dots[currentSlide].classList.remove('active');
            
            currentSlide = (n + slides.length) % slides.length;
            
            slides[currentSlide].classList.add('active');
            dots[currentSlide].classList.add('active');
            
            // Reset timer when manually changing slides
            clearInterval(slideInterval);
            slideInterval = setInterval(nextSlide, 5000);
        }
        
        function nextSlide() {
            goToSlide(currentSlide + 1);
        }
        
        // Event listeners for dots
        dots.forEach((dot, index) => {
            dot.addEventListener('click', () => {
                goToSlide(index);
            });
        });
        
        // Initialize the slider
        initSlider();
    });
</script>



<!-- new section  -->
  <section class="cs_about cs_style_1 position-relative py-5" style="direction: rtl;">
    <div class="container">
        <div class="row g-4 align-items-center">
            <!-- Right Column - Images (RTL) -->
            <div class="col-lg-6">
                <div class="position-relative">
                    <!-- Image Grid -->
                    <div class="row g-3">
                        <div class="col-md-8 col-12">
                            <div class="cs_about_thumbnail overflow-hidden rounded-3">
                                <img src="images/gypsum-installation.webp" loading="lazy" alt="تركيب ألواح جبس بورد" class="img-fluid w-100">
                            </div>
                        </div>
                        
                        <div class="col-12">
                            <div class="cs_about_thumbnail overflow-hidden rounded-3">
                                <img src="images/gypsum-sheets.webp" loading="lazy" alt="ألواح جبس بورد" class="img-fluid w-100">
                            </div>
                        </div>
                    </div>



                    <!-- Gear Shapes -->
                    <div class="position-absolute" style="top: 20%; right: -5%; z-index: -1;">
                        <img src="Assets/gear_2.svg" loading="lazy" alt="Gear Shape" width="80" 
                             class="gear-animation" style="animation-duration: 3s;">
                    </div>
                    <div class="position-absolute" style="bottom: 10%; left: -5%; z-index: -1;">
                        <img src="Assets/gear_1.svg" loading="lazy" alt="Gear Shape" width="80" 
                             class="gear-animation" style="animation-duration: 6s; animation-direction: reverse;">
                    </div>
                </div>
            </div>

            <!-- Left Column - Content -->
            <div class="col-lg-6">
                <div class="pe-lg-5">
                    <!-- Section Heading -->
                    <div class="mb-4">
                        <span class="d-flex align-items-center text-uppercase text-primary fw-bold mb-2 wow fadeInDown">
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg" class="me-2"></svg>
                            من نحن
                        </span>
                        <h2 class="display-5 fw-bold mb-3 wow fadeInUp">أعمال الجبس بورد والديكور الداخلي بالرياض</h2>
                    </div>

                    <!-- Description -->
                    <p class="lead mb-4">
                        متخصصون في تنفيذ جميع أعمال الجبس والديكور الداخلي باستخدام ألواح جبس بورد سعودي عالية الجودة. نقدم أفضل أسعار ألواح الجبس بورد في الرياض مع تنفيذ سريع ودقة في التفاصيل لأجمل التصاميم الحديثة للأسقف والجدران.
                    </p>

                    <!-- Features List -->
                   

                    <!-- Check List -->
                    <ul class="list-unstyled mb-4">
                        <li class="mb-2 d-flex align-items-start" style="margin-right:-40px;">
                            <span class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 24px; height: 24px;">
                                <i class="bi bi-check-lg"></i>
                            </span>
                            <span style="margin-right:20px;" >تنفيذ أعمال جبس وديكور داخلي بأسعار تنافسية</span>
                        </li>
                        <li class="mb-2 d-flex align-items-start"style="margin-right:-40px;">
                            <span class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 24px; height: 24px;">
                                <i class="bi bi-check-lg"></i>
                            </span>
                            <span style="margin-right:20px;" >توفير جميع أنواع وأشكال ألواح الجبس بورد</span>
                        </li>
                        <li class="mb-2 d-flex align-items-start"style="margin-right:-40px;">
                            <span class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 24px; height: 24px;">
                                <i class="bi bi-check-lg"></i>
                            </span>
                            <span style="margin-right:20px;" >أسعار تبدأ من 10 ريال للمتر</span>
                        </li>
                        <li class="mb-2 d-flex align-items-start"style="margin-right:-40px;">
                            <span class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 24px; height: 24px;">
                                <i class="bi bi-check-lg"></i>
                            </span>
                            <span style="margin-right:20px;" >أحدث تصاميم الجبس للسقف والجدران</span>
                        </li>
                        <li class="mb-2 d-flex align-items-start"style="margin-right:-40px;">
                            <span class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 24px; height: 24px;">
                                <i class="bi bi-check-lg"></i>
                            </span>
                            <span style="margin-right:20px;" >فريق عمل محترف بخبرة طويلة في أعمال الجبس</span>
                        </li>
                    </ul>

                    <!-- Button -->
                    <a href="https://api.whatsapp.com/send?phone=+966 50 143 4156" class="btn btn-primary px-4 py-2 rounded-pill d-inline-flex align-items-center wow fadeInLeft">
                        <span class="me-2">تواصل معنا الآن</span>
                        <i class="bi bi-arrow-left"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>


<style>
/* RTL specific styles */
[dir="rtl"] .me-3 {
  margin-right: 0 !important;
  margin-left: 1rem !important;
}
[dir="rtl"] .ms-3 {
  margin-left: 0 !important;
  margin-right: 1rem !important;
}
[dir="rtl"] .me-2 {
  margin-right: 0 !important;
  margin-left: 0.5rem !important;
}

/* Main image styling */
.main-image img {
  border-radius: 12px;
  object-fit: cover;
  /* Larger width on desktop */
  width: 110%;
  margin-right: -10%;
}
@media (max-width: 767.98px) {
  .main-image img {
    width: 100%;
    margin-right: 0;
    height: auto;
  }
}

/* Smaller image styling */
.small-image {
  margin-top: 10px;
}
.small-image img {
  border-radius: 10px;
}
@media (max-width: 767.98px) {
  .small-image img {
    width: 90%;
    margin: 0 auto;
    display: block;
  }
}

/* Icon circle styling */
.icon-circle {
  width: 24px;
  height: 24px;
  font-size: 14px;
}

/* Gear rotation */
@keyframes gear-rotate {
  0% { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
}
.gear-animation {
  animation: gear-rotate linear infinite;
  transform-origin: center center;
}

/* Image hover effects */
.img-hover-animate {
  transition: all 0.3s ease;
}
.img-hover-animate:hover {
  transform: scale(0.95);
  filter: brightness(1.1) sepia(1) hue-rotate(60deg) saturate(3);
}
.img-container-hover:hover {
  background-color: #e8f5e9 !important;
}
</style>

    <!-- 3thsection -->
   <section class="bg-light position-relative py-5" style="background-image: url('assets/service_bg_1.avif'); background-size: cover; background-position: center; direction: rtl;">
  <div class="container py-5">

    <!-- Section Heading -->
    <div class="row align-items-end mb-5">
      <div class="col-lg-8 mb-4 mb-lg-0">
        <div class="d-flex align-items-center mb-3">
          <span class="text-uppercase fw-bold text-primary">أعمال الجبس بورد</span>
        </div>
        <h1 class="display-4 fw-bold mb-0 wow fadeInDown">أفضل خدمات الجبس بورد بالرياض</h1>
      </div>
      <div class="col-lg-4 wow fadeInDown">
        <p class="mb-0">
          نقدم مجموعة متكاملة من خدمات تركيب وتصميم ألواح الجبس بورد بأسعار تنافسية في الرياض. نوفر جميع الأنواع والمقاسات، مع تصاميم عصرية تضفي لمسة جمالية وفخامة للمنازل والمشاريع التجارية.
        </p>
      </div>
    </div>

    <!-- Services Cards - 6 Cards -->
    <div class="row g-4 wow fadeInUp">

      <!-- Service 1 -->
      <div class="col-md-6 col-lg-4">
        <div class="card border-0 shadow-sm h-100 overflow-hidden service-card">
          <img src="images/gypsum-installation.webp"
               class="card-img-top w-100"
               style="height: 200px; object-fit: cover;"
               loading="lazy"
               alt="تركيب ألواح جبس بورد">
          <div class="card-body text-center px-4 py-4">
            <h3 class="h5 mb-3">تركيب ألواح جبس بورد</h3>
            <p class="mb-4">ننفذ أعمال تركيب ألواح الجبس بورد لجميع الأسقف والجدران، مع ضمان الجودة والدقة في التفاصيل والتشطيبات.</p>
            <a href="tel:
+966 50 143 4156
" class="btn btn-primary px-4 py-2 rounded-pill">اتصل الآن</a>
          </div>
        </div>
      </div>

      <!-- Service 2 -->
      <div class="col-md-6 col-lg-4">
        <div class="card border-0 shadow-sm h-100 overflow-hidden service-card">
          <img src="images/gypsum-designs.webp"
               class="card-img-top w-100"
               style="height: 200px; object-fit: cover;"
               loading="lazy"
               alt="أحدث تصاميم الجبس بورد">
          <div class="card-body text-center px-4 py-4">
            <h3 class="h5 mb-3">أحدث تصاميم الجبس بورد</h3>
            <p class="mb-4">ابتكر ديكورك بأساليب عصرية مع أحدث تصاميم الجبس بورد التي تضيف لمسة جمالية ورفاهية للمساحات الداخلية.</p>
            <a href="tel:
+966 50 143 4156
" class="btn btn-primary px-4 py-2 rounded-pill">اتصل الآن</a>
          </div>
        </div>
      </div>

      <!-- Service 3 -->
      <div class="col-md-6 col-lg-4">
        <div class="card border-0 shadow-sm h-100 overflow-hidden service-card">
          <img src="images/gypsum-types.webp"
               class="card-img-top w-100"
               style="height: 200px; object-fit: cover;"
               loading="lazy"
               alt="أنواع ألواح الجبس بورد">
          <div class="card-body text-center px-4 py-4">
            <h3 class="h5 mb-3">أنواع ألواح الجبس بورد</h3>
            <p class="mb-4">نوفر جميع أنواع ألواح الجبس بورد مثل المقاوم للرطوبة، ضد الحريق، وألواح الديكور لتلبية متطلبات المشاريع المتنوعة.</p>
            <a href="tel:
+966 50 143 4156
" class="btn btn-primary px-4 py-2 rounded-pill">اتصل الآن</a>
          </div>
        </div>
      </div>

      <!-- Service 4 -->
      <div class="col-md-6 col-lg-4">
        <div class="card border-0 shadow-sm h-100 overflow-hidden service-card">
          <img src="images/gypsum-prices.webp"
               class="card-img-top w-100"
               style="height: 200px; object-fit: cover;"
               loading="lazy"
               alt="أسعار ألواح الجبس بورد">
          <div class="card-body text-center px-4 py-4">
            <h3 class="h5 mb-3">أسعار ألواح الجبس بورد</h3>
            <p class="mb-4">نقدم أفضل أسعار ألواح الجبس بورد في الرياض بجودة عالية وخيارات متعددة تناسب كافة الميزانيات والاحتياجات.</p>
            <a href="tel:
+966 50 143 4156
" class="btn btn-primary px-4 py-2 rounded-pill">اتصل الآن</a>
          </div>
        </div>
      </div>

      <!-- Service 5 -->
      <div class="col-md-6 col-lg-4">
        <div class="card border-0 shadow-sm h-100 overflow-hidden service-card">
          <img src="images/gypsum-ceilings.webp"
               class="card-img-top w-100"
               style="height: 200px; object-fit: cover;"
               loading="lazy"
               alt="أعمال جبس للأسقف">
          <div class="card-body text-center px-4 py-4">
            <h3 class="h5 mb-3">أعمال جبس للأسقف</h3>
            <p class="mb-4">تصاميم أسقف جبس بورد عصرية بمختلف الأشكال والأحجام لإضفاء الفخامة والجمال على المساحات الداخلية.</p>
            <a href="tel:
+966 50 143 4156
" class="btn btn-primary px-4 py-2 rounded-pill">اتصل الآن</a>
          </div>
        </div>
      </div>

      <!-- Service 6 -->
      <div class="col-md-6 col-lg-4">
        <div class="card border-0 shadow-sm h-100 overflow-hidden service-card">
          <img src="images/gypsum-sheets-sale.webp"
               class="card-img-top w-100"
               style="height: 200px; object-fit: cover;"
               loading="lazy"
               alt="ألواح جبس بورد للبيع">
          <div class="card-body text-center px-4 py-4">
            <h3 class="h5 mb-3">ألواح جبس بورد للبيع</h3>
            <p class="mb-4">نوفر ألواح جبس بورد للبيع بمقاسات وأسعار متنوعة تناسب جميع الاستخدامات، مع خدمة توصيل سريعة داخل الرياض.</p>
            <a href="tel:
+966 50 143 4156
" class="btn btn-primary px-4 py-2 rounded-pill">اتصل الآن</a>
          </div>
        </div>
      </div>

    </div>
  </div>
</section>
<style>
  /* RTL Arrow flip */
  [dir="rtl"] .bi-arrow-left {
      transform: scaleX(-1);
  }

  /* Card hover effect */
  .service-card {
      transition: transform 0.3s ease, box-shadow 0.3s ease;
      border-radius: 10px;
  }
  .service-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 15px 30px rgba(0,0,0,0.15);
  }

  /* Buttons style */
  .service-card .btn {
      background-color: #007bff;
      color: #fff;
      transition: background-color 0.3s ease;
  }
  .service-card .btn:hover {
      background-color: #0056b3;
      color: #fff;
  }

  /* Responsive heading */
  @media (max-width: 768px) {
      .display-4 {
          font-size: 2.2rem;
      }
  }
</style>
<section class="py-5 bg-light">
  <div class="container">
    <div class="text-center mb-5">
      <h2 class="fw-bold">خدمات أخرى</h2>
      <p class="text-muted">
        نقدم مجموعة متنوعة من الخدمات المتعلقة بأعمال الجبس بورد والديكورات الداخلية لتلبية جميع احتياجاتك بأعلى جودة واحترافية.
      </p>
      <div class="d-flex justify-content-center mb-3">
        <span class="bg-primary" style="width: 30px; height: 2px;"></span>
        <span class="bg-dark mx-1" style="width: 15px; height: 2px;"></span>
        <span class="bg-dark" style="width: 15px; height: 2px;"></span>
      </div>
    </div>
    <div class="row g-4">
      
      <!-- Service 1 -->
      <div class="col-md-6 col-lg-4">
        <div class="card border-0 shadow h-100">
          <div class="card-body text-center">
            <i class="bi bi-house-fill text-primary fs-2 mb-3"></i>
            <h5 class="card-title fw-bold">ديكورات الأسقف المعلقة</h5>
            <p class="card-text">
              تصميم وتنفيذ أسقف معلقة باستخدام ألواح الجبس بورد بجميع الأشكال العصرية لإضفاء لمسة جمالية على المساحات الداخلية.
            </p>
          </div>
        </div>
      </div>
      
      <!-- Service 2 -->
      <div class="col-md-6 col-lg-4">
        <div class="card border-0 shadow h-100">
          <div class="card-body text-center">
            <i class="bi bi-grid-fill text-primary fs-2 mb-3"></i>
            <h5 class="card-title fw-bold">عزل صوتي وحراري</h5>
            <p class="card-text">
              تركيب ألواح جبس بورد مضادة للرطوبة وعازلة للصوت والحرارة لضمان الراحة والخصوصية داخل المباني.
            </p>
          </div>
        </div>
      </div>
      
      <!-- Service 3 -->
      <div class="col-md-6 col-lg-4">
        <div class="card border-0 shadow h-100">
          <div class="card-body text-center">
            <i class="bi bi-bricks text-primary fs-2 mb-3"></i>
            <h5 class="card-title fw-bold">تصاميم الجدران الداخلية</h5>
            <p class="card-text">
              تنفيذ ديكورات جدران داخلية بألواح الجبس بورد، مع إمكانية تصميم قواطع وفواصل للمساحات بأسلوب حديث وجذاب.
            </p>
          </div>
        </div>
      </div>
      
    </div>
  </div>
</section>


<!-- 4th -->

    <style>
        /* Custom CSS to match original styling */
        .cs_height_80, .cs_height_lg_80 {
            height: 80px;
        }
        .cs_height_27, .cs_height_lg_65 {
            height: 27px;
        }
        .cs_height_120, .cs_height_lg_105 {
            height: 120px;
        }
        @media (min-width: 992px) {
            .cs_height_lg_80 {
                height: 80px;
            }
            .cs_height_lg_65 {
                height: 65px;
            }
            .cs_height_lg_105 {
                height: 105px;
            }
        }
        
        .cs_section_subtitle {
            font-size: 18px;
            margin-bottom: 12px;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            text-transform: uppercase;
            color: #333;
        }
        
        .cs_section_title {
            font-size: 40px;
            margin-bottom: 0;
            font-weight: 700;
            color: #333;
        }
        
        .cs_row_gap_40 {
            row-gap: 40px;
        }
        
        .cs_gap_y_40 {
            margin-top: 40px;
            margin-bottom: 40px;
        }
        
        .cs_features_thumbnail_1, .cs_features_thumbnail_2, .cs_features_thumbnail_3 {
            position: relative;
        }
        
        .cs_features_thumbnail_1 img, .cs_features_thumbnail_2 img, .cs_features_thumbnail_3 img {
            width: 100%;
            height: auto;
            border-radius: 10px;
        }
        
        .cs_feature_text {
            margin-bottom: 30px;
            font-size: 16px;
            line-height: 1.6;
            color: #666;
        }
        
        .cs_iconbox {
            display: flex;
            gap: 15px;
            margin-bottom: 12px;
            align-items: flex-start;
        }
        
        .cs_iconbox_icon {
            width: 50px;
            height: 50px;
            background-color: #f8f9fa;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }
        
        .cs_iconbox_icon img {
            width: 24px;
            height: 24px;
        }
        
        .cs_iconbox_info h3 {
            font-size: 18px;
            margin-bottom: 2px;
            font-weight: 600;
            color: #333;
        }
        
        .cs_iconbox_subtitle {
            font-size: 12px;
            color: #666;
            line-height: 1.5;
            margin-bottom: 0;
        }
        
        .cs_btn {
            display: inline-flex;
            align-items: center;
            padding: 12px 24px;
            background-color: #0d6efd;
            color: white;
            border-radius: 5px;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        
        .cs_btn:hover {
            background-color: #0b5ed7;
            color: white;
        }
        
        .cs_btn i {
            margin-left: 8px;
            transition: transform 0.3s ease;
        }
        
        .cs_btn:hover i {
            transform: translateX(3px);
        }
        
        .cs_features_thumbnail_2 {
            margin-bottom: 20px;
        }
        
        .cs_features_thumbnail_3 {
            margin-top: 20px;
        }
        
        /* SVG icon styling */
        .cs_section_subtitle svg {
            width: 16px;
            height: 16px;
            fill: currentColor;
        }
    </style>

  <section class="cs_why_choose_us py-5">
  <div class="container">
    <div class="text-center mb-5">
      <h3 class="cs_section_subtitle text-primary">
        <i class="fas fa-circle-check"></i>
        لماذا تختارنا
        <i class="fas fa-circle-check"></i>
      </h3>
      <h2 class="cs_section_title">نحن نقدم أفضل الحلول لك</h2>
    </div>

    <div class="row g-4">
      <!-- Card 1 -->
      <div class="col-md-4">
        <div class="cs_card h-100 text-center p-4">
          <div class="cs_icon mb-3">
            <i class="fas fa-user-tie"></i>
          </div>
          <h3 class="fw-bold">خبرة عالية</h3>
          <p class="text-muted mb-2">
            نتمتع بفريق ذو خبرة واسعة في مجاله لتقديم أفضل النتائج.
          </p>
          <p>
            نحن ملتزمون بتقديم خدمة مميزة وذات جودة عالية، لضمان رضا عملائنا بشكل كامل.
          </p>
        </div>
      </div>

      <!-- Card 2 -->
      <div class="col-md-4">
        <div class="cs_card h-100 text-center p-4">
          <div class="cs_icon mb-3">
            <i class="fas fa-tags"></i>
          </div>
          <h3 class="fw-bold">أسعار تنافسية</h3>
          <p class="text-muted mb-2">
            نوفر حلولًا بأسعار مناسبة مع الحفاظ على الجودة العالية.
          </p>
          <p>
            هدفنا هو تحقيق أفضل قيمة مقابل المال من خلال تقديم خدمات بأسعار معقولة وجودة ممتازة.
          </p>
        </div>
      </div>

      <!-- Card 3 -->
      <div class="col-md-4">
        <div class="cs_card h-100 text-center p-4">
          <div class="cs_icon mb-3">
            <i class="fas fa-headset"></i>
          </div>
          <h3 class="fw-bold">دعم مستمر</h3>
          <p class="text-muted mb-2">
            نقدم الدعم الفني وخدمات ما بعد البيع لضمان رضاك.
          </p>
          <p>
            نحن هنا دائمًا لمساعدتك والإجابة على استفساراتك في أي وقت لضمان استمرارية عملك.
          </p>
        </div>
      </div>
    </div>

    <div class="text-center mt-5">
      <a href="https://api.whatsapp.com/send?phone=+966501434156" class="btn btn-primary btn-lg px-5">
        اكتشف المزيد <i class="fas fa-arrow-left ms-2"></i>
      </a>
    </div>
  </div>
</section>

<div class="cs_height_80 cs_height_lg_80"></div>
<br><br>
<style>
    .cs_card {
  background-color: #fff;
  border: 1px solid #eee;
  border-radius: 16px;
  box-shadow: 0 6px 20px rgba(0, 0, 0, 0.05);
  transition: transform 0.3s, box-shadow 0.3s;
}

.cs_card:hover {
  transform: translateY(-10px);
  box-shadow: 0 12px 30px rgba(0, 0, 0, 0.1);
}

.cs_icon {
  width: 80px;
  height: 80px;
  background-color: #f5f5f5;
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 28px;
  color: #007bff; /* Change this to match your theme color */
  margin: 0 auto;
}

.cs_section_title {
  font-size: 2rem;
  font-weight: bold;
}

.cs_section_subtitle {
  font-size: 1.2rem;
  font-weight: 600;
}

</style>
 <!-- 6th section -->



<!-- 7th section -->

    <style>
    /* Existing styles remain unchanged */
    .cs_height_80, .cs_height_lg_80 {
        height: 80px;
    }
    .cs_height_60 {
        height: 60px;
    }
    .cs_section_subtitle {
        font-size: 18px;
        margin-bottom: 12px;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        text-transform: uppercase;
        color: #333;
    }
    .cs_section_title {
        font-size: 40px;
        margin-bottom: 0;
        font-weight: 700;
        color: #333;
    }
    .cs_row_gap_60 {
        row-gap: 60px;
    }
    .cs_card {
        position: relative;
        height: 100%;
        transition: all 0.3s ease;
    }
    .cs_card_thumbnail {
        position: relative;
        display: block;
        overflow: hidden;
        border-radius: 10px;
    }
    .cs_card_thumbnail img {
        width: 100%;
        height: auto;
        transition: transform 0.3s ease;
    }
    .cs_card:hover .cs_card_thumbnail img {
        transform: scale(1.05);
    }
    .cs_card_info {
        background-color: white;
        padding: 25px;
        border-radius: 0 0 10px 10px;
    }
    .cs_card_title {
        font-size: 20px;
        margin-bottom: 15px;
        font-weight: 600;
    }
    .cs_card_title a {
        color: #333;
        text-decoration: none;
    }
    .cs_card_subtitle {
        color: #666;
        margin-bottom: 20px;
        line-height: 1.6;
    }
</style>

<section class="position-relative" style="margin-top: -170px; direction: rtl;">
  <div class="container mt-5">
    <div class="row">
      <div class="col-lg-6">
        <div class="position-relative">
          <div class="bg-white p-4">
            <div class="bg-primary mb-4" style="height: 2px; width: 50px;"></div>
            <h1 class="h3 mb-3">مؤسسة أعمال الجبس بورد والديكور الداخلي - الرياض</h1>
            <p class="mb-4">
              نقدم خدمات <strong>أعمال الجبس</strong> وتنفيذ <strong>ألواح جبس بورد</strong> بجودة عالية وأسعار تنافسية في الرياض. متخصصون في جميع أنواع
              <strong>ألواح الجبس بورد</strong>، سواء كانت <strong>ألواح جبس بورد ضد الماء</strong> أو <strong>ألواح جبس بورد سعودي</strong>. نوفر أفضل
              <strong>أسعار ألواح الجبس بورد في الرياض</strong> مع ضمان تنفيذ احترافي لأعمال الأسقف والديكور الداخلي.
            </p>
            
            <div class="d-flex mb-3">
              <div class="ms-3">
                <img src="Assets/location.svg" loading="lazy" alt="أيقونة الموقع">
              </div>
              <div>
                <p class="mb-0">الرياض</p>
              </div>
            </div>
            
            <div class="d-flex mb-3">
              <div class="ms-3">
                <img src="Assets/mail_open.svg" loading="lazy" alt="أيقونة البريد">
              </div>
              <div>
                <a href="mailto:info@gypsumboardandceilingworks.shop">info@gypsumboardandceilingworks.shop</a>
              </div>
            </div>
            
            <div class="d-flex">
              <div class="ms-3">
                <img src="Assets/phone-call.svg" loading="lazy" alt="أيقونة الهاتف">
              </div>
              <div>
                <a href="tel:+966501434156">0501434156</a><br>
              </div>
            </div>
          </div>
          
          <div class="mt-4">
            <img class="img-fluid" src="images/gypsum-board-riyadh.jpg" loading="lazy" alt="أعمال ألواح الجبس بورد بالرياض">
          </div>
          
          <div class="bg-white p-3 position-absolute" style="bottom: 0; right: 0;">
          </div>
        </div>
      </div>
      
      <div class="col-lg-6">
        <div class="mb-4">
          <h2 class="h6 text-uppercase mb-2">
            <svg width="16" height="16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
              <path d="M11.9367 5.9528C12.1626 6.01733 12.3783 6.07787 12.7693 6.07787C13.5946 6.07787 14.4218 5.73787 15.0389 5.1208C15.8285 4.33093 16.1661 3.19973 15.9199 2.16827C15.9089 2.12215 15.8858 2.07981 15.8529 2.04563C15.82 2.01146 15.7786 1.98668 15.733 1.97387C15.6874 1.96077 15.6391 1.96016 15.5931 1.97213C15.5472 1.98409 15.5053 2.00818 15.4719 2.04187L14.8413 2.67253C14.6394 2.87413 14.3706 2.98533 14.0839 2.98533C13.7973 2.98533 13.5285 2.8744 13.3269 2.67253C13.1262 2.47155 13.0136 2.19918 13.0136 1.9152C13.0136 1.63122 13.1262 1.35885 13.3269 1.15787L13.9573 0.527466C13.9909 0.493964 14.015 0.452081 14.027 0.406152C14.039 0.360223 14.0385 0.311916 14.0256 0.266232C14.0127 0.220547 13.9878 0.179144 13.9535 0.146308C13.9192 0.113471 13.8768 0.0903949 13.8306 0.0794661C12.7991 -0.166934 11.6682 0.170933 10.8783 0.960533C10.1042 1.7344 9.71058 2.888 10.0463 4.06267L7.99858 6.11013L5.95218 4.06373C6.28712 2.89093 5.89565 1.73573 5.12018 0.960533C4.33058 0.170666 3.19938 -0.167467 2.16818 0.0794661C2.12214 0.0906185 2.07989 0.113812 2.04576 0.146671C2.01163 0.179529 1.98685 0.220871 1.97396 0.266459C1.96107 0.312048 1.96054 0.360243 1.97241 0.406108C1.98428 0.451972 2.00813 0.493855 2.04152 0.527466L2.67192 1.15787C2.87254 1.35885 2.98522 1.63122 2.98522 1.9152C2.98522 2.19918 2.87254 2.47155 2.67192 2.67253C2.47032 2.8744 2.20152 2.98533 1.91485 2.98533C1.62818 2.98533 1.35938 2.87413 1.15752 2.67253L0.527118 2.0416C0.493597 2.00804 0.451734 1.98404 0.405844 1.97205C0.359953 1.96007 0.311697 1.96054 0.26605 1.97342C0.220403 1.9863 0.179016 2.01112 0.146158 2.04532C0.113299 2.07952 0.0901572 2.12187 0.079118 2.168C-0.167015 3.19947 0.170585 4.33067 0.960185 5.12053C1.57778 5.73787 2.40552 6.07813 3.22952 6.07813C3.61965 6.07813 3.85512 6.012 4.06312 5.95227L6.10978 7.99867L4.06232 10.0461C2.89138 9.71227 1.73725 10.1013 0.960185 10.8781C0.170585 11.668 -0.167015 12.7992 0.079118 13.8307C0.0901342 13.8768 0.113271 13.9191 0.146136 13.9533C0.179001 13.9875 0.2204 14.0123 0.266051 14.0251C0.358851 14.0509 0.458851 14.0251 0.527118 13.9571L1.15778 13.3264C1.35886 13.1261 1.63114 13.0136 1.91498 13.0136C2.19883 13.0136 2.47111 13.1261 2.67218 13.3264C2.87405 13.5283 2.98498 13.7973 2.98498 14.0837C2.98498 14.3701 2.87378 14.6392 2.67218 14.8411L2.04178 15.4715C2.00815 15.505 1.98407 15.5469 1.97205 15.5928C1.96004 15.6387 1.96051 15.687 1.97343 15.7327C1.98634 15.7784 2.01123 15.8198 2.04552 15.8526C2.07981 15.8855 2.12225 15.9085 2.16845 15.9195C2.39138 15.9728 2.61912 15.9987 2.84685 15.9987C3.67272 15.9987 4.50178 15.6576 5.12072 15.0384C5.89485 14.2645 6.28845 13.1109 5.95272 11.9363L8.00045 9.8888L10.0469 11.9352C9.71192 13.108 10.1034 14.2632 10.8789 15.0384C11.4981 15.6573 12.3269 15.9987 13.1527 15.9987C13.3805 15.9987 13.6082 15.9728 13.8311 15.9195C13.8772 15.9083 13.9194 15.8851 13.9535 15.8523C13.9877 15.8194 14.0124 15.7781 14.0253 15.7325C14.0382 15.6869 14.0388 15.6387 14.0269 15.5928C14.015 15.547 13.9912 15.5051 13.9578 15.4715L13.3274 14.8411C13.1255 14.6392 13.0146 14.3701 13.0146 14.0837C13.0146 13.7973 13.1258 13.5283 13.3274 13.3264C13.5285 13.1261 13.8007 13.0136 14.0846 13.0136C14.3684 13.0136 14.6407 13.1261 14.8418 13.3264L15.4725 13.9571C15.506 13.9905 15.5479 14.0143 15.5938 14.0262C15.6396 14.0381 15.6878 14.0376 15.7334 14.0247C15.779 14.0119 15.8203 13.9871 15.8532 13.953C15.886 13.9189 15.9093 13.8767 15.9205 13.8307C16.1666 12.7992 15.829 11.668 15.0394 10.8781Z" fill="currentColor"/>
            </svg>
            تواصل معنا
          </h2>
          <h2 class="h1 mb-0">اطلب خدمة تركيب أو صيانة ألواح الجبس بورد</h2>
        </div>
        
        <form id="cs_form">
          <div class="row g-3">
            <div class="col-sm-6">
              <input type="text" name="name" placeholder="الاسم الكامل" class="form-control rounded" required>
            </div>
            <div class="col-sm-6">
              <input type="email" name="email" placeholder="البريد الإلكتروني" class="form-control rounded" required>
            </div>
            <div class="col-sm-6">
              <input type="text" name="phone" placeholder="رقم الهاتف" class="form-control rounded" required>
            </div>
            <div class="col-sm-6">
               <input type="text" name="Subject" placeholder="نوع الخدمة المطلوبة" class="form-control rounded" required>
            </div>
            <div class="col-12">
              <textarea name="message" rows="6" placeholder="أدخل رسالتك أو استفسارك حول أعمال الجبس بورد أو الأسعار" class="form-control" required></textarea>
            </div>
            <div class="col-12 mt-4">
              <button type="submit" class="btn btn-primary">
                <span>إرسال</span>
                <i class="bi bi-arrow-left ms-2"></i>
              </button>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</section>

<!-- Google Map -->
<div class="container-fluid p-0 my-5">
  <div style="height: 200px;">
    <iframe
      loading="lazy"
      src="https://maps.google.com/maps?q=الرياض&amp;t=m&amp;z=15&amp;output=embed&amp;iwloc=near"
      title="مؤسسة أعمال الجبس بورد والديكور الداخلي - الرياض"
      aria-label="مؤسسة أعمال الجبس بورد والديكور الداخلي - الرياض"
      style="width: 100%; height: 100%; border: 0;"
    ></iframe>
  </div>
</div>

<!-- Testimonial Section -->
<section class="py-5" style="background-image: url('Assets/testimonialbg.jpg'); background-size: cover; background-position: center;">
  <div class="container py-4">
    <div class="text-center mb-5">
      <h3 class="text-uppercase fw-semibold mb-2 text-primary">
        <svg width="16" height="16" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" class="me-2">
          <path d="M11.9367 5.9528C12.1626 6.01733..."></path>
        </svg>
        آراء العملاء
      </h3>
      <h2 class="h1 mb-3">ماذا يقول عملاؤنا</h2>
      <p class="text-muted mt-2 w-75 mx-auto">
        "كنت أبحث عن فريق محترف لتنفيذ أعمال الجبس بورد في منزلي بالرياض، وتواصلت مع شركة أعمال الجبس والأسقف. العمل كان رائعًا والدقة عالية جدًا. أنصح الجميع بالتعامل معهم!"
      </p>
    </div>

    <div class="row g-4 justify-content-center">
      <!-- Testimonial Card -->
      <div class="col-md-6 col-lg-4">
        <div class="card testimonial-card text-center h-100">
          <div class="card-img-top-wrapper">
            <img src="images/images3.webp" alt="عبدالله صالح" class="rounded-circle mx-auto d-block testimonial-img">
          </div>
          <div class="card-body">
            <div class="text-warning mb-2">
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
            </div>
            <h5 class="fw-bold mb-1">عبدالله صالح</h5>
            <small class="text-muted d-block mb-3">حي العليا - الرياض</small>
            <blockquote class="mb-0">
              <p class="fs-6">"طلبت تركيب أسقف جبس بورد في مجلس منزلي، وكانت النتيجة مذهلة. العمل متقن والديكور رائع والأسعار مناسبة جدًا. أوصي بخدماتهم بشدة."</p>
            </blockquote>
          </div>
        </div>
      </div>

      <div class="col-md-6 col-lg-4">
        <div class="card testimonial-card text-center h-100">
          <div class="card-img-top-wrapper">
            <img src="images/2.webp" alt="فاطمة الدوسري" class="rounded-circle mx-auto d-block testimonial-img">
          </div>
          <div class="card-body">
            <div class="text-warning mb-2">
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
            </div>
            <h5 class="fw-bold mb-1">فاطمة الدوسري</h5>
            <small class="text-muted d-block mb-3">حي النرجس - الرياض</small>
            <blockquote class="mb-0">
              <p class="fs-6">"الشركة نفذت لي تصميم جبس بورد للسقف والجدران في الصالة، عملهم سريع ونظيف والتشطيبات رائعة. شكراً لهم على الإبداع والالتزام بالمواعيد."</p>
            </blockquote>
          </div>
        </div>
      </div>

      <div class="col-md-6 col-lg-4">
        <div class="card testimonial-card text-center h-100">
          <div class="card-img-top-wrapper">
            <img src="images/3.webp" alt="محمد المطيري" class="rounded-circle mx-auto d-block testimonial-img">
          </div>
          <div class="card-body">
            <div class="text-warning mb-2">
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
            </div>
            <h5 class="fw-bold mb-1">محمد المطيري</h5>
            <small class="text-muted d-block mb-3">حي الروابي - الرياض</small>
            <blockquote class="mb-0">
              <p class="fs-6">"عمل ممتاز وجودة عالية في تركيب ألواح الجبس بورد. الأسعار معقولة والفريق محترف ويتعاملون بكل أمانة. بالتأكيد سأتعامل معهم مرة أخرى."</p>
            </blockquote>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<style>
  .testimonial-card {
    border: none;
    border-radius: 15px;
    overflow: hidden;
    background: rgba(255, 255, 255, 0.85);
    backdrop-filter: blur(3px);
    transition: transform 0.3s, box-shadow 0.3s;
    padding-top: 40px;
  }

  .testimonial-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 15px 25px rgba(0,0,0,0.15);
  }

  .testimonial-img {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    object-fit: cover;
    border: 3px solid #0d6efd;
    margin-top: -40px;
  }

  .testimonial-card blockquote p {
    font-style: italic;
    color: #333;
    position: relative;
    padding: 10px 20px;
  }

  .testimonial-card blockquote p::before {
    content: "“";
    font-size: 3rem;
    color: #0d6efd;
    position: absolute;
    top: -20px;
    right: 10px;
    opacity: 0.15;
    line-height: 1;
  }

  .testimonial-card h5 {
    color: #0d6efd;
  }

  .testimonial-card small {
    color: #6c757d;
  }

  @media (max-width: 576px) {
    .testimonial-img {
      width: 60px;
      height: 60px;
      margin-top: -30px;
    }
  }
</style>


<section class="py-5" style="background-image: url('Assets/processbg.jpg'); background-size: cover; background-position: center;">
  <div class="container py-5">
    <div class="text-center mb-5">
      <div class="d-flex justify-content-center align-items-center mb-3">
        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg" class="me-2">
          <path d="M11.9367 5.9528C12.1626 6.01733..."></path>
        </svg>
        <h6 class="text-uppercase mb-0">قيمنا</h6>
        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg" class="ms-2">
          <path d="M11.9367 5.9528C12.1626 6.01733..."></path>
        </svg>
      </div>
      <h2 class="mb-4">عملية تنفيذ أعمال الجبس بورد باحترافية</h2>
    </div>
    <div class="row g-4">
      
      <!-- Card 1 -->
      <div class="col-xl-3 col-md-6">
        <div class="gypsum-card">
          <div class="gypsum-card-body">
            <div class="gypsum-card-img mb-4">
              <img src="images/gypsum-1.webp" loading="lazy" alt="أحدث أعمال الجبس بورد" class="img-fluid">
            </div>
            <h5 class="mb-3">أحدث أعمال الجبس بورد</h5>
            <p>ننفذ أحدث أعمال الجبس والديكور الداخلي باستخدام ألواح جبس بورد عالية الجودة بأفضل أسعار ألواح الجبس بورد في الرياض.</p>
          </div>
        </div>
      </div>

      <!-- Card 2 -->
      <div class="col-xl-3 col-md-6">
        <div class="gypsum-card">
          <div class="gypsum-card-body">
            <div class="gypsum-card-img mb-4">
              <img src="images/gypsum-2.webp" loading="lazy" alt="أسعار ألواح الجبس بورد" class="img-fluid">
            </div>
            <h5 class="mb-3">أسعار تنافسية</h5>
            <p>نوفر أسعار ألواح الجبس بورد في الرياض بأسعار منافسة وجودة مضمونة، مع توضيح سعر لوح الجبس بورد ومقاساته المختلفة.</p>
          </div>
        </div>
      </div>

      <!-- Card 3 -->
      <div class="col-xl-3 col-md-6">
        <div class="gypsum-card">
          <div class="gypsum-card-body">
            <div class="gypsum-card-img mb-4">
              <img src="images/gypsum-3.webp" loading="lazy" alt="أنواع ألواح الجبس بورد" class="img-fluid">
            </div>
            <h5 class="mb-3">تنوع الأنواع</h5>
            <p>نقدم جميع أنواع ألواح الجبس بورد مثل ألواح جبس بورد ضد الماء، وألواح جبس بورد سعودي، وألواح جبس بورد للديكور الداخلي وأعمال الأسقف.</p>
          </div>
        </div>
      </div>

      <!-- Card 4 -->
      <div class="col-xl-3 col-md-6">
        <div class="gypsum-card">
          <div class="gypsum-card-body">
            <div class="gypsum-card-img mb-4">
              <img src="images/gypsum-4.webp" loading="lazy" alt="أعمال الجبس والديكور الداخلي" class="img-fluid">
            </div>
            <h5 class="mb-3">إبداع في التصميم</h5>
            <p>ننّفذ أجمل أعمال الجبس والديكور، من أعمال جبس بورد للأسقف إلى أعمال جبس بلدي والديكور الداخلي، مع أحدث التصاميم العصرية.</p>
          </div>
        </div>
      </div>

    </div>
  </div>
</section>

<style>
  .gypsum-card {
    background-color: #fff;
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
    height: 100%;
    display: flex;
    flex-direction: column;
    justify-content: stretch;
  }

  .gypsum-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 20px 40px rgba(0,0,0,0.15);
  }

  .gypsum-card-body {
    padding: 2rem;
    text-align: center;
  }

  .gypsum-card-img img {
    max-width: 100px;
    height: auto;
    transition: all 0.3s ease;
  }

  .gypsum-card:hover .gypsum-card-img img {
    transform: scale(1.1);
  }

  .gypsum-card h5 {
    color: #333;
    font-weight: 700;
    font-size: 1.2rem;
  }

  .gypsum-card p {
    color: #666;
    font-size: 0.95rem;
    line-height: 1.6;
  }
</style>


<?php echo $__env->make('footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

 
    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- WOW.js for animations -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/wow/1.1.2/wow.min.js"></script>
<script>
        new WOW().init();
    </script>
<script>
  document.addEventListener('DOMContentLoaded', function() {
    const container = document.querySelector('.ba-container');
    const before = container.querySelector('.ba-before');
    const handle = container.querySelector('.ba-handle');

    const onMove = e => {
      const rect = container.getBoundingClientRect();
      const x = (e.touches ? e.touches[0].clientX : e.clientX) - rect.left;
      const pct = Math.max(0, Math.min(x, rect.width));
      before.style.width = pct + 'px';
      handle.style.left = pct + 'px';
    };
    handle.addEventListener('mousedown', () => {
      document.addEventListener('mousemove', onMove);
    });
    document.addEventListener('mouseup', () => {
      document.removeEventListener('mousemove', onMove);
    });
    // Touch events
    handle.addEventListener('touchstart', () => {
      document.addEventListener('touchmove', onMove);
    });
    document.addEventListener('touchend', () => {
      document.removeEventListener('touchmove', onMove);
    });
  });
</script>


    <script>
        // Initialize WOW.js
        new WOW().init();
        
        // Auto-rotate carousel every 5 seconds
        document.addEventListener('DOMContentLoaded', function() {
            var myCarousel = document.getElementById('heroCarousel');
            var carousel = new bootstrap.Carousel(myCarousel, {
                interval: 5000,
                ride: 'carousel'
            });
        });
    </script>
    <!-- Add this JavaScript -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const dropdownElement = document.getElementById('servicesDropdown');
    const dropdownLink = document.getElementById('servicesDropdownLink');
    
    // Hover functionality
    dropdownElement.addEventListener('mouseenter', function() {
        const dropdown = new bootstrap.Dropdown(dropdownLink);
        dropdown.show();
    });
    
    dropdownElement.addEventListener('mouseleave', function() {
        const dropdown = bootstrap.Dropdown.getInstance(dropdownLink);
        dropdown.hide();
    });
    
    // Click functionality - navigate to services page
    dropdownLink.addEventListener('click', function(e) {
        // Only navigate if clicking directly on the main link (not when dropdown is open)
        if (!dropdownElement.classList.contains('show')) {
            window.location.href = this.href;
        }
    });
});
</script>

</body>
</html><?php /**PATH E:\project\3thMonths\Gypsum board gypsum selling\resources\views/index.blade.php ENDPATH**/ ?>