<style>
        :root {
            --primary-color: #3D6B63;   /* main brand color (buttons, headings, links) */
            --secondary-color: #B85C38; /* accent / highlights (badges, icons) */
            --accent-color: #E6C66A;    /* support / call-to-action (buttons hover, highlights) */

            /* --- Neutrals derived from only these three colors --- */
            --bg-color: #FFF9F4;         /* use as background, very light neutral */
            --text-color: #3D6B63;       /* primary text */
            --text-muted: #B85C38;       /* secondary text, subheadings */
        }

      
        .why-choose-us {
            background: var(--bg-color);
            padding: 80px 0;
            border-top: 3px solid var(--accent-color);
            border-bottom: 3px solid var(--accent-color);
        }

        .section-header {
            text-align: center;
            margin-bottom: 60px;
        }

        .section-title {
            color: var(--primary-color);
            font-weight: 800;
            margin-bottom: 20px;
            line-height: 1.3;
        }

        .section-title span {
            color: var(--secondary-color);
        }

        .section-subtitle {
            color: var(--text-muted);
            font-size: 1.2rem;
            max-width: 800px;
            margin: 0 auto;
            line-height: 1.6;
        }

        .section-subtitle strong {
            color: var(--secondary-color);
        }

        /* Feature Cards */
        .feature-card {
            background: white;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(61, 107, 99, 0.1);
            transition: all 0.4s ease;
            border: 2px solid transparent;
            height: 100%;
            position: relative;
        }

        .feature-card.top-card {
            margin-top: 30px;
        }

        .feature-card.bottom-card {
            margin-bottom: 30px;
        }

        .feature-card:hover {
            transform: translateY(-12px);
            box-shadow: 0 20px 40px rgba(61, 107, 99, 0.2);
            border-color: var(--accent-color);
        }

        .feature-image {
            height: 200px;
            overflow: hidden;
            position: relative;
        }

        .feature-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.4s ease;
        }

        .feature-card:hover .feature-image img {
            transform: scale(1.1);
        }

        .feature-content {
            padding: 30px 25px;
            text-align: center;
        }

        .feature-title {
            color: var(--primary-color);
            font-weight: 700;
            margin-bottom: 15px;
            font-size: 1.3rem;
        }

        .feature-description {
            color: var(--text-color);
            line-height: 1.7;
            margin-bottom: 0;
        }

        .feature-description strong {
            color: var(--secondary-color);
        }

        .phone-number {
            color: var(--secondary-color);
            font-weight: 700;
            direction: ltr;
            display: inline-block;
        }

        /* CTA Buttons */
        .cta-buttons {
            text-align: center;
            margin-top: 50px;
        }

        .cta-btn {
            padding: 14px 35px;
            border-radius: 30px;
            font-weight: 700;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 10px;
            transition: all 0.3s ease;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15);
            margin: 0 10px;
        }

        .cta-btn.primary {
            background: var(--secondary-color);
            color: white;
        }

        .cta-btn.primary:hover {
            background: var(--primary-color);
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(184, 92, 56, 0.4);
            color: white;
        }

        .cta-btn.secondary {
            background: var(--accent-color);
            color: var(--text-color);
        }

        .cta-btn.secondary:hover {
            background: var(--secondary-color);
            color: white;
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(184, 92, 56, 0.4);
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .why-choose-us {
                padding: 60px 0;
            }

            .section-title {
                font-size: 2rem;
            }

            .section-subtitle {
                font-size: 1.1rem;
            }

            .feature-card.top-card,
            .feature-card.bottom-card {
                margin: 15px 0;
            }

            .feature-content {
                padding: 25px 20px;
            }

            .cta-buttons {
                margin-top: 40px;
            }

            .cta-btn {
                padding: 12px 30px;
                margin: 5px;
                width: 100%;
                justify-content: center;
            }
        }

        @media (max-width: 576px) {
            .why-choose-us {
                padding: 40px 0;
            }

            .section-title {
                font-size: 1.7rem;
            }

            .section-subtitle {
                font-size: 1rem;
            }

            .feature-image {
                height: 180px;
            }

            .feature-content {
                padding: 20px 15px;
            }

            .feature-title {
                font-size: 1.2rem;
            }

            .cta-btn {
                padding: 12px 25px;
                font-size: 0.9rem;
            }
        }
    </style>


    <section class="why-choose-us">
        <div class="container">
            <div class="section-header">
                <h2 class="section-title display-5 fw-bold">
                    لماذا تختارنا في <span>تفصيل وتركيب الستائر بالرياض؟</span>
                </h2>
                <p class="section-subtitle">
                    لأننا نقدم أفضل خدمات <strong>تفصيل ستائر الرياض</strong> و<strong>تركيب ستائر الرياض</strong> باحترافية عالية،
                    وجودة لا تُضاهى في جميع أنواع <strong>الستائر الفاخرة بالرياض</strong> و<strong>ستائر حسب الطلب بالرياض</strong>.
                </p>
            </div>

            <div class="row g-4">

                <!-- Card 1 -->
                <div class="col-lg-3 col-md-6">
                    <div class="feature-card top-card">
                        <div class="feature-image">
                            <img src="images/High Quality and Guarantee.webp" 
                                 alt="ستائر فاخرة الرياض" loading="lazy">
                        </div>
                        <div class="feature-content">
                            <h4 class="feature-title">جودة عالية وضمان</h4>
                            <p class="feature-description">
                                نقدم أجود أنواع <strong>الستائر الفاخرة في الرياض</strong> مع تفصيل دقيق
                                وخامات مستوردة تضمن الفخامة والمتانة. جميع أعمالنا بضمان كامل.
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Card 2 -->
                <div class="col-lg-3 col-md-6">
                    <div class="feature-card bottom-card">
                        <div class="feature-image">
                            <img src="images/curtains.webp" 
                                 alt="تركيب ستائر الرياض" loading="lazy">
                        </div>
                        <div class="feature-content">
                            <h4 class="feature-title">تركيب احترافي بدون تلف</h4>
                            <p class="feature-description">
                                خبراء <strong>تركيب ستائر الرياض</strong> يقومون بالتركيب دون إحداث أي ضرر للجدران،
                                باستخدام أحدث الأدوات لضمان الثبات والجمال.
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Card 3 -->
                <div class="col-lg-3 col-md-6">
                    <div class="feature-card top-card">
                        <div class="feature-image">
                            <img src="images/Custom Designs.webp" 
                                 alt="ستائر حسب الطلب الرياض" loading="lazy">
                        </div>
                        <div class="feature-content">
                            <h4 class="feature-title">تصاميم حسب الطلب</h4>
                            <p class="feature-description">
                                نوفر أفضل <strong>ستائر حسب الطلب بالرياض</strong> مع تصميمات كلاسيكية، مودرن، رول،
                                و<strong>ستائر بلاك اوت الرياض</strong> بما يناسب ذوقك الخاص.
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Card 4 -->
                <div class="col-lg-3 col-md-6">
                    <div class="feature-card bottom-card">
                        <div class="feature-image">
                            <img src="images/Fast Service and 24-7 Support.webp" 
                                 alt="محلات ستائر في الرياض" loading="lazy">
                        </div>
                        <div class="feature-content">
                            <h4 class="feature-title">خدمة سريعة ودعم 24/7</h4>
                            <p class="feature-description">
                                نلبّي جميع طلباتك خلال 24 ساعة من خلال أقوى <strong>محلات ستائر في الرياض</strong>.
                                تواصل معنا على <span class="phone-number">0581495036</span> لعرض زيارة ومعاينة مجانية.
                            </p>
                        </div>
                    </div>
                </div>

            </div>

            <!-- CTA Buttons -->
            

        </div>
    </section><?php /**PATH E:\project\8thmonth\curtainsserviceriyadh.shop\resources\views/newSection.blade.php ENDPATH**/ ?>