<!DOCTYPE html>
<html lang="ar">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <title>تصليح غسالات ومكيفات بالرياض</title>

  <!-- SEO Meta Tags -->
  <meta name="description" content="خدمات تصليح غسالات في الرياض لجميع الأنواع مثل إل جي، سامسونج، توشيبا، دايو والأوتوماتيكية. صيانة سريعة وفعالة مع فنيين محترفين.">
  <meta name="keywords" content="تصليح غسالات في الرياض, تصليح غسالات إل جي, تصليح غسالات سامسونج, صيانة غسالات سامسونج, تصليح غسالات توشيبا, صيانة غسالات إل جي, تصليح غسالات أوتوماتيكية, تصليح غسالات دايو, فني غسالات أوتوماتيكية">
  <meta name="author" content="خدمات تصليح غسالات ومكيفات في الرياض">

  <!-- Canonical URL -->
  <link rel="canonical" href="https://washingmachineandacrepairriyadh.shop/">

  <!-- Open Graph Meta Tags -->
  <meta property="og:title" content="تصليح غسالات ومكيفات بالرياض | خدمات صيانة محترفة">
  <meta property="og:description" content="تصليح غسالات إل جي، سامسونج، توشيبا، دايو والأوتوماتيكية في الرياض بواسطة فنيين متخصصين. صيانة سريعة وفعالة لضمان رضا العملاء.">
  <meta property="og:image" content="https://washingmachineandacrepairriyadh.shop/images/og-image.jpg">
  <meta property="og:url" content="https://washingmachineandacrepairriyadh.shop/">
  <meta property="og:type" content="website">

  <!-- Twitter Card -->
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="تصليح غسالات ومكيفات بالرياض | صيانة سريعة وموثوقة">
  <meta name="twitter:description" content="خدمات تصليح وصيانة الغسالات والمكيفات في الرياض لجميع الأنواع مع فنيين محترفين. احصل على عرض سعر مجاني اليوم.">
  <meta name="twitter:image" content="https://washingmachineandacrepairriyadh.shop/images/og-image.jpg">

  <!-- Favicons -->
  <link rel="icon" href="images/cropped-WhatsApp-Image-2025-05-16-at-5.44.02-PM-32x32.jpeg" type="image/png" sizes="32x32">
  <link rel="icon" type="image/png" sizes="16x16" href="images/favicon-16x16.png">
  <link rel="icon" type="image/png" sizes="32x32" href="images/favicon-32x32.png">
  <link rel="apple-touch-icon" sizes="180x180" href="images/apple-touch-icon.png">

  <!-- Stylesheets -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>

  <!-- Robots -->
  <meta name="robots" content="index, follow">

   <meta name="google-site-verification" content="your-verification-code"> 
  <style>
    html, body {
        max-width: 100%;
        overflow-x: hidden;
        background-color: var(--bg-color);
        color: var(--text-color);
        font-family: 'Tajawal', sans-serif;
        direction: ltr;
    }

   </style>
<?php echo $__env->make('nav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<section 
  class="hero-section d-flex flex-column justify-content-center align-items-center text-center"
  style="
    background: url('images/washing.webp') center center / cover no-repeat;
    min-height: 50vh;
  "
>
  <div class="container">
    <h1 class="display-4 fw-bold mb-3 animate__animated animate__fadeInDown text-black">
إصلاح الغسالات    </h1>

    <nav aria-label="breadcrumb" class="animate__animated animate__fadeInUp">
      <ol class="breadcrumb justify-content-center mb-0">
        <li class="breadcrumb-item">
          <a href="/" class="text-black text-decoration-none">
            الرئيسية
          </a>
        </li>
        <li class="breadcrumb-item active text-black" aria-current="page">
إصلاح الغسالات        </li>
      </ol>
    </nav>
  </div>
</section>

 <style>
        :root {
            --primary: #2c5fa5;
            --primary-dark: #1e4a8d;
            --secondary: #ffc107;
            --secondary-dark: #e0a800;
            --success: #28a745;
            --success-dark: #1e7e34;
            --light: #f8f9fa;
            --dark: #343a40;
            --gray: #6c757d;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
        }
        
        .section-title {
            position: relative;
            margin-bottom: 3rem;
        }
        
        .section-title h2 {
            font-weight: 700;
            color: var(--primary);
            margin-bottom: 1rem;
        }
        
        .section-title .title-decoration {
            height: 4px;
            width: 80px;
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            border-radius: 2px;
            margin: 0 auto;
        }
        
        .section-title p {
            color: var(--gray);
            max-width: 600px;
            margin: 0 auto;
        }
        
        /* About Section */
        .about-section {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            padding: 5rem 0;
        }
        
        .about-img-container {
            position: relative;
            border-radius: 16px;
            overflow: hidden;
            box-shadow: 0 8px 25px rgba(0,0,0,0.1);
        }
        
        .about-img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.5s ease;
        }
        
        .about-img-container:hover .about-img {
            transform: scale(1.05);
        }
        
        .img-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(135deg, rgba(44, 95, 165, 0.8), rgba(30, 74, 141, 0.7));
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        .about-img-container:hover .img-overlay {
            opacity: 1;
        }
        
        .overlay-content {
            text-align: center;
            color: white;
        }
        
        .floating-badge {
            position: absolute;
            padding: 10px 20px;
            border-radius: 25px;
            color: white;
            font-weight: 600;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 8px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            z-index: 10;
        }
        
        .badge-1 {
            top: 10%;
            left: -15px;
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            animation: float 3s ease-in-out infinite;
        }
        
        .badge-2 {
            bottom: 20%;
            right: -15px;
            background: linear-gradient(135deg, var(--success), var(--success-dark));
            animation: float 3s ease-in-out infinite 1.5s;
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-10px); }
        }
        
        .service-highlight {
            background: white;
            padding: 25px;
            border-radius: 16px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.08);
            margin-bottom: 25px;
            border-right: 4px solid;
            transition: all 0.3s ease;
        }
        
        .service-highlight:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.12);
        }
        
        .washing-service {
            border-right-color: var(--success);
        }
        
        .brands-service {
            border-right-color: var(--secondary);
        }
        
        .service-icon {
            width: 60px;
            height: 60px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            margin-bottom: 15px;
        }
        
        .washing-icon {
            background: linear-gradient(135deg, var(--success), var(--success-dark));
        }
        
        .brands-icon {
            background: linear-gradient(135deg, var(--secondary), var(--secondary-dark));
        }
        
        /* Services Section */
        .services-section {
            padding: 5rem 0;
            background: white;
        }
        
        .service-card {
            background: white;
            border-radius: 16px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0,0,0,0.08);
            transition: all 0.3s ease;
            height: 100%;
            border-top: 4px solid var(--primary);
        }
        
        .service-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 30px rgba(0,0,0,0.15);
        }
        
        .service-img {
            height: 200px;
            width: 100%;
            object-fit: cover;
        }
        
        .service-content {
            padding: 25px;
        }
        
        .service-content h4 {
            color: var(--primary);
            margin-bottom: 15px;
            font-weight: 700;
        }
        
        .service-content p {
            color: var(--gray);
            margin-bottom: 20px;
        }
        
        .service-btn {
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            color: white;
            border: none;
            padding: 10px 25px;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }
        
        .service-btn:hover {
            background: linear-gradient(135deg, var(--primary-dark), var(--primary));
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(44, 95, 165, 0.3);
            color: white;
        }
        
        /* Why Choose Us Section */
        .why-choose-section {
            padding: 5rem 0;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        }
        
        .feature-box {
            text-align: center;
            padding: 30px 20px;
            background: white;
            border-radius: 16px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.08);
            transition: all 0.3s ease;
            height: 100%;
        }
        
        .feature-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.12);
        }
        
        .feature-icon {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            font-size: 30px;
            color: white;
        }
        
        .feature-1 {
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
        }
        
        .feature-2 {
            background: linear-gradient(135deg, var(--secondary), var(--secondary-dark));
        }
        
        .feature-3 {
            background: linear-gradient(135deg, var(--success), var(--success-dark));
        }
        
        .feature-4 {
            background: linear-gradient(135deg, #dc3545, #c82333);
        }
        
        .feature-box h4 {
            color: var(--primary);
            margin-bottom: 15px;
            font-weight: 700;
        }
        
        .feature-box p {
            color: var(--gray);
        }
        
        /* Working Steps Section */
        .steps-section {
            padding: 5rem 0;
            background: white;
        }
        
        .step-card {
            text-align: center;
            padding: 30px 20px;
            position: relative;
        }
        
        .step-number {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            font-weight: 700;
            margin: 0 auto 20px;
            position: relative;
            z-index: 2;
        }
        
        .step-content h4 {
            color: var(--primary);
            margin-bottom: 15px;
            font-weight: 700;
        }
        
        .step-content p {
            color: var(--gray);
        }
        
        .steps-connector {
            position: absolute;
            top: 30px;
            right: -50%;
            width: 100%;
            height: 2px;
            background: var(--primary);
            z-index: 1;
        }
        
        @media (max-width: 768px) {
            .steps-connector {
                display: none;
            }
        }
        
        /* CTA Section */
        .cta-section {
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            color: white;
            padding: 4rem 0;
            text-align: center;
        }
        
        .cta-section h3 {
            margin-bottom: 1.5rem;
            font-weight: 700;
        }
        
        .cta-section p {
            margin-bottom: 2rem;
            font-size: 1.1rem;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
        }
        
        .cta-buttons {
            display: flex;
            justify-content: center;
            gap: 15px;
            flex-wrap: wrap;
        }
        
        .cta-btn {
            padding: 12px 30px;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }
        
        .cta-btn-primary {
            background: white;
            color: var(--primary);
        }
        
        .cta-btn-primary:hover {
            background: var(--light);
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.2);
            color: var(--primary);
        }
        
        .cta-btn-whatsapp {
            background: #25D366;
            color: white;
        }
        
        .cta-btn-whatsapp:hover {
            background: #128C7E;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(37, 211, 102, 0.3);
            color: white;
        }
        
        /* Footer */
        .footer {
            background: var(--dark);
            color: white;
            padding: 3rem 0 1.5rem;
        }
        
        .footer h5 {
            color: var(--secondary);
            margin-bottom: 1.5rem;
            font-weight: 700;
        }
        
        .footer-links {
            list-style: none;
            padding: 0;
        }
        
        .footer-links li {
            margin-bottom: 10px;
        }
        
        .footer-links a {
            color: #adb5bd;
            text-decoration: none;
            transition: color 0.3s ease;
        }
        
        .footer-links a:hover {
            color: white;
        }
        
        .copyright {
            border-top: 1px solid #495057;
            padding-top: 1.5rem;
            margin-top: 2rem;
            text-align: center;
            color: #adb5bd;
        }
        
        /* Responsive Adjustments */
        @media (max-width: 768px) {
            .about-img-container {
                margin-bottom: 2rem;
            }
            
            .floating-badge {
                display: none;
            }
            
            .cta-buttons {
                flex-direction: column;
                align-items: center;
            }
            
            .cta-btn {
                width: 100%;
                max-width: 250px;
                justify-content: center;
            }
        }
    </style>

    <!-- About Section -->
    <section class="about-section" id="about">
        <div class="container">
            <div class="row align-items-center">
                <!-- Image Column -->
                <div class="col-lg-6 mb-5 mb-lg-0">
                    <div class="about-img-container">
                        <img src="images/washing-machine-motor-repair.jpg" alt="تصليح غسالات في الرياض" class="about-img">
                        <div class="img-overlay">
                            <div class="overlay-content">
                                <i class="bi bi-tools display-4 mb-3"></i>
                                <h4>فني غسالات محترف</h4>
                                <p>خدمات صيانة متكاملة في الرياض</p>
                            </div>
                        </div>
                        <div class="floating-badge badge-1">
                            <i class="bi bi-star-fill"></i>
                            <span>ضمان الجودة</span>
                        </div>
                        <div class="floating-badge badge-2">
                            <i class="bi bi-clock"></i>
                            <span>خدمة 24/7</span>
                        </div>
                    </div>
                </div>
                
                <!-- Content Column -->
                <div class="col-lg-6">
                    <div class="ps-lg-5">
                        <div class="section-title text-center text-lg-start">
                            <h2>مركز صيانة الغسالات المتكامل في الرياض</h2>
                            <div class="title-decoration mb-3"></div>
                            <p>نقدم خدمات تصليح وصيانة الغسالات الأتوماتيكية بجميع أنواعها مع ضمان الجودة والكفاءة</p>
                        </div>
                        
                        <div class="service-highlight washing-service">
                            <div class="service-icon washing-icon">
                                <i class="bi bi-droplet text-white"></i>
                            </div>
                            <h4>تصليح جميع أنواع الغسالات</h4>
                            <p class="mb-0">نختص في <strong>تصليح غسالات إل جي، سامسونج، توشيبا، دايو</strong> وجميع الماركات العالمية. نقدم خدمات شاملة تشمل إصلاح الحوض، الموتور، المجفف، والأعطال الكهربائية والميكانيكية باحترافية عالية.</p>
                        </div>
                        
                        <div class="service-highlight brands-service">
                            <div class="service-icon brands-icon">
                                <i class="bi bi-gear text-white"></i>
                            </div>
                            <h4>صيانة الغسالات الأتوماتيكية</h4>
                            <p class="mb-0">فريقنا من <strong>فنيي الغسالات المحترفين</strong> جاهز لتقديم الحلول الفورية لأي عطل تواجهه في غسالتك. نستخدم قطع غيار أصلية مع ضمان شامل على جميع أعمالنا في جميع أنحاء الرياض.</p>
                        </div>
                        
                        <div class="mt-4">
                            <a href="https://wa.me/966583907768" class="service-btn">
                                <i class="bi bi-whatsapp"></i>
                                تواصل عبر واتساب
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Services Section -->
    <section class="services-section" id="services">
        <div class="container">
            <div class="section-title text-center">
                <h2>خدماتنا المتخصصة</h2>
                <div class="title-decoration mb-3"></div>
                <p>نقدم مجموعة شاملة من خدمات صيانة وتصليح الغسالات لتلبية جميع احتياجاتك</p>
            </div>
            
            <div class="row g-4">
                <!-- Service 1 -->
                <div class="col-md-6 col-lg-4">
                    <div class="service-card">
                        <img src="images/washing-machine-drum-repair.jpg" alt="تصليح غسالات إل جي" class="service-img">
                        <div class="service-content">
                            <h4>تصليح غسالات إل جي</h4>
                            <p>إصلاح شامل لجميع موديلات غسالات إل جي الأتوماتيكية والعادية. نعالج الأعطال الفنية بقطع غيار أصلية.</p>
<a href="https://wa.me/966583907768"                            class="service-btn">
                                <i class="bi bi-whatsapp"></i>
احجز الآن                            </a>
                        </div>
                    </div>
                </div>
                
                <!-- Service 2 -->
                <div class="col-md-6 col-lg-4">
                    <div class="service-card">
                        <img src="images/washing-machine-repair-service.jpg" alt="تصليح غسالات سامسونج" class="service-img">
                        <div class="service-content">
                            <h4>تصليح غسالات سامسونج</h4>
                            <p>صيانة متخصصة لغسالات سامسونج بجميع أنواعها. إصلاح الأعطال الإلكترونية والميكانيكية باحترافية.</p>
<a href="https://wa.me/966583907768"                            class="service-btn">
                                <i class="bi bi-whatsapp"></i>
احجز الآن                            </a>
                        </div>
                    </div>
                </div>
                
                <!-- Service 3 -->
                <div class="col-md-6 col-lg-4">
                    <div class="service-card">
                        <img src="https://images.unsplash.com/photo-1626806787461-102c1bfaaea1?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=500&q=80" alt="تصليح غسالات توشيبا" class="service-img">
                        <div class="service-content">
                            <h4>تصليح غسالات توشيبا</h4>
                            <p>خدمات إصلاح متكاملة لغسالات توشيبا. معالجة جميع المشاكل الفنية بضمان على العمل والقطع.</p>
                            <a href="https://wa.me/966583907768"
                             class="service-btn">
                                <i class="bi bi-whatsapp"></i>
احجز الآن                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Why Choose Us Section -->
    <section class="why-choose-section" id="why-us">
        <div class="container">
            <div class="section-title text-center">
                <h2>لماذا تختار خدماتنا؟</h2>
                <div class="title-decoration mb-3"></div>
                <p>نتميز بتقديم خدمات صيانة الغسالات بأعلى معايير الجودة والاحترافية</p>
            </div>
            
            <div class="row g-4">
                <div class="col-md-6 col-lg-3">
                    <div class="feature-box">
                        <div class="feature-icon feature-1">
                            <i class="bi bi-tools"></i>
                        </div>
                        <h4>فنيون متخصصون</h4>
                        <p>فريق من الفنيين المدربين والمتخصصين في صيانة جميع أنواع الغسالات الأتوماتيكية</p>
                    </div>
                </div>
                
                <div class="col-md-6 col-lg-3">
                    <div class="feature-box">
                        <div class="feature-icon feature-2">
                            <i class="bi bi-shield-check"></i>
                        </div>
                        <h4>ضمان الجودة</h4>
                        <p>نقدم ضمانًا شاملاً على جميع أعمال الصيانة والقطع المستبدلة لضمان راحتك</p>
                    </div>
                </div>
                
                <div class="col-md-6 col-lg-3">
                    <div class="feature-box">
                        <div class="feature-icon feature-3">
                            <i class="bi bi-clock"></i>
                        </div>
                        <h4>خدمة سريعة</h4>
                        <p>نصل إليك في أسرع وقت ممكن مع خدمة طوارئ متاحة على مدار الساعة طوال أيام الأسبوع</p>
                    </div>
                </div>
                
                <div class="col-md-6 col-lg-3">
                    <div class="feature-box">
                        <div class="feature-icon feature-4">
                            <i class="bi bi-currency-dollar"></i>
                        </div>
                        <h4>أسعار مناسبة</h4>
                        <p>نقدم خدمات عالية الجودة بأسعار تنافسية ومناسبة لجميع العملاء</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Working Steps Section -->
    <section class="steps-section" id="steps">
        <div class="container">
            <div class="section-title text-center">
                <h2>كيفية طلب الخدمة</h2>
                <div class="title-decoration mb-3"></div>
                <p>خطوات بسيطة للحصول على خدمة تصليح غسالات محترفة في الرياض</p>
            </div>
            
            <div class="row">
                <div class="col-md-6 col-lg-3">
                    <div class="step-card">
                        <div class="step-number">1</div>
                        <div class="step-content">
                            <h4>اتصل بنا</h4>
                            <p>اتصل بنا عبر الهاتف أو واتساب لوصف المشكلة التي تواجهها مع غسالتك</p>
                        </div>
                        <div class="steps-connector d-none d-lg-block"></div>
                    </div>
                </div>
                
                <div class="col-md-6 col-lg-3">
                    <div class="step-card">
                        <div class="step-number">2</div>
                        <div class="step-content">
                            <h4>تحديد الموعد</h4>
                            <p>نحدد معك موعدًا مناسبًا لزيارة فني متخصص إلى منزلك في الرياض</p>
                        </div>
                        <div class="steps-connector d-none d-lg-block"></div>
                    </div>
                </div>
                
                <div class="col-md-6 col-lg-3">
                    <div class="step-card">
                        <div class="step-number">3</div>
                        <div class="step-content">
                            <h4>التشخيص والإصلاح</h4>
                            <p>يقوم الفني بتشخيص العطل وإصلاحه باستخدام قطع غيار أصلية وموثوقة</p>
                        </div>
                        <div class="steps-connector d-none d-lg-block"></div>
                    </div>
                </div>
                
                <div class="col-md-6 col-lg-3">
                    <div class="step-card">
                        <div class="step-number">4</div>
                        <div class="step-content">
                            <h4>ضمان الخدمة</h4>
                            <p>نقدم ضمانًا على العمل والقطع المستبدلة لضمان راحتك وثقتك بخدماتنا</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
   

<?php echo $__env->make('footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

 
    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- WOW.js for animations -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/wow/1.1.2/wow.min.js"></script>
<script>
        new WOW().init();
    </script>
<script>
  document.addEventListener('DOMContentLoaded', function() {
    const container = document.querySelector('.ba-container');
    const before = container.querySelector('.ba-before');
    const handle = container.querySelector('.ba-handle');

    const onMove = e => {
      const rect = container.getBoundingClientRect();
      const x = (e.touches ? e.touches[0].clientX : e.clientX) - rect.left;
      const pct = Math.max(0, Math.min(x, rect.width));
      before.style.width = pct + 'px';
      handle.style.left = pct + 'px';
    };
    handle.addEventListener('mousedown', () => {
      document.addEventListener('mousemove', onMove);
    });
    document.addEventListener('mouseup', () => {
      document.removeEventListener('mousemove', onMove);
    });
    // Touch events
    handle.addEventListener('touchstart', () => {
      document.addEventListener('touchmove', onMove);
    });
    document.addEventListener('touchend', () => {
      document.removeEventListener('touchmove', onMove);
    });
  });
</script>


    <script>
        // Initialize WOW.js
        new WOW().init();
        
        // Auto-rotate carousel every 5 seconds
        document.addEventListener('DOMContentLoaded', function() {
            var myCarousel = document.getElementById('heroCarousel');
            var carousel = new bootstrap.Carousel(myCarousel, {
                interval: 5000,
                ride: 'carousel'
            });
        });
    </script>
    <!-- Add this JavaScript -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const dropdownElement = document.getElementById('servicesDropdown');
    const dropdownLink = document.getElementById('servicesDropdownLink');
    
    // Hover functionality
    dropdownElement.addEventListener('mouseenter', function() {
        const dropdown = new bootstrap.Dropdown(dropdownLink);
        dropdown.show();
    });
    
    dropdownElement.addEventListener('mouseleave', function() {
        const dropdown = bootstrap.Dropdown.getInstance(dropdownLink);
        dropdown.hide();
    });
    
    // Click functionality - navigate to services page
    dropdownLink.addEventListener('click', function(e) {
        // Only navigate if clicking directly on the main link (not when dropdown is open)
        if (!dropdownElement.classList.contains('show')) {
            window.location.href = this.href;
        }
    });
});
</script>

</body>
</html><?php /**PATH E:\project\6thmonths\washingmachineandacrepairriyadh.shop\resources\views/washing-machines.blade.php ENDPATH**/ ?>