<style>
    /* Custom CSS with professional color scheme */
    :root {
        --primary-color: #2c5fa5;
        --secondary-color: #ffc107;
        --accent-color: #28a745;
        --text-color: #333;
        --text-muted: #666;
        --border-color: #e9ecef;
        --bg-color: #f8f9fa;
        --highlight-color: rgba(44, 95, 165, 0.1);
    }
    
    .cs_height_80, .cs_height_lg_80 {
        height: 80px;
    }
    .cs_height_27, .cs_height_lg_65 {
        height: 27px;
    }
    .cs_height_120, .cs_height_lg_105 {
        height: 120px;
    }
    @media (min-width: 992px) {
        .cs_height_lg_80 {
            height: 80px;
        }
        .cs_height_lg_65 {
            height: 65px;
        }
        .cs_height_lg_105 {
            height: 105px;
        }
    }
    
    .cs_section_subtitle {
        font-size: 18px;
        margin-bottom: 12px;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        text-transform: uppercase;
        color: var(--secondary-color);
    }
    
    .cs_section_title {
        font-size: 40px;
        margin-bottom: 0;
        font-weight: 700;
        color: var(--primary-color);
    }
    
    .cs_row_gap_40 {
        row-gap: 40px;
    }
    
    .cs_gap_y_40 {
        margin-top: 40px;
        margin-bottom: 40px;
    }
    
    .cs_feature_text {
        margin-bottom: 30px;
        font-size: 16px;
        line-height: 1.6;
        color: var(--text-color);
    }
    
    .cs_iconbox {
        display: flex;
        gap: 15px;
        margin-bottom: 12px;
        align-items: flex-start;
    }
    
    .cs_iconbox_icon {
        width: 50px;
        height: 50px;
        background-color: var(--highlight-color);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }
    
    .cs_iconbox_icon img {
        width: 24px;
        height: 24px;
    }
    
    .cs_iconbox_info h3 {
        font-size: 18px;
        margin-bottom: 2px;
        font-weight: 600;
        color: var(--primary-color);
    }
    
    .cs_iconbox_subtitle {
        font-size: 12px;
        color: var(--text-muted);
        line-height: 1.5;
        margin-bottom: 0;
    }
    
    .cs_btn {
        display: inline-flex;
        align-items: center;
        padding: 12px 24px;
        background-color: var(--primary-color);
        color: white;
        border-radius: 5px;
        text-decoration: none;
        font-weight: 500;
        transition: all 0.3s ease;
    }
    
    .cs_btn:hover {
        background-color: var(--accent-color);
        color: white;
    }
    
    /* Card styling */
    .cs_card {
        background-color: white;
        border: 1px solid var(--border-color);
        border-radius: 16px;
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.05);
        transition: transform 0.3s, box-shadow 0.3s;
        height: 100%;
        padding: 30px;
        text-align: center;
    }

    .cs_card:hover {
        transform: translateY(-10px);
        box-shadow: 0 12px 30px rgba(44, 95, 165, 0.15);
    }

    .cs_icon {
        width: 80px;
        height: 80px;
        background: linear-gradient(135deg, var(--primary-color), #1e4a8d);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 28px;
        color: white;
        margin: 0 auto 20px;
        box-shadow: 0 8px 20px rgba(44, 95, 165, 0.2);
    }

    .cs_card h3 {
        color: var(--primary-color);
        font-weight: 700;
        margin-bottom: 15px;
        font-size: 22px;
    }

    .cs_card p {
        color: var(--text-color);
        margin-bottom: 10px;
        line-height: 1.6;
    }

    .cs_card .text-muted {
        color: var(--text-muted);
    }
    
    /* Section with background image */
    .cs_why_choose_us {
        position: relative;
        overflow: hidden;
    }
    
    .cs_why_choose_us::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-image: url('images/service-background.jpg');
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        opacity: 0.05;
        z-index: 1;
    }
    
    .cs_why_choose_us .container {
        position: relative;
        z-index: 2;
    }
    
    /* Content with image section */
    .cs_content_with_image {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        border-radius: 20px;
        overflow: hidden;
        box-shadow: 0 20px 40px rgba(0,0,0,0.1);
    }
    
    .cs_image_side {
        position: relative;
        min-height: 400px;
        background-image: url('images/technician-working.jpg');
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
    }
    
    .cs_image_side::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(135deg, rgba(44, 95, 165, 0.9), rgba(30, 74, 141, 0.8));
        opacity: 0.8;
    }
    
    .cs_image_content {
        position: relative;
        z-index: 2;
        padding: 40px;
        color: white;
        height: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }
    
    .cs_image_content h3 {
        font-size: 28px;
        font-weight: 700;
        margin-bottom: 20px;
        color: white;
    }
    
    .cs_image_content ul {
        list-style: none;
        padding: 0;
        margin: 0;
    }
    
    .cs_image_content ul li {
        padding: 8px 0;
        font-size: 16px;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .cs_image_content ul li i {
        color: var(--secondary-color);
        font-size: 18px;
    }
    
    .cs_content_side {
        padding: 40px;
        background: white;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .cs_content_image {
        width: 100%;
        height: 100%;
        min-height: 300px;
        background-image: url('images/ac-repair-service.jpg');
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        border-radius: 12px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    }
    
    @media (max-width: 991.98px) {
        .cs_image_side {
            min-height: 300px;
        }
        
        .cs_image_content,
        .cs_content_side {
            padding: 30px;
        }
        
        .cs_content_image {
            min-height: 250px;
        }
    }
    
    @media (max-width: 767.98px) {
        .cs_image_content,
        .cs_content_side {
            padding: 25px;
        }
        
        .cs_section_title {
            font-size: 32px;
        }
        
        .cs_content_image {
            min-height: 200px;
        }
    }
</style>

<section class="cs_why_choose_us py-5">
  <div class="container">
    <div class="text-center mb-5">
      <h3 class="cs_section_subtitle">
        <i class="bi bi-star-fill"></i>
        لماذا تختارنا
        <i class="bi bi-star-fill"></i>
      </h3>
      <h2 class="cs_section_title">مركز الصيانة المتكامل للمكيفات والغسالات</h2>
      <p class="cs_feature_text">متخصصون في <strong>صيانة مكيفات الرياض</strong> و<strong>تصليح الغسالات الأتوماتيك</strong> بجودة عالية وقطع غيار أصلية مع خدمة 24 ساعة</p>
    </div>

    <div class="row g-4">
      <!-- Card 1 -->
      <div class="col-md-4">
        <div class="cs_card">
          <div class="cs_icon">
            <i class="bi bi-tools"></i>
          </div>
          <h3>فنيون متخصصون</h3>
          <p class="text-muted mb-2">
            فريق من <strong>فنيي المكيفات</strong> و<strong>مصلحي الغسالات</strong> المحترفين
          </p>
          <p>
            نقدم خدمات <strong>صيانة مكيفات سبليت</strong> و<strong>إصلاح الغسالات الأتوماتيك</strong> بأعلى معايير الجودة
          </p>
        </div>
      </div>

      <!-- Card 2 -->
      <div class="col-md-4">
        <div class="cs_card">
          <div class="cs_icon">
            <i class="bi bi-clock"></i>
          </div>
          <h3>خدمة 24 ساعة</h3>
          <p class="text-muted mb-2">
            خدمة طوارئ متاحة على مدار الساعة
          </p>
          <p>
            <strong>صيانة مكيفات 24 ساعة الرياض</strong> في جميع المناطق شمال الرياض، غرب الرياض، شرق الرياض
          </p>
        </div>
      </div>

      <!-- Card 3 -->
      <div class="col-md-4">
        <div class="cs_card">
          <div class="cs_icon">
            <i class="bi bi-shield-check"></i>
          </div>
          <h3>ضمان الجودة</h3>
          <p class="text-muted mb-2">
            قطع غيار أصلية وضمان على العمل
          </p>
          <p>
            نضمن لك جودة الصيانة مع متابعة مستمرة بعد الخدمة
          </p>
        </div>
      </div>
    </div>

    <!-- Content with Image Section -->
    <div class="cs_content_with_image mt-5">
      <div class="row g-0">
        <!-- Image Side -->
        <div class="col-lg-6">
          <div class="cs_image_side">
            <div class="cs_image_content">
              <h3>خدماتنا الشاملة</h3>
              <ul>
                <li><i class="bi bi-check-circle-fill"></i> <strong>صيانة مكيفات سبليت الرياض</strong> بجميع أنواعها</li>
                <li><i class="bi bi-check-circle-fill"></i> <strong>إصلاح غسالة سامسونج</strong> والماركات العالمية</li>
                <li><i class="bi bi-check-circle-fill"></i> <strong>صيانة مكيفات مركزي</strong> والأنظمة المتكاملة</li>
                <li><i class="bi bi-check-circle-fill"></i> <strong>تصليح موتور النشافة</strong> والأعطال الكهربائية</li>
                <li><i class="bi bi-check-circle-fill"></i> <strong>تنظيف وتعقيم المكيفات</strong> بشكل احترافي</li>
                <li><i class="bi bi-check-circle-fill"></i> <strong>إصلاح حوض الغسالة</strong> والمشاكل الميكانيكية</li>
              </ul>
            </div>
          </div>
        </div>
        
        <!-- Content Side - Replaced with Image -->
        <div class="col-lg-6">
          <div class="cs_content_side">
            <div class="cs_content_image"></div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<div class="cs_height_80 cs_height_lg_80"></div><?php /**PATH E:\project\3thMonths\falseceilingandgypsumwork.shop\resources\views/newSection.blade.php ENDPATH**/ ?>