 <style>
        :root {
            --primary-color: #3D6B63;   /* main brand color (buttons, headings, links) */
            --secondary-color: #B85C38; /* accent / highlights (badges, icons) */
            --accent-color: #E6C66A;    /* support / call-to-action (buttons hover, highlights) */

            /* --- Neutrals derived from only these three colors --- */
            --bg-color: #FFF9F4;         /* use as background, very light neutral */
            --text-color: #3D6B63;       /* primary text */
            --text-muted: #B85C38;       /* secondary text, subheadings */
        }

      

        .services-section {
            background-color: var(--bg-color);
            padding: 80px 0;
        }

        .section-header {
            margin-bottom: 60px;
        }

        .section-badge {
            background: var(--accent-color);
            color: var(--text-color);
            padding: 8px 20px;
            border-radius: 20px;
            font-weight: 700;
            font-size: 0.9rem;
            display: inline-block;
            margin-bottom: 15px;
            box-shadow: 0 4px 15px rgba(230, 198, 106, 0.3);
        }

        .section-title {
            color: var(--primary-color);
            font-weight: 800;
            margin-bottom: 20px;
            line-height: 1.2;
        }

        .section-subtitle {
            color: var(--text-muted);
            font-size: 1.2rem;
            line-height: 1.6;
        }

        /* Service Cards */
        .service-card {
            background: white;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(61, 107, 99, 0.1);
            transition: all 0.3s ease;
            border: 2px solid transparent;
            height: 100%;
        }

        .service-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(61, 107, 99, 0.2);
            border-color: var(--accent-color);
        }

        .service-image {
            height: 220px;
            overflow: hidden;
            position: relative;
        }

        .service-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.3s ease;
        }

        .service-card:hover .service-image img {
            transform: scale(1.1);
        }

        .service-content {
            padding: 25px;
            text-align: center;
        }

        .service-title {
            color: var(--primary-color);
            font-weight: 700;
            margin-bottom: 15px;
            font-size: 1.3rem;
        }

        .service-description {
            color: var(--text-color);
            margin-bottom: 20px;
            line-height: 1.6;
        }

        .service-btn {
            background: var(--primary-color);
            color: white;
            border: none;
            border-radius: 25px;
            padding: 12px 25px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
            box-shadow: 0 6px 20px rgba(61, 107, 99, 0.3);
            gap: 8px;
        }

        .service-btn:hover {
            background: var(--secondary-color);
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(184, 92, 56, 0.4);
        }

        /* Specialized Services Section */
        .specialized-section {
            background: linear-gradient(135deg, var(--primary-color), #2d5a52);
            padding: 80px 0;
        }

        .specialized-header {
            text-align: center;
            margin-bottom: 50px;
        }

        .specialized-title {
            color: white;
            font-weight: 800;
            margin-bottom: 15px;
        }

        .specialized-subtitle {
            color: rgba(255, 255, 255, 0.9);
            font-size: 1.1rem;
            margin-bottom: 20px;
        }

        .separator {
            display: flex;
            justify-content: center;
            gap: 5px;
        }

        .separator span {
            height: 3px;
            border-radius: 2px;
        }

        .separator span:nth-child(1) {
            background: var(--accent-color);
            width: 30px;
        }

        .separator span:nth-child(2) {
            background: rgba(255, 255, 255, 0.7);
            width: 15px;
        }

        .separator span:nth-child(3) {
            background: rgba(255, 255, 255, 0.7);
            width: 15px;
        }

        .specialized-card {
            background: white;
            border-radius: 12px;
            padding: 30px 25px;
            text-align: center;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
            height: 100%;
            border: 2px solid transparent;
        }

        .specialized-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.15);
            border-color: var(--accent-color);
        }

        .specialized-icon {
            width: 60px;
            height: 60px;
            background: var(--primary-color);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.5rem;
            margin: 0 auto 20px;
            box-shadow: 0 6px 20px rgba(61, 107, 99, 0.3);
        }

        .specialized-card-title {
            color: var(--primary-color);
            font-weight: 700;
            margin-bottom: 15px;
            font-size: 1.2rem;
        }

        .specialized-card-text {
            color: var(--text-color);
            line-height: 1.6;
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .services-section, .specialized-section {
                padding: 60px 0;
            }

            .section-title {
                font-size: 2rem;
            }

            .service-image {
                height: 200px;
            }

            .service-content {
                padding: 20px;
            }

            .specialized-card {
                padding: 25px 20px;
            }
        }

        @media (max-width: 576px) {
            .services-section, .specialized-section {
                padding: 40px 0;
            }

            .section-title {
                font-size: 1.7rem;
            }

            .service-image {
                height: 180px;
            }

            .specialized-card {
                padding: 20px 15px;
            }
        }
    </style>

    <!-- Main Services Section -->
    <section class="services-section position-relative">
        <div class="container">
            <!-- Section Heading -->
            <div class="row align-items-end mb-5">
                <div class="col-lg-8 mb-4 mb-lg-0">
                    <div class="section-badge">
                        مركز تفصيل الستائر الفاخرة بالرياض
                    </div>
                    <h1 class="section-title display-4 fw-bold">
                        تفصيل وتركيب ستائر بجودة واحترافية
                    </h1>
                </div>
                <div class="col-lg-4">
                    <p class="section-subtitle mb-0">
                        شركة رائدة في <strong>تفصيل ستائر الرياض</strong> و<strong>تركيب ستائر بلاك اوت</strong>. نقدم خدمات 24 ساعة بأسعار تنافسية مع ضمان على العمل وفنيين متخصصين.
                    </p>
                </div>
            </div>

            <!-- Services Cards - 6 Cards -->
            <div class="row g-4">
                <!-- Service 1 - تفصيل ستائر حسب الطلب -->
                <div class="col-md-6 col-lg-4">
                    <div class="service-card">
                        <div class="service-image">
                            <img src="images/Bedroom Curtains.jpeg"
                                 loading="lazy"
                                 alt="تفصيل ستائر حسب الطلب الرياض">
                        </div>
                        <div class="service-content">
                            <h3 class="service-title">تفصيل ستائر حسب الطلب</h3>
                            <p class="service-description">خدمات تفصيل شاملة للستائر بمقاسات دقيقة وأقمشة فاخرة تناسب جميع الأذواق والمساحات.</p>
                            <a href="tel:+966533681853" class="service-btn">
                                <i class="bi bi-telephone-fill"></i>
                                اتصل: 0533681853
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Service 2 - تركيب ستائر بلاك اوت -->
                <div class="col-md-6 col-lg-4">
                    <div class="service-card">
                        <div class="service-image">
                            <img src="images/Hall curtains.jpeg"
                                 loading="lazy"
                                 alt="تركيب ستائر بلاك اوت الرياض">
                        </div>
                        <div class="service-content">
                            <h3 class="service-title">تركيب ستائر بلاك اوت</h3>
                            <p class="service-description">تركيب احترافي لستائر بلاك اوت عازلة للضوء والصوت بجودة عالية وضمان على التركيب.</p>
                            <a href="tel:+966533681853" class="service-btn">
                                <i class="bi bi-telephone-fill"></i>
                                اتصل: 0533681853
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Service 3 - ستائر جاهزة -->
                <div class="col-md-6 col-lg-4">
                    <div class="service-card">
                        <div class="service-image">
                            <img src="images/A variety of ready-made curtains.webp"
                                 loading="lazy"
                                 alt="ستائر جاهزة الرياض">
                        </div>
                        <div class="service-content">
                            <h3 class="service-title">ستائر جاهزة متنوعة</h3>
                            <p class="service-description">تشكيلة واسعة من الستائر الجاهزة بمقاسات وألوان متنوعة تناسب جميع الغرف والأماكن.</p>
                            <a href="tel:+966533681853" class="service-btn">
                                <i class="bi bi-telephone-fill"></i>
                                اتصل: 0533681853
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Service 4 - تركيب ستائر فاخرة -->
                <div class="col-md-6 col-lg-4">
                    <div class="service-card">
                        <div class="service-image">
                            <img src="images/Office Curtains.jpeg"
                                 loading="lazy"
                                 alt="تركيب ستائر فاخرة الرياض">
                        </div>
                        <div class="service-content">
                            <h3 class="service-title">تركيب ستائر فاخرة</h3>
                            <p class="service-description">تركيب متقن للستائر الفاخرة بأحدث التصاميم والإبداعات لتعزيز جمال مساحتك.</p>
                            <a href="tel:+966533681853" class="service-btn">
                                <i class="bi bi-telephone-fill"></i>
                                اتصل: 0533681853
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Service 5 - ستائر مطرزة -->
                <div class="col-md-6 col-lg-4">
                    <div class="service-card">
                        <div class="service-image">
                            <img src="images/Luxury Blackout Curtains.jpeg"
                                 loading="lazy"
                                 alt="ستائر مطرزة الرياض">
                        </div>
                        <div class="service-content">
                            <h3 class="service-title">ستائر مطرزة وفاخرة</h3>
                            <p class="service-description">ستائر مطرزة بتصاميم فاخرة وأنيقة تضيف لمسة من الفخامة والأناقة لمساحتك.</p>
                            <a href="tel:+966533681853" class="service-btn">
                                <i class="bi bi-telephone-fill"></i>
                                اتصل: 0533681853
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Service 6 - خدمة 24 ساعة -->
                <div class="col-md-6 col-lg-4">
                    <div class="service-card">
                        <div class="service-image">
                            <img src="images/24-hour curtain installation service.webp"
                                 loading="lazy"
                                 alt="خدمة تركيب ستائر 24 ساعة الرياض">
                        </div>
                        <div class="service-content">
                            <h3 class="service-title">خدمة 24 ساعة</h3>
                            <p class="service-description">خدمة طوارئ على مدار الساعة لتفصيل وتركيب الستائر في جميع مناطق الرياض.</p>
                            <a href="tel:+966533681853" class="service-btn">
                                <i class="bi bi-telephone-fill"></i>
                                اتصل: 0533681853
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Specialized Services Section -->
    <section class="specialized-section">
        <div class="container">
            <div class="specialized-header">
                <h2 class="specialized-title display-5 fw-bold">خدمات الستائر المتخصصة</h2>
                <p class="specialized-subtitle">
                    نغطي جميع أنواع الستائر والتصاميم بفريق فني محترف وأقمشة فاخرة
                </p>
                <div class="separator">
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
            </div>
            <div class="row g-4">
                
                <!-- Service 1 -->
                <div class="col-md-6 col-lg-4">
                    <div class="specialized-card">
                        <div class="specialized-icon">
                            <i class="bi bi-scissors"></i>
                        </div>
                        <h5 class="specialized-card-title">تفصيل ستائر غرف النوم</h5>
                        <p class="specialized-card-text">
                            تفصيل مخصص لستائر غرف النوم بأقمشة مريحة وألوان هادئة تناسب أجواء الاسترخاء.
                        </p>
                    </div>
                </div>
                
                <!-- Service 2 -->
                <div class="col-md-6 col-lg-4">
                    <div class="specialized-card">
                        <div class="specialized-icon">
                            <i class="bi bi-house-door"></i>
                        </div>
                        <h5 class="specialized-card-title">ستائر صالات واستقبال</h5>
                        <p class="specialized-card-text">
                            تصميم وتنفيذ ستائر فاخرة للصالات والاستقبال تعكس الذوق الرفيع والأناقة.
                        </p>
                    </div>
                </div>
                
                <!-- Service 3 -->
                <div class="col-md-6 col-lg-4">
                    <div class="specialized-card">
                        <div class="specialized-icon">
                            <i class="bi bi-building"></i>
                        </div>
                        <h5 class="specialized-card-title">ستائر المكاتب والشركات</h5>
                        <p class="specialized-card-text">
                            ستائر احترافية للمكاتب والشركات تجمع بين الجمال والوظيفية والخصوصية.
                        </p>
                    </div>
                </div>

                <!-- Service 4 -->
                <div class="col-md-6 col-lg-4">
                    <div class="specialized-card">
                        <div class="specialized-icon">
                            <i class="bi bi-palette"></i>
                        </div>
                        <h5 class="specialized-card-title">ستائر مطابخ وحمامات</h5>
                        <p class="specialized-card-text">
                            ستائر عملية ومقاومة للرطوبة تناسب المطابخ والحمامات بمقاسات وألوان متنوعة.
                        </p>
                    </div>
                </div>

                <!-- Service 5 -->
                <div class="col-md-6 col-lg-4">
                    <div class="specialized-card">
                        <div class="specialized-icon">
                            <i class="bi bi-sun"></i>
                        </div>
                        <h5 class="specialized-card-title">ستائر شقق مفروشة</h5>
                        <p class="specialized-card-text">
                            حلول متكاملة لستائر الشقق المفروشة تجمع بين الجمال والعملي والاقتصادي.
                        </p>
                    </div>
                </div>

                <!-- Service 6 -->
                <div class="col-md-6 col-lg-4">
                    <div class="specialized-card">
                        <div class="specialized-icon">
                            <i class="bi bi-star"></i>
                        </div>
                        <h5 class="specialized-card-title">استشارات ديكور مجانية</h5>
                        <p class="specialized-card-text">
                            استشارات متخصصة في اختيار الستائر المناسبة لديكور منزلك أو مكتبك مجاناً.
                        </p>
                    </div>
                </div>
                
            </div>
        </div>
    </section><?php /**PATH E:\project\6thmonths\curtainsupplierandmaker.shop\resources\views/servicesSection.blade.php ENDPATH**/ ?>