<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>FAJ Technical Services LLC</title>
    <link rel="icon" href="<?php echo e(asset('assets/image.jpg')); ?>">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css"/>
<!-- JS -->
    <style>
   /* ☑️ Top Contact Bar */
/* ☑️ Top Contact Bar - Smaller Height */
.navbar-top {
  background-color: #050b23;
  color: #fff;
  font-size: 0.9rem;
  padding: 0.4rem 20px; /* Reduced padding for smaller height */
}

/* Center content in the top bar */
.navbar-top .contact-center {
  flex: 1;
  display: flex;
  justify-content: center;
  gap: 2rem;
}

.navbar-top a {
  color: #fff;
  text-decoration: none;
  margin-left: 1rem;
}

/* ☑️ Main Navbar - Increased Height */
.navbar-main {
  background-color: #f8f9fa;
  padding: 1.5rem 30px; /* Increased padding for height */
   box-shadow: inset 0 -2px 0 #050b23;  /* Bottom black line (like black border) */
  position: relative;
  z-index: 10;
}

/* Navigation links */
.navbar-main .nav-link {
  color: #0e1d40;
  font-weight: 500;
  margin: 0 0.5rem;
  padding-bottom: 4px;
}

.navbar-main .nav-link:hover,
.navbar-main .nav-link:focus {
  color: #003d5c;
}

/* ☑️ Book Now Button */
.book-btn {
  background-color: #003d5c;
  color: #fff;
  font-weight: 600;
  padding: 0.5rem 1.25rem;
  border-radius: 0.25rem;
}

.book-btn:hover {
  background-color: #00557a;
  color: #fff;
}

.book-btn .bi {
  font-size: 1.1rem;
  vertical-align: middle;
  margin-left: 0.25rem;
}

/* ☑️ Logo Styling */
.faj-logo {
  height: 140px;
  width: auto;
  object-fit: contain;
  padding: 0;
  margin: 0;
  display: block;
  position: relative;
  top: -20px;
}

/* ☑️ Responsive Logo */
@media (max-width: 768px) {
 .navbar-collapse {
    background-color: #000 !important; /* Set background color to black */
  }

  .navbar-nav .nav-link {
    color: #fff !important; /* Make the menu links white for contrast */
  }
  .faj-logo {
    height: 100px;         /* Not too small like 50px */
    width: auto;
    top: -10px;
    margin: 0;
    padding: 0;
    object-fit: contain;
    display: block;
        background-color: #000 !important;

  }
}

</style>
</head>

<body>
  <!-- 🔝 Top Contact Bar -->
  <div class="navbar-top d-flex justify-content-between align-items-center">
    <!-- Left padding space is already handled by padding -->
    <div class="contact-center">
      <span><i class="bi bi-telephone-fill"></i> +971 4 330 0002</span>
      <span><i class="bi bi-whatsapp"></i> +971 50 746 4712</span>
      <span><i class="bi bi-geo-alt-fill"></i> Dubai – United Arab Emirates</span>
    </div>
    <div class="d-flex align-items-center">
      <a href="#"><i class="bi bi-instagram"></i></a>
      <a href="#" class="ms-3"><i class="bi bi-twitter"></i></a>
      <a href="#" class="ms-3"><i class="bi bi-youtube"></i></a>
      <a href="#" class="ms-3"><i class="bi bi-facebook"></i></a>
    </div>
  </div>

  <!-- 📌 Main Navbar -->
 <nav class="navbar navbar-expand-lg navbar-main shadow-sm" style="height: 80px; padding: 0;">
  <div class="container-fluid px-0">

    <!-- ✅ Logo: Smaller height & proportional width -->
<a class="navbar-brand d-flex align-items-center" href="<?php echo e(url('/')); ?>">
  <img src="<?php echo e(asset('Assets/logo.png')); ?>" alt="FAJ Logo" class="faj-logo" style="margin-top: 3px;">
</a>

      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNavbar">
        <span class="navbar-toggler-icon"></span>
      </button>

      <div class="collapse navbar-collapse" id="mainNavbar">
        <ul class="navbar-nav mx-auto mb-2 mb-lg-0">
          <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/')); ?>">Home</a></li>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">Services</a>
            <ul class="dropdown-menu">
              <li><a class="dropdown-item" href="<?php echo e(url('/services')); ?>">All Services</a></li>
            </ul>
          </li>
          <li class="nav-item"><a class="nav-link" href="<?php echo e(route('careers')); ?>">Careers</a></li>
          <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/blogs')); ?>">Blogs</a></li>
          <li class="nav-item"><a class="nav-link" href="<?php echo e(route('about')); ?>">About Us</a></li>
          <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/contact')); ?>">Contact Us</a></li>
        </ul>

        <a href="#" class="book-btn text-decoration-none d-flex align-items-center">
          BOOK NOW <i class="bi bi-arrow-up-right"></i>
        </a>
      </div>
    </div>
  </nav>



    <div class="container mt-4">
        <?php echo $__env->yieldContent('content'); ?>
    </div>
      <main>
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Bootstrap JS -->
     <!-- CSS -->

<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH E:\fajservices\fajservices\resources\views/layouts/app.blade.php ENDPATH**/ ?>