 <style>
        :root {
            --primary-color: #3D6B63;   /* main brand color (buttons, headings, links) */
            --secondary-color: #B85C38; /* accent / highlights (badges, icons) */
            --accent-color: #E6C66A;    /* support / call-to-action (buttons hover, highlights) */

            /* --- Neutrals derived from only these three colors --- */
            --bg-color: #FFF9F4;         /* use as background, very light neutral */
            --text-color: #3D6B63;       /* primary text */
            --text-muted: #B85C38;       /* secondary text, subheadings */
        }

       

        .cs_about {
            background: var(--bg-color);
            padding: 80px 0;
            position: relative;
        }

        /* Image Grid Styles */
        .cs_about_thumbnail {
            position: relative;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(61, 107, 99, 0.15);
            height: 280px;
            transition: all 0.4s ease;
            border: 3px solid transparent;
        }

        .cs_about_thumbnail:hover {
            transform: translateY(-8px);
            box-shadow: 0 20px 40px rgba(61, 107, 99, 0.25);
            border-color: var(--accent-color);
        }

        .cs_about_thumbnail img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.4s ease;
        }

        .cs_about_thumbnail:hover img {
            transform: scale(1.05);
        }

        .image-overlay {
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, rgba(61, 107, 99, 0.85), rgba(184, 92, 56, 0.75));
            opacity: 0;
            transition: opacity 0.4s ease;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .cs_about_thumbnail:hover .image-overlay {
            opacity: 1;
        }

        .overlay-content {
            color: white;
            text-align: center;
            transform: translateY(20px);
            transition: transform 0.4s ease;
        }

        .cs_about_thumbnail:hover .overlay-content {
            transform: translateY(0);
        }

        .overlay-content i {
            font-size: 2.5rem;
            margin-bottom: 10px;
            color: var(--accent-color);
        }

        .overlay-content h5 {
            font-size: 1.3rem;
            font-weight: 700;
            margin: 0;
        }

        /* Floating Badges */
        .floating-badge {
            padding: 12px 20px;
            border-radius: 25px;
            color: white;
            font-size: 14px;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 8px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
            animation: float 3s infinite ease-in-out;
            border: 2px solid white;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-10px); }
        }

        /* Section Heading */
        .section-line {
            width: 50px;
            height: 3px;
            background: var(--secondary-color);
            border-radius: 2px;
        }

        .section-badge {
            background: var(--primary-color);
            color: white;
            padding: 8px 20px;
            border-radius: 25px;
            font-weight: 600;
            font-size: 0.95rem;
            margin: 0 15px;
            box-shadow: 0 4px 15px rgba(61, 107, 99, 0.2);
        }

        .section-heading {
            color: var(--primary-color);
            font-weight: 800;
            line-height: 1.3;
            margin-bottom: 30px;
        }

        .section-heading span {
            color: var(--secondary-color);
        }

        /* Service Paragraphs */
        .service-paragraph {
            background: white;
            padding: 25px;
            border-radius: 15px;
            box-shadow: 0 8px 25px rgba(61, 107, 99, 0.1);
            margin-bottom: 25px;
            border-right: 4px solid var(--secondary-color);
            transition: all 0.3s ease;
        }

        .service-paragraph:hover {
            transform: translateX(-5px);
            box-shadow: 0 12px 30px rgba(61, 107, 99, 0.15);
        }

        .service-header {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
            gap: 15px;
        }

        .service-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.3rem;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        .service-title {
            color: var(--secondary-color);
            font-weight: 700;
            margin: 0;
            font-size: 1.3rem;
        }

        .service-paragraph p {
            color: var(--text-color);
            line-height: 1.8;
            margin: 0;
        }

        .service-paragraph strong {
            color: var(--secondary-color);
        }

        /* CTA Section */
        .cta-card {
            background: white;
            border-right: 4px solid var(--primary-color);
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(61, 107, 99, 0.15);
            margin-top: 30px;
        }

        .cta-content {
            display: flex;
            align-items: center;
            gap: 20px;
            margin-bottom: 20px;
        }

        .cta-icon {
            width: 60px;
            height: 60px;
            background: var(--primary-color);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.5rem;
            box-shadow: 0 6px 20px rgba(61, 107, 99, 0.3);
        }

        .cta-content h5 {
            color: var(--primary-color);
            font-weight: 700;
            margin-bottom: 5px;
        }

        .cta-content p {
            color: var(--text-muted);
            margin-bottom: 8px;
            font-size: 0.95rem;
        }

        .cta-phone {
            color: var(--secondary-color);
            font-weight: 700;
            font-size: 1.2rem;
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .cta-phone:hover {
            color: var(--primary-color);
        }

        .cta-buttons {
            display: flex;
            gap: 15px;
        }

        .cta-btn {
            padding: 12px 25px;
            border-radius: 10px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
            border: 2px solid transparent;
        }

        .cta-btn.primary {
            background: var(--primary-color);
            color: white;
            box-shadow: 0 6px 20px rgba(61, 107, 99, 0.3);
        }

        .cta-btn.primary:hover {
            background: var(--secondary-color);
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(184, 92, 56, 0.4);
        }

        .cta-btn.success {
            background: var(--accent-color);
            color: var(--text-color);
            box-shadow: 0 6px 20px rgba(230, 198, 106, 0.3);
        }

        .cta-btn.success:hover {
            background: var(--secondary-color);
            color: white;
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(184, 92, 56, 0.4);
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .cs_about {
                padding: 60px 0;
            }

            .cs_about_thumbnail {
                height: 220px;
            }

            .section-heading {
                font-size: 1.8rem;
            }

            .cta-buttons {
                flex-direction: column;
            }

            .cta-content {
                flex-direction: column;
                text-align: center;
            }

            .floating-badge {
                display: none;
            }
        }

        @media (max-width: 576px) {
            .service-header {
                flex-direction: column;
                text-align: center;
                gap: 10px;
            }

            .section-badge {
                margin: 10px 0;
                display: block;
                text-align: center;
            }

            .d-flex.align-items-center {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>

    <section class="cs_about cs_style_1 position-relative" style="direction: rtl;">
        <div class="container">
            <div class="row g-5 align-items-center">

                <!-- Right Column - Image Grid -->
                <div class="col-lg-6">
                    <div class="position-relative">
                        
                        <!-- Image Grid -->
                        <div class="row g-4">
                            <div class="col-md-8 col-12">
                                <div class="cs_about_thumbnail">
                                    <img src="images/Curtain Tailoring.webp" alt="تفصيل ستائر الرياض" loading="lazy">
                                    <div class="image-overlay">
                                        <div class="overlay-content">
                                            <i class="bi bi-brush"></i>
                                            <h5>تفصيل ستائر</h5>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="cs_about_thumbnail">
                                    <img src="images/Installation of curtains.webp" alt="ستائر فاخرة الرياض" loading="lazy">
                                    <div class="image-overlay">
                                        <div class="overlay-content">
                                            <i class="bi bi-house"></i>
                                            <h5>تركيب ستائر</h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Floating Badges -->
                        <div class="position-absolute" style="top: 15%; left: -15px;">
                            <div class="floating-badge" style="background: var(--primary-color);">
                                <i class="bi bi-star-fill"></i>
                                <span>جودة عالية</span>
                            </div>
                        </div>

                        <div class="position-absolute" style="bottom: 20%; right: -15px;">
                            <div class="floating-badge" style="background: var(--secondary-color);">
                                <i class="bi bi-clock"></i>
                                <span>متاح 24/7</span>
                            </div>
                        </div>

                    </div>
                </div>

                <!-- Left Column - Content -->
                <div class="col-lg-6">
                    <div class="pe-lg-4">

                        <!-- Section Heading -->
                        <div class="mb-4">
                            <div class="d-flex align-items-center mb-3">
                                <div class="section-line"></div>
                                <span class="section-badge">الرياض - تفصيل وتركيب ستائر فاخرة</span>
                                <div class="section-line"></div>
                            </div>
                            <h2 class="section-heading display-6 fw-bold">
                                خبراء <span>تفصيل ستائر</span> و<span>تركيب ستائر فاخرة بالرياض</span>
                            </h2>
                        </div>

                        <!-- Curtains Tailoring -->
                        <div class="service-paragraph mb-4">
                            <div class="service-header">
                                <div class="service-icon" style="background: var(--secondary-color);">
                                    <i class="bi bi-scissors text-white"></i>
                                </div>
                                <h4 class="service-title">تفصيل ستائر حسب الطلب</h4>
                            </div>
                            <p>
                                نقدم <strong>تفصيل ستائر الرياض</strong> بمقاسات دقيقة وفق أحدث التصاميم العصرية والكلاسيكية.
                                نقوم بتوفير <strong>ستائر بلاك اوت</strong>، ستائر فاخرة، ستائر رول، وستائر غرف النوم
                                مع خامات عالية الجودة وتركيب احترافي يناسب جميع أنواع المنازل، الفلل، والمكاتب.
                            </p>
                        </div>

                        <!-- Curtains Installation -->
                        <div class="service-paragraph mb-4">
                            <div class="service-header">
                                <div class="service-icon" style="background: var(--primary-color);">
                                    <i class="bi bi-hammer text-white"></i>
                                </div>
                                <h4 class="service-title">تركيب ستائر فاخرة</h4>
                            </div>
                            <p>
                                نوفر <strong>خدمة تركيب ستائر بالرياض</strong> بكل احترافية وبدون أي تلف للجدران أو النوافذ.
                                تشمل خدمتنا تركيب ستائر جاهزة، ستائر خشبية، ستائر معدنية وستائر الرول مع ضمان التركيب السليم والثبات.
                                نستخدم أدوات حديثة ونوفر دعم فني متواصل بعد الخدمة.
                            </p>
                        </div>

                        <!-- CTA Section -->
                        <div class="cta-card">
                            <div class="cta-content">
                                <div class="cta-icon"><i class="bi bi-headset"></i></div>
                                <div>
                                    <h5 class="mb-1">خدمة عملاء متوفرة على مدار الساعة</h5>
                                    <p class="mb-1">اطلب زيارة مجانية واستشارة متخصصة</p>
                                    <a href="tel:+966533681853" class="cta-phone">0533681853</a>
                                    <br>
                                    <a href="mailto:info@curtainsupplierandmaker.shop" class="small" style="color: var(--text-muted);">info@curtainsupplierandmaker.shop</a>
                                </div>
                            </div>
                            <div class="cta-buttons">
                                <a href="tel:+966533681853" class="cta-btn primary"><i class="bi bi-telephone me-2"></i>اتصل الآن</a>
                                <a href="https://wa.me/966533681853" class="cta-btn success"><i class="bi bi-whatsapp me-2"></i>واتساب</a>
                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </div>
    </section><?php /**PATH E:\project\6thmonths\curtainsupplierandmaker.shop\resources\views/aboutSection.blade.php ENDPATH**/ ?>