<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

 <title>أعمال الجبس بورد والأسقف المعلقة في الرياض | تركيب بجودة عالية وتصاميم متميزة</title>

<!-- SEO Meta Tags -->
<meta name="description" content="متخصصون في أعمال الجبس بورد والأسقف المعلقة بالرياض. تركيب دقيق لتقسيمات الجبس، الأسقف المستعارة، تصاميم الحوائط والديكورات الداخلية. أسعار تنافسية وتقديم مجاني للعروض.">
<meta name="keywords" content="جبس بورد الرياض, أسقف معلقة, تركيب جبس, تصميم أسقف مستعارة, تقسيمات جبسية, ديكور داخلي, مقاولون جبس, خدمات جبس في السعودية">
<meta name="author" content="أعمال الجبس بورد والأسقف المعلقة">

<!-- Canonical URL -->
<link rel="canonical" href="https://www.gypsumboardandceilingworks.shop/">

<!-- Open Graph Meta Tags (Facebook, etc.) -->
<meta property="og:title" content="أعمال الجبس بورد والأسقف المعلقة في الرياض | خدمات تركيب متميزة">
<meta property="og:description" content="رواد أعمال الجبس بورد في الرياض للأسقف والتقسيمات والديكورات الداخلية. جودة في التنفيذ وضمان رضا العملاء.">
<meta property="og:image" content="https://www.gypsumboardandceilingworks.shop/images/og-image.jpg">
<meta property="og:url" content="https://www.gypsumboardandceilingworks.shop/">
<meta property="og:type" content="website">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="خدمات الجبس المحترفة في الرياض | أسقف وتقسيمات">
<meta name="twitter:description" content="تركيب محترف للجبس بورد وتصاميم أسقف متميزة للمنازل والشركات في الرياض. اطلب عرض سعر مجاني اليوم.">
<meta name="twitter:image" content="https://www.gypsumboardandceilingworks.shop/images/og-image.jpg">

<!-- Favicons -->
<link rel="icon" href="images/cropped-WhatsApp-Image-2025-05-16-at-5.44.02-PM-32x32.jpeg" type="image/png" sizes="32x32">
<link rel="icon" type="image/png" sizes="16x16" href="images/favicon-16x16.png">
<link rel="icon" type="image/png" sizes="32x32" href="images/favicon-32x32.png">
<link rel="apple-touch-icon" sizes="180x180" href="images/apple-touch-icon.png">

  <!-- Stylesheets -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>

  <!-- Robots -->
  <meta name="robots" content="index, follow">

   <meta name="google-site-verification" content="your-verification-code"> 
  <style>
    html, body {
        max-width: 100%;
        overflow-x: hidden;
        background-color: var(--bg-color);
        color: var(--text-color);
        font-family: 'Tajawal', sans-serif;
        direction: ltr;
    }

   </style>
<?php echo $__env->make('nav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<section class="hero-slider">
    <div class="slider-container">
        <!-- Slide 1 - صيانة مكيفات -->
        <div class="slide active" style="background-image: url('images/ac-repair-service.jpg');">
            <div class="slide-content">
                <div class="sub-title">صيانة مكيفات الرياض</div>
                <h1 class="title">صيانة مكيفات سبليت ومركزي 24 ساعة</h1>
                <div class="desc text-white">
                    <p>نقدم خدمات صيانة مكيفات سبليت شمال الرياض، غرب الرياض، شرق الرياض وجميع المناطق. فني مكيفات متخصص - صيانة مكيفات سامسونج - تنظيف وتعقيم شامل.</p>
                </div>
                <div class="service-features">
                    <span class="feature-tag">صيانة مكيفات سبليت الرياض</span>
                    <span class="feature-tag">صيانة مكيفات 24 ساعة الرياض</span>
                    <span class="feature-tag">صيانة مكيفات شمال الرياض</span>
                    <span class="feature-tag">صيانة مكيفات سامسونج الرياض</span>
                    <span class="feature-tag">صيانة مكيف مركزي الرياض</span>
                    <span class="feature-tag">تصليح مكيفات الرياض</span>
                </div>
                <a href="tel:+966583907768" class="btn btn-slider">
                    <i class="bi bi-telephone-fill me-2"></i>اتصل للصيانة
                </a>
            </div>
        </div>
        
        <!-- Slide 2 - تصليح غسالات -->
        <div class="slide" style="background-image: url('images/washing-machine-repair.jpg');">
            <div class="slide-content">
                <div class="sub-title">تصليح الغسالات</div>
                <h1 class="title">إصلاح جميع أنواع الغسالات الأتوماتيك</h1>
                <div class="desc text-white">
                    <p>متخصصون في إصلاح غسالة سامسونج، هيتاشي، ويرلبول والغسالات العادية. إصلاح حوض الغسالة - تصليح موتور النشافة - صيانة مجفف الغسالة.</p>
                </div>
                <div class="service-features">
                    <span class="feature-tag">اصلاح غسالة اتوماتيك</span>
                    <span class="feature-tag">اصلاح غسالة سامسونج</span>
                    <span class="feature-tag">إصلاح حوض الغسالة</span>
                    <span class="feature-tag">اصلاح موتور النشافه</span>
                    <span class="feature-tag">اصلاح الغسالات العادية</span>
                    <span class="feature-tag">صيانه غسالات اتوماتيك</span>
                </div>
                <a href="https://wa.me/966583907768" class="btn btn-slider">
                    <i class="bi bi-whatsapp me-2"></i>واتساب الآن
                </a>
            </div>
        </div>
        
        <!-- Slide 3 - صيانة متكاملة -->
        <div class="slide" style="background-image: url('images/ac-washing-repair.jpg');">
            <div class="slide-content">
                <div class="sub-title">خدمات متكاملة</div>
                <h1 class="title">شركة صيانة مكيفات وغسالات بالرياض</h1>
                <div class="desc text-white">
                    <p>نوفر خدمات صيانة مكيفات بالرياض وتصليح غسالات اتوماتيك بأسعار مناسبة. مصلح مكيفات معتمد - فني غسالات محترف - ضمان على الصيانة.</p>
                </div>
                <div class="service-features">
                    <span class="feature-tag">فني مكيفات الرياض</span>
                    <span class="feature-tag">مصلح مكيفات الرياض</span>
                    <span class="feature-tag">صيانه غسالات اتوماتيك</span>
                    <span class="feature-tag">شركة صيانة مكيفات الرياض</span>
                    <span class="feature-tag">اصلاح غسالة هيتاشي</span>
                    <span class="feature-tag">اصلاح غسالة ويرلبول</span>
                </div>
                <a href="tel:+966583907768" class="btn btn-slider">
                    <i class="bi bi-headset me-2"></i>استفسر الآن
                </a>
            </div>
        </div>
        
        <!-- Slider Controls -->
        <div class="slider-controls">
            <div class="slider-dot active" data-slide="0"></div>
            <div class="slider-dot" data-slide="1"></div>
            <div class="slider-dot" data-slide="2"></div>
        </div>
    </div>
</section>

<style>
    /* Hero Slider Styles */
    .hero-slider {
        position: relative;
        width: 100%;
        height: 100vh;
        overflow: hidden;
    }

    .slider-container {
        height: 100%;
        position: relative;
    }

    .slide {
        position: absolute;
        width: 100%;
        height: 100%;
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        opacity: 0;
        transition: opacity 1s ease-in-out;
        display: flex;
        align-items: center;
        padding: 0 5%;
    }

    .slide.active {
        opacity: 1;
        z-index: 1;
    }

    .slide-content {
        max-width: 600px;
        color: white;
        position: relative;
        z-index: 2;
        padding: 40px;
        background: linear-gradient(135deg, rgba(44, 95, 165, 0.9), rgba(30, 74, 141, 0.8));
        border-radius: 15px;
        animation: fadeInUp 1s ease-out;
        border-right: 4px solid #28a745;
    }

    .slide .title {
        font-size: 2.2rem;
        font-weight: 700;
        margin-bottom: 20px;
        color: #fff;
        line-height: 1.3;
    }

    .slide .sub-title {
        font-size: 1.2rem;
        color: #ffc107;
        margin-bottom: 15px;
        font-weight: 600;
    }

    .slide .desc {
        margin-bottom: 30px;
        line-height: 1.6;
        font-size: 1.1rem;
    }

    .service-features {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        margin: 15px 0;
    }

    .feature-tag {
        background: rgba(255,255,255,0.2);
        padding: 5px 12px;
        border-radius: 20px;
        font-size: 0.9rem;
        border: 1px solid rgba(255,255,255,0.3);
        white-space: nowrap;
    }

    /* Slider Controls */
    .slider-controls {
        position: absolute;
        bottom: 30px;
        left: 50%;
        transform: translateX(-50%);
        z-index: 10;
        display: flex;
        gap: 8px;
        padding: 5px;
        background-color: rgba(44, 95, 165, 0.5);
        border-radius: 20px;
    }

    .slider-dot {
        width: 10px;
        height: 10px;
        border-radius: 50%;
        background-color: rgba(255, 255, 255, 0.5);
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .slider-dot.active {
        background-color: #ffc107;
        transform: scale(1.3);
    }

    /* Slider Button */
    .btn-slider {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        padding: 12px 30px;
        background: linear-gradient(135deg, #28a745, #1e7e34);
        color: white;
        border: none;
        border-radius: 50px;
        font-weight: 600;
        font-size: 1.1rem;
        text-decoration: none;
        transition: all 0.3s ease;
        box-shadow: 0 4px 15px rgba(40, 167, 69, 0.3);
        min-width: 160px;
    }

    .btn-slider:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(40, 167, 69, 0.4);
        color: white;
        background: linear-gradient(135deg, #1e7e34, #28a745);
    }

    /* Responsive adjustments */
    @media (max-width: 768px) {
        .hero-slider {
            height: 80vh;
        }
        
        .slide-content {
            padding: 25px;
            width: 90%;
            margin: 0 auto;
            text-align: center;
        }
        
        .slide .title {
            font-size: 1.8rem;
        }
        
        .btn-slider {
            padding: 10px 25px;
            font-size: 1rem;
        }
        
        .slider-controls {
            bottom: 20px;
        }
    }
    
    @media (max-width: 480px) {
        .hero-slider {
            height: 100vh;
        }
        
        .slide .title {
            font-size: 1.5rem;
        }

        .slide-content {
            padding: 20px;
        }

        .service-features {
            justify-content: center;
        }

        .feature-tag {
            font-size: 0.8rem;
            padding: 4px 10px;
        }
    }

    @keyframes fadeInUp {
        from {
            transform: translateY(50px);
            opacity: 0;
        }
        to {
            transform: translateY(0);
            opacity: 1;
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const slides = document.querySelectorAll('.slide');
        const dots = document.querySelectorAll('.slider-dot');
        let currentSlide = 0;
        let slideInterval;
        
        function initSlider() {
            if (slides.length === 0) return;
            slideInterval = setInterval(nextSlide, 5000);
        }
        
        function goToSlide(n) {
            slides[currentSlide].classList.remove('active');
            dots[currentSlide].classList.remove('active');
            currentSlide = (n + slides.length) % slides.length;
            slides[currentSlide].classList.add('active');
            dots[currentSlide].classList.add('active');
            clearInterval(slideInterval);
            slideInterval = setInterval(nextSlide, 5000);
        }
        
        function nextSlide() {
            goToSlide(currentSlide + 1);
        }
        
        dots.forEach((dot, index) => {
            dot.addEventListener('click', () => goToSlide(index));
        });
        
        initSlider();
    });
</script>
<?php echo $__env->make('aboutSection', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <!-- 3thsection -->
  <?php echo $__env->make('servicesSection', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<!-- معرض أعمال الصيانة -->
<section class="py-5" style="background-color: #f8f9fa;">
  <div class="container">
    <div class="text-center mb-5">
      <div class="d-flex justify-content-center align-items-center mb-3">
        <span class="mx-2" style="color: #2c5fa5; font-size: 1.5rem;">✦</span>
        <h6 class="text-uppercase mb-0" style="color: #2c5fa5;">معرض أعمال الصيانة</h6>
        <span class="mx-2" style="color: #2c5fa5; font-size: 1.5rem;">✦</span>
      </div>
      <h2 class="mb-4" style="color: #333; font-weight: 700;">أحدث مشاريع صيانة المكيفات والغسالات</h2>
      <p class="w-75 mx-auto mb-4" style="color: #666; font-size: 1.1rem;">أعمال صيانة احترافية وتصليح دقيق تناسب جميع أنواع المكيفات والغسالات في الرياض</p>
    </div>

    <!-- Navigation Buttons -->
    <div class="d-flex justify-content-center mb-4">
      <button class="btn btn-outline-primary mx-2 gallery-btn active" data-gallery="gallery1">صيانة المكيفات</button>
      <button class="btn btn-outline-primary mx-2 gallery-btn" data-gallery="gallery2">تصليح الغسالات</button>
    </div>

    <!-- Gallery 1 - صيانة المكيفات (Visible by default) -->
    <div id="gallery1" class="gallery-group">
      <div class="row g-4">
        <div class="col-md-4">
          <div class="gallery-card">
            <img src="images/ac-split-repair-service.jpg" class="img-fluid rounded" alt="صيانة مكيفات سبليت الرياض">
            <div class="gallery-caption">
              <h5>صيانة مكيفات سبليت</h5>
              <p>فني متخصص في صيانة مكيفات السبليت بجميع أنواعها</p>
            </div>
          </div>
        </div>
        <div class="col-md-4">
          <div class="gallery-card">
            <img src="images/ac-central-repair.jpg" class="img-fluid rounded" alt="صيانة مكيف مركزي الرياض">
            <div class="gallery-caption">
              <h5>صيانة مكيفات مركزي</h5>
              <p>صيانة شاملة للمكيفات المركزية بأنظمتها المختلفة</p>
            </div>
          </div>
        </div>
        <div class="col-md-4">
          <div class="gallery-card">
            <img src="images/ac-cleaning-service.jpg" class="img-fluid rounded" alt="شركات تنظيف مكيفات بالرياض">
            <div class="gallery-caption">
              <h5>تنظيف وتعقيم المكيفات</h5>
              <p>خدمات تنظيف شاملة مع التعقيم لضمان هواء نقي</p>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Gallery 2 - تصليح الغسالات (Hidden by default) -->
    <div id="gallery2" class="gallery-group" style="display: none;">
      <div class="row g-4">
        <div class="col-md-4">
          <div class="gallery-card">
            <img src="images/washing-machine-repair-service.jpg" class="img-fluid rounded" alt="اصلاح غسالة اتوماتيك الرياض">
            <div class="gallery-caption">
              <h5>إصلاح غسالات أتوماتيك</h5>
              <p>تصليح جميع أنواع الغسالات الأتوماتيك بضمان</p>
            </div>
          </div>
        </div>
        <div class="col-md-4">
          <div class="gallery-card">
            <img src="images/washing-machine-motor-repair.jpg" class="img-fluid rounded" alt="اصلاح موتور النشافه الرياض">
            <div class="gallery-caption">
              <h5>إصلاح موتور النشافة</h5>
              <p>صيانة محركات النشافات بقطع غيار أصلية</p>
            </div>
          </div>
        </div>
        <div class="col-md-4">
          <div class="gallery-card">
            <img src="images/washing-machine-drum-repair.jpg" class="img-fluid rounded" alt="إصلاح حوض الغسالة الرياض">
            <div class="gallery-caption">
              <h5>إصلاح أحواض الغسالات</h5>
              <p>تصليح الأحواض المتسربة والتالفة باحترافية</p>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Call to Action -->
    <div class="text-center mt-5">
      <div class="row justify-content-center">
        <div class="col-lg-8">
          <div class="p-4 rounded" style="background: linear-gradient(135deg, #2c5fa5, #1e4a8d);">
            <h4 class="text-white mb-3">هل تحتاج إلى خدمة صيانة فورية؟</h4>
            <p class="text-white-50 mb-4">فريقنا الفني جاهز لخدمتك في جميع مناطق الرياض على مدار 24 ساعة</p>
            <div class="d-flex justify-content-center gap-3 flex-wrap">
              <a href="tel:+966583907768" class="btn btn-light px-4 py-2 rounded-pill d-inline-flex align-items-center">
                <i class="bi bi-telephone me-2"></i>
                <span>اتصل الآن: 0583907768</span>
              </a>
              <a href="https://wa.me/966583907768" class="btn btn-outline-light px-4 py-2 rounded-pill d-inline-flex align-items-center">
                <i class="bi bi-whatsapp me-2"></i>
                <span>تواصل عبر واتساب</span>
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<style>
  .gallery-card {
    position: relative;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    height: 300px;
    margin-bottom: 20px;
    transition: all 0.3s ease;
    border: 1px solid #e9ecef;
  }
  
  .gallery-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 30px rgba(44, 95, 165, 0.2);
  }
  
  .gallery-card img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.3s ease;
  }
  
  .gallery-card:hover img {
    transform: scale(1.05);
  }
  
  .gallery-caption {
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    background: linear-gradient(to top, rgba(44, 95, 165, 0.9), transparent);
    color: white;
    padding: 20px;
    text-align: right;
  }
  
  .gallery-caption h5 {
    font-weight: 700;
    margin-bottom: 5px;
    font-size: 1.2rem;
  }
  
  .gallery-caption p {
    margin-bottom: 0;
    font-size: 0.9rem;
    opacity: 0.9;
  }
  
  .gallery-btn {
    border: 2px solid #2c5fa5;
    color: #2c5fa5;
    padding: 10px 25px;
    border-radius: 30px;
    background-color: transparent;
    font-weight: 600;
    font-size: 1rem;
    margin: 0 10px;
    cursor: pointer;
    transition: all 0.3s ease;
  }
  
  .gallery-btn:hover, .gallery-btn.active {
    background-color: #2c5fa5;
    color: white;
    transform: translateY(-2px);
  }
  
  @media (max-width: 767px) {
    .gallery-card {
      height: 250px;
      margin: 0 auto 20px;
      max-width: 100%;
    }
    
    .gallery-caption {
      padding: 15px;
    }
    
    .gallery-caption h5 {
      font-size: 1rem;
    }
    
    .gallery-caption p {
      font-size: 0.8rem;
    }
    
    .gallery-btn {
      padding: 8px 20px;
      font-size: 0.9rem;
      margin: 5px;
    }
  }
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
  const buttons = document.querySelectorAll('.gallery-btn');
  
  buttons.forEach(button => {
    button.addEventListener('click', function() {
      // Remove active class from all buttons
      buttons.forEach(btn => btn.classList.remove('active'));
      
      // Add active class to clicked button
      this.classList.add('active');
      
      // Hide all galleries
      document.querySelectorAll('.gallery-group').forEach(gallery => {
        gallery.style.display = 'none';
      });
      
      // Show selected gallery
      const galleryId = this.getAttribute('data-gallery');
      document.getElementById(galleryId).style.display = 'block';
    });
  });
});
</script>
<!-- mmm -->
   <?php echo $__env->make('newSection', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
 <!-- 6th section -->


<!-- 7th section -->


<?php echo $__env->make('newSection2', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<!-- Google Map -->
<div class="container-fluid p-0 my-5">
  <div style="height: 300px;">
    <iframe
      loading="lazy"
      src="https://maps.google.com/maps?q=الرياض&amp;t=m&amp;z=12&amp;output=embed&amp;iwloc=near"
      title="مركز صيانة المكيفات والغسالات - الرياض"
      aria-label="مركز صيانة المكيفات والغسالات - الرياض"
      style="width: 100%; height: 100%; border: 0; filter: grayscale(0.2) contrast(1.1);"
    ></iframe>
  </div>
</div>

<!-- Testimonial Section -->
<section class="py-5" style="background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);">
  <div class="container py-4">
    <div class="text-center mb-5">
      <div class="d-flex justify-content-center align-items-center mb-3">
        <span class="mx-2" style="color: #2c5fa5; font-size: 1.5rem;">✦</span>
        <h3 class="text-uppercase fw-semibold mb-0" style="color: #2c5fa5;">
          <i class="bi bi-chat-quote-fill me-2"></i>
          آراء العملاء
        </h3>
        <span class="mx-2" style="color: #2c5fa5; font-size: 1.5rem;">✦</span>
      </div>
      <h2 class="h1 mb-3 fw-bold" style="color: #333;">رأي عملائنا في خدمات الصيانة</h2>
      <p class="mt-2 w-75 mx-auto lead" style="color: #666;">
        "نفخر برضا عملائنا عن جودة خدمات <strong>صيانة المكيفات</strong> و<strong>تصليح الغسالات</strong> في الرياض. هنا بعض آرائهم الصادقة عن تجربتهم معنا."
      </p>
    </div>

    <div class="row g-4 justify-content-center">
      <!-- Testimonial 1 - صيانة مكيفات -->
      <div class="col-md-6 col-lg-4">
        <div class="card testimonial-card text-center h-100">
          <div class="card-img-top-wrapper">
            
            <img src="images/client1.webp" alt="أحمد السديس - صيانة مكيفات" class="rounded-circle mx-auto d-block testimonial-img">
          </div>
          <div class="card-body">
            <div class="mb-2" style="color: #ffc107;">
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
            </div>
            <h5 class="fw-bold mb-1" style="color: #333;">أحمد السديس</h5>
            <small class="d-block mb-3" style="color: #666;">حي العليا - الرياض</small>
            <blockquote class="mb-0">
              <p class="fs-6" style="color: #555;">
                "فني <strong>صيانة مكيفات سبليت</strong> محترف جداً. أصلح لي المكيف خلال ساعتين وبتكلفة معقولة. الخدمة كانت <strong>24 ساعة</strong> والضمان لمدة سنة."
              </p>
            </blockquote>
            <div class="mt-3 pt-3 border-top">
              <small class="text-muted">
                <i class="bi bi-clock me-1"></i>
                خدمة صيانة مكيفات سامسونج
              </small>
            </div>
          </div>
        </div>
      </div>

      <!-- Testimonial 2 - تصليح غسالات -->
      <div class="col-md-6 col-lg-4">
        <div class="card testimonial-card text-center h-100">
          <div class="card-img-top-wrapper">
           
            <img src="images/client2.jpeg" alt="نورة القحطاني - تصليح غسالات" class="rounded-circle mx-auto d-block testimonial-img">
          </div>
          <div class="card-body">
            <div class="mb-2" style="color: #ffc107;">
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
            </div>
            <h5 class="fw-bold mb-1" style="color: #333;">نورة القحطاني</h5>
            <small class="d-block mb-3" style="color: #666;">حي النرجس - الرياض</small>
            <blockquote class="mb-0">
              <p class="fs-6" style="color: #555;">
                "<strong>إصلاح غسالة سامسونج</strong> الأتوماتيك كان سريعاً ومتقناً. الفني أصلح <strong>حوض الغسالة</strong> والمحرك باحترافية. أنصح بهم لكل من يحتاج <strong>تصليح غسالات</strong>."
              </p>
            </blockquote>
            <div class="mt-3 pt-3 border-top">
              <small class="text-muted">
                <i class="bi bi-wrench me-1"></i>
                إصلاح غسالة أتوماتيك
              </small>
            </div>
          </div>
        </div>
      </div>

      <!-- Testimonial 3 - خدمة متكاملة -->
      <div class="col-md-6 col-lg-4">
        <div class="card testimonial-card text-center h-100">
          <div class="card-img-top-wrapper">
           
            <img src="images/client3.jpeg" alt="خالد الحربي - صيانة متكاملة" class="rounded-circle mx-auto d-block testimonial-img">
          </div>
          <div class="card-body">
            <div class="mb-2" style="color: #ffc107;">
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
            </div>
            <h5 class="fw-bold mb-1" style="color: #333;">خالد الحربي</h5>
            <small class="d-block mb-3" style="color: #666;">حي الروابي - الرياض</small>
            <blockquote class="mb-0">
              <p class="fs-6" style="color: #555;">
                "استفدت من خدمة <strong>صيانة مكيفات شمال الرياض</strong> و<strong>تصليح الغسالة</strong> معاً. فريق محترف وسريع الاستجابة. <strong>فني المكيفات</strong> كان خبيراً في <strong>صيانة المكيفات المركزي</strong>."
              </p>
            </blockquote>
            <div class="mt-3 pt-3 border-top">
              <small class="text-muted">
                <i class="bi bi-star me-1"></i>
                خدمة صيانة متكاملة
              </small>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Additional Mini Testimonials -->
   

    <!-- Call to Action -->
   
  </div>
</section>

<style>
  .testimonial-card {
    border: none;
    border-radius: 15px;
    overflow: hidden;
    background: white;
    box-shadow: 0 8px 25px rgba(44, 95, 165, 0.1);
    transition: all 0.3s ease;
    padding-top: 50px;
    border: 1px solid #e9ecef;
    position: relative;
  }

  .testimonial-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 20px 40px rgba(44, 95, 165, 0.15);
  }

  .card-img-top-wrapper {
    position: relative;
  }

  .service-badge {
    position: absolute;
    top: -15px;
    left: 50%;
    transform: translateX(-50%);
    width: 50px;
    height: 50px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.2rem;
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    z-index: 2;
  }

  .testimonial-img {
    width: 90px;
    height: 90px;
    border-radius: 50%;
    object-fit: cover;
    border: 4px solid white;
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    margin-top: -45px;
    position: relative;
    z-index: 1;
  }

  .testimonial-card blockquote p {
    font-style: italic;
    color: #555;
    position: relative;
    padding: 15px 0;
    line-height: 1.6;
  }

  .testimonial-card blockquote p::before {
    content: "“";
    font-size: 3rem;
    color: #2c5fa5;
    position: absolute;
    top: -10px;
    right: -5px;
    opacity: 0.2;
    line-height: 1;
  }

  .mini-testimonial {
    background: white;
    border: 1px solid #e9ecef;
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    transition: all 0.3s ease;
  }

  .mini-testimonial:hover {
    transform: translateY(-3px);
    box-shadow: 0 5px 15px rgba(44, 95, 165, 0.1);
  }

  @media (max-width: 768px) {
    .testimonial-img {
      width: 70px;
      height: 70px;
      margin-top: -35px;
    }
    
    .service-badge {
      width: 40px;
      height: 40px;
      font-size: 1rem;
    }
  }

  @media (max-width: 576px) {
    .testimonial-card {
      margin-bottom: 2rem;
    }
  }
</style>

<?php echo $__env->make('workingSection', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php echo $__env->make('footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

 
    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- WOW.js for animations -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/wow/1.1.2/wow.min.js"></script>
<script>
        new WOW().init();
    </script>
<script>
  document.addEventListener('DOMContentLoaded', function() {
    const container = document.querySelector('.ba-container');
    const before = container.querySelector('.ba-before');
    const handle = container.querySelector('.ba-handle');

    const onMove = e => {
      const rect = container.getBoundingClientRect();
      const x = (e.touches ? e.touches[0].clientX : e.clientX) - rect.left;
      const pct = Math.max(0, Math.min(x, rect.width));
      before.style.width = pct + 'px';
      handle.style.left = pct + 'px';
    };
    handle.addEventListener('mousedown', () => {
      document.addEventListener('mousemove', onMove);
    });
    document.addEventListener('mouseup', () => {
      document.removeEventListener('mousemove', onMove);
    });
    // Touch events
    handle.addEventListener('touchstart', () => {
      document.addEventListener('touchmove', onMove);
    });
    document.addEventListener('touchend', () => {
      document.removeEventListener('touchmove', onMove);
    });
  });
</script>


    <script>
        // Initialize WOW.js
        new WOW().init();
        
        // Auto-rotate carousel every 5 seconds
        document.addEventListener('DOMContentLoaded', function() {
            var myCarousel = document.getElementById('heroCarousel');
            var carousel = new bootstrap.Carousel(myCarousel, {
                interval: 5000,
                ride: 'carousel'
            });
        });
    </script>
    <!-- Add this JavaScript -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const dropdownElement = document.getElementById('servicesDropdown');
    const dropdownLink = document.getElementById('servicesDropdownLink');
    
    // Hover functionality
    dropdownElement.addEventListener('mouseenter', function() {
        const dropdown = new bootstrap.Dropdown(dropdownLink);
        dropdown.show();
    });
    
    dropdownElement.addEventListener('mouseleave', function() {
        const dropdown = bootstrap.Dropdown.getInstance(dropdownLink);
        dropdown.hide();
    });
    
    // Click functionality - navigate to services page
    dropdownLink.addEventListener('click', function(e) {
        // Only navigate if clicking directly on the main link (not when dropdown is open)
        if (!dropdownElement.classList.contains('show')) {
            window.location.href = this.href;
        }
    });
});
</script>

</body>
</html><?php /**PATH E:\project\3thMonths\falseceilingandgypsumwork.shop\resources\views/index.blade.php ENDPATH**/ ?>