<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

 <title>أعمال الجبس بورد والأسقف المعلقة في الرياض | تركيب بجودة عالية وتصاميم متميزة</title>

<!-- SEO Meta Tags -->
<meta name="description" content="متخصصون في أعمال الجبس بورد والأسقف المعلقة بالرياض. تركيب دقيق لتقسيمات الجبس، الأسقف المستعارة، تصاميم الحوائط والديكورات الداخلية. أسعار تنافسية وتقديم مجاني للعروض.">
<meta name="keywords" content="جبس بورد الرياض, أسقف معلقة, تركيب جبس, تصميم أسقف مستعارة, تقسيمات جبسية, ديكور داخلي, مقاولون جبس, خدمات جبس في السعودية">
<meta name="author" content="أعمال الجبس بورد والأسقف المعلقة">

<!-- Canonical URL -->
<link rel="canonical" href="https://www.gypsumboardandceilingworks.shop/">

<!-- Open Graph Meta Tags (Facebook, etc.) -->
<meta property="og:title" content="أعمال الجبس بورد والأسقف المعلقة في الرياض | خدمات تركيب متميزة">
<meta property="og:description" content="رواد أعمال الجبس بورد في الرياض للأسقف والتقسيمات والديكورات الداخلية. جودة في التنفيذ وضمان رضا العملاء.">
<meta property="og:image" content="https://www.gypsumboardandceilingworks.shop/images/og-image.jpg">
<meta property="og:url" content="https://www.gypsumboardandceilingworks.shop/">
<meta property="og:type" content="website">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="خدمات الجبس المحترفة في الرياض | أسقف وتقسيمات">
<meta name="twitter:description" content="تركيب محترف للجبس بورد وتصاميم أسقف متميزة للمنازل والشركات في الرياض. اطلب عرض سعر مجاني اليوم.">
<meta name="twitter:image" content="https://www.gypsumboardandceilingworks.shop/images/og-image.jpg">

<!-- Favicons -->
<link rel="icon" href="images/cropped-WhatsApp-Image-2025-05-16-at-5.44.02-PM-32x32.jpeg" type="image/png" sizes="32x32">
<link rel="icon" type="image/png" sizes="16x16" href="images/favicon-16x16.png">
<link rel="icon" type="image/png" sizes="32x32" href="images/favicon-32x32.png">
<link rel="apple-touch-icon" sizes="180x180" href="images/apple-touch-icon.png">

  <!-- Stylesheets -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>

  <!-- Robots -->
  <meta name="robots" content="index, follow">

   <meta name="google-site-verification" content="your-verification-code"> 
  <style>
    html, body {
        max-width: 100%;
        overflow-x: hidden;
        background-color: var(--bg-color);
        color: var(--text-color);
        font-family: 'Tajawal', sans-serif;
        direction: ltr;
    }

    /* Top Contact Bar */
    .navbar-top {
        background-color: var(--primary-color);
        color: #fff;
        font-size: 0.9rem;
        padding: 0.4rem 20px;
    }

    .navbar-top .contact-center {
        flex: 1;
        display: flex;
        justify-content: center;
        gap: 2rem;
    }

    .navbar-top a {
        color: #fff;
        text-decoration: none;
        margin-left: 1rem;
    }

    /* Main Navbar */
    .navbar-main {
        background-color: var(--bg-color);
        padding: 1.5rem 30px;
        box-shadow: inset 0 -2px 0 var(--primary-color);
        position: relative;
        z-index: 10;
    }

    .navbar-main .nav-link {
        color: var(--text-color);
        font-weight: 500;
        margin: 0 0.5rem;
        padding-bottom: 4px;
    }

    .navbar-main .nav-link:hover,
    .navbar-main .nav-link:focus {
        color: var(--secondary-color);
    }

    /* Book Now Button */
    .book-btn {
        background-color: var(--accent-color);
        color: #fff;
        font-weight: 600;
        padding: 0.5rem 1.25rem;
        border-radius: 0.25rem;
    }

    .book-btn:hover {
        background-color: var(--accent-color);
        color: #fff;
    }

    /* Hero Slider Styles */
    .hero-slider {
        position: relative;
        width: 100%;
        height: 80vh;
        overflow: hidden;
    }

    .slider-container {
        height: 100%;
        position: relative;
    }

    .slide {
        position: absolute;
        width: 100%;
        height: 100%;
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        opacity: 0;
        transition: opacity 1s ease-in-out;
        display: flex;
        align-items: center;
        padding: 0 5%;
    }

    .slide.active {
        opacity: 1;
        z-index: 1;
    }

    .slide-content {
        max-width: 600px;
        color: white;
        position: relative;
        z-index: 2;
        padding: 40px;
        background-color: rgba(90, 78, 60, 0.8); /* Primary color with opacity */
        border-radius: 10px;
        animation: fadeInUp 1s ease-out;
    }

    .slide .title {
        font-size: 2.2rem;
        font-weight: 700;
        margin-bottom: 20px;
        color: #fff;
    }

    .slide .sub-title {
        font-size: 1.2rem;
        color: var(--secondary-color);
        margin-bottom: 15px;
        font-weight: 600;
    }

    .slide .desc {
        margin-bottom: 30px;
        line-height: 1.6;
    }

    /* Slider Controls */
    .slider-controls {
        position: absolute;
        bottom: 30px;
        left: 50%;
        transform: translateX(-50%);
        z-index: 10;
        display: flex;
        gap: 8px;
        padding: 5px;
        background-color: rgba(90, 78, 60, 0.5); /* Primary color with opacity */
        border-radius: 20px;
    }

    .slider-dot {
        width: 10px;
        height: 10px;
        border-radius: 50%;
        background-color: rgba(255, 255, 255, 0.5);
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .slider-dot.active {
        background-color: var(--secondary-color);
        transform: scale(1.3);
    }

    /* Slider Button */
    .btn-slider {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        padding: 12px 30px;
        background-color:white;
        color:black;
        border: none;
        border-radius: 50px;
        font-weight: 600;
        font-size: 1.1rem;
        text-decoration: none;
        transition: all 0.3s ease;
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        min-width: 160px;
    }

    

    /* Responsive adjustments */
    @media (max-width: 768px) {
        .hero-slider {
            height: 70vh;
        }
        
        .slide-content {
            padding: 20px;
            width: 90%;
            margin: 0 auto;
            text-align: center;
        }
        
        .slide .title {
            font-size: 1.8rem;
        }
        
        .btn-slider {
            padding: 10px 25px;
            font-size: 0.9rem;
        }
        
        .slider-controls {
            bottom: 20px;
        }
    }
    
    @media (max-width: 480px) {
        .hero-slider {
            height: 60vh;
        }
        
        .slide .title {
            font-size: 1.5rem;
        }
    }

    @keyframes fadeInUp {
        from {
            transform: translateY(50px);
            opacity: 0;
        }
        to {
            transform: translateY(0);
            opacity: 1;
        }
    }
</style>
<?php echo $__env->make('nav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<section class="hero-slider">
    <div class="slider-container">
        <!-- Slide 1 - أعمال جبس بورد -->
        <div class="slide active" style="background-image: url('images/WhatsApp Image 2025-07-29 at 12.08.15_1716916e.jpg');">
            <div class="slide-content right">
                <div class="sub-title">أعمال الجبس بورد</div>
                <h1 class="title">تركيب ألواح جبس بورد بالرياض</h1>
                <div class="desc text-white">
                    <p>نقدم خدمات تركيب ألواح الجبس بورد بجميع المقاسات والتصاميم العصرية</p>
                    <p>أسعار تنافسية - جودة عالية - تنفيذ سريع</p>
                </div>
                <a href="tel:+966550220842" class="btn btn-slider">اتصل الآن</a>
            </div>
        </div>
        
        <!-- Slide 2 - ديكورات جبس -->
        <div class="slide" style="background-image: url('images/WhatsApp Image 2025-07-29 at 12.08.17_35874941.jpg');">
            <div class="slide-content left">
                <div class="sub-title">ديكورات جبس</div>
                <h1 class="title">أعمال الديكور والجبس للأسقف والجدران</h1>
                <div class="desc text-white">
                    <p>أحدث أشكال الديكورات الداخلية باستخدام ألواح جبس بورد سعودي ضد الرطوبة والحريق</p>
                    <p>ابتكار في التصاميم - تنفيذ احترافي - أسعار مناسبة</p>
                </div>
                <a href="https://api.whatsapp.com/send?phone=+966550220842" class="btn btn-slider">واتساب الآن</a>
            </div>
        </div>
        
        <!-- Slide 3 - أسعار ألواح الجبس -->
        <div class="slide" style="background-image: url('images/WhatsApp Image 2025-07-29 at 12.08.17_78b25a97.jpg');">
            <div class="slide-content center">
                <div class="sub-title">أسعار الجبس بورد</div>
                <h1 class="title">أفضل أسعار ألواح الجبس بورد في الرياض</h1>
                <div class="desc text-white">
                    <p>نوفر لك جميع أنواع وأشكال ألواح الجبس بورد بأسعار مميزة وخامات عالية الجودة</p>
                    <p>أماكن بيع معروفة - مقاسات متعددة - أسعار تبدأ من 10 ريال للوح</p>
                </div>
                <a href="tel:+966550220842" class="btn btn-slider">استفسر الآن</a>
            </div>
        </div>
        
        <!-- Slider Controls -->
        <div class="slider-controls">
            <div class="slider-dot active" data-slide="0"></div>
            <div class="slider-dot" data-slide="1"></div>
            <div class="slider-dot" data-slide="2"></div>
        </div>
    </div>
</section>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const slides = document.querySelectorAll('.slide');
        const dots = document.querySelectorAll('.slider-dot');
        let currentSlide = 0;
        let slideInterval;
        
        function initSlider() {
            if (slides.length === 0) return;
            slideInterval = setInterval(nextSlide, 5000);
        }
        
        function goToSlide(n) {
            slides[currentSlide].classList.remove('active');
            dots[currentSlide].classList.remove('active');
            currentSlide = (n + slides.length) % slides.length;
            slides[currentSlide].classList.add('active');
            dots[currentSlide].classList.add('active');
            clearInterval(slideInterval);
            slideInterval = setInterval(nextSlide, 5000);
        }
        
        function nextSlide() {
            goToSlide(currentSlide + 1);
        }
        
        dots.forEach((dot, index) => {
            dot.addEventListener('click', () => goToSlide(index));
        });
        
        initSlider();
    });
</script>

<?php echo $__env->make('aboutSection', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <!-- 3thsection -->
  <?php echo $__env->make('servicesSection', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<!-- 4th -->

   <?php echo $__env->make('newSection', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
 <!-- 6th section -->



<!-- 7th section -->

<?php echo $__env->make('newSection2', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<!-- Google Map -->
<div class="container-fluid p-0 my-5">
  <div style="height: 200px;">
    <iframe
      loading="lazy"
      src="https://maps.google.com/maps?q=الرياض&amp;t=m&amp;z=15&amp;output=embed&amp;iwloc=near"
      title="مؤسسة أعمال الجبس بورد والديكور الداخلي - الرياض"
      aria-label="مؤسسة أعمال الجبس بورد والديكور الداخلي - الرياض"
      style="width: 100%; height: 100%; border: 0;"
    ></iframe>
  </div>
</div>

<!-- Testimonial Section -->
<section class="py-5" style="background-color: var(--highlight-color);">
  <div class="container py-4">
    <div class="text-center mb-5">
      <h3 class="text-uppercase fw-semibold mb-2" style="color: var(--secondary-color);">
        <svg width="16" height="16" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" class="me-2">
          <path d="M11.9367 5.9528C12.1626 6.01733 12.3783 6.07787 12.7693 6.07787C13.5946 6.07787 14.4218 5.73787 15.0389 5.1208C15.8285 4.33093 16.1661 3.19973 15.9199 2.16827C15.9089 2.12215 15.8858 2.07981 15.8529 2.04563C15.82 2.01146 15.7786 1.98668 15.733 1.97387C15.6874 1.96077 15.6391 1.96016 15.5931 1.97213C15.5472 1.98409 15.5053 2.00818 15.4719 2.04187L14.8413 2.67253C14.6394 2.87413 14.3706 2.98533 14.0839 2.98533C13.7973 2.98533 13.5285 2.8744 13.3269 2.67253C13.1262 2.47155 13.0136 2.19918 13.0136 1.9152C13.0136 1.63122 13.1262 1.35885 13.3269 1.15787L13.9573 0.527466C13.9909 0.493964 14.015 0.452081 14.027 0.406152C14.039 0.360223 14.0385 0.311916 14.0256 0.266232C14.0127 0.220547 13.9878 0.179144 13.9535 0.146308C13.9192 0.113471 13.8768 0.0903949 13.8306 0.0794661C12.7991 -0.166934 11.6682 0.170933 10.8783 0.960533C10.1042 1.7344 9.71058 2.888 10.0463 4.06267L7.99858 6.11013L5.95218 4.06373C6.28712 2.89093 5.89565 1.73573 5.12018 0.960533C4.33058 0.170666 3.19938 -0.167467 2.16818 0.0794661C2.12214 0.0906185 2.07989 0.113812 2.04576 0.146671C2.01163 0.179529 1.98685 0.220871 1.97396 0.266459C1.96107 0.312048 1.96054 0.360243 1.97241 0.406108C1.98428 0.451972 2.00813 0.493855 2.04152 0.527466L2.67192 1.15787C2.87254 1.35885 2.98522 1.63122 2.98522 1.9152C2.98522 2.19918 2.87254 2.47155 2.67192 2.67253C2.47032 2.8744 2.20152 2.98533 1.91485 2.98533C1.62818 2.98533 1.35938 2.87413 1.15752 2.67253L0.527118 2.0416C0.493597 2.00804 0.451734 1.98404 0.405844 1.97205C0.359953 1.96007 0.311697 1.96054 0.26605 1.97342C0.220403 1.9863 0.179016 2.01112 0.146158 2.04532C0.113299 2.07952 0.0901572 2.12187 0.079118 2.168C-0.167015 3.19947 0.170585 4.33067 0.960185 5.12053C1.57778 5.73787 2.40552 6.07813 3.22952 6.07813C3.61965 6.07813 3.85512 6.012 4.06312 5.95227L6.10978 7.99867L4.06232 10.0461C2.89138 9.71227 1.73725 10.1013 0.960185 10.8781C0.170585 11.668 -0.167015 12.7992 0.079118 13.8307C0.0901342 13.8768 0.113271 13.9191 0.146136 13.9533C0.179001 13.9875 0.2204 14.0123 0.266051 14.0251C0.358851 14.0509 0.458851 14.0251 0.527118 13.9571L1.15778 13.3264C1.35886 13.1261 1.63114 13.0136 1.91498 13.0136C2.19883 13.0136 2.47111 13.1261 2.67218 13.3264C2.87405 13.5283 2.98498 13.7973 2.98498 14.0837C2.98498 14.3701 2.87378 14.6392 2.67218 14.8411L2.04178 15.4715C2.00815 15.505 1.98407 15.5469 1.97205 15.5928C1.96004 15.6387 1.96051 15.687 1.97343 15.7327C1.98634 15.7784 2.01123 15.8198 2.04552 15.8526C2.07981 15.8855 2.12225 15.9085 2.16845 15.9195C2.39138 15.9728 2.61912 15.9987 2.84685 15.9987C3.67272 15.9987 4.50178 15.6576 5.12072 15.0384C5.89485 14.2645 6.28845 13.1109 5.95272 11.9363L8.00045 9.8888L10.0469 11.9352C9.71192 13.108 10.1034 14.2632 10.8789 15.0384C11.4981 15.6573 12.3269 15.9987 13.1527 15.9987C13.3805 15.9987 13.6082 15.9728 13.8311 15.9195C13.8772 15.9083 13.9194 15.8851 13.9535 15.8523C13.9877 15.8194 14.0124 15.7781 14.0253 15.7325C14.0382 15.6869 14.0388 15.6387 14.0269 15.5928C14.015 15.547 13.9912 15.5051 13.9578 15.4715L13.3274 14.8411C13.1255 14.6392 13.0146 14.3701 13.0146 14.0837C13.0146 13.7973 13.1258 13.5283 13.3274 13.3264C13.5285 13.1261 13.8007 13.0136 14.0846 13.0136C14.3684 13.0136 14.6407 13.1261 14.8418 13.3264L15.4725 13.9571C15.506 13.9905 15.5479 14.0143 15.5938 14.0262C15.6396 14.0381 15.6878 14.0376 15.7334 14.0247C15.779 14.0119 15.8203 13.9871 15.8532 13.953C15.886 13.9189 15.9093 13.8767 15.9205 13.8307C16.1666 12.7992 15.829 11.668 15.0394 10.8781Z" fill="currentColor"/>
        </svg>
        آراء العملاء
      </h3>
      <h2 class="h1 mb-3" style="color: var(--primary-color);">رأي عملائنا في خدمات الجبس بورد</h2>
      <p class="mt-2 w-75 mx-auto" style="color: var(--text-color);">
        "نفخر برضا عملائنا عن جودة أعمالنا في تركيب ألواح الجبس بورد والأسقف المعلقة بالرياض. هنا بعض آرائهم الصادقة عن تجربتهم معنا."
      </p>
    </div>

    <div class="row g-4 justify-content-center">
      <!-- Testimonial 1 -->
      <div class="col-md-6 col-lg-4">
        <div class="card testimonial-card text-center h-100">
          <div class="card-img-top-wrapper">
            <img src="images/client1.webp" alt="عبدالله صالح" class="rounded-circle mx-auto d-block testimonial-img">
          </div>
          <div class="card-body">
            <div class="mb-2" style="color: var(--secondary-color);">
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
            </div>
            <h5 class="fw-bold mb-1" style="color: var(--primary-color);">عبدالله صالح</h5>
            <small class="d-block mb-3" style="color: var(--text-muted);">حي العليا - الرياض</small>
            <blockquote class="mb-0">
              <p class="fs-6" style="color: var(--text-color);">"فريق محترف في تركيب الجبس بورد. نفذوا لي أسقف معلقة بدقة وجودة عالية، والتزامهم بالمواعيد ممتاز. أنصح الجميع بهم."</p>
            </blockquote>
          </div>
        </div>
      </div>

      <!-- Testimonial 2 -->
      <div class="col-md-6 col-lg-4">
        <div class="card testimonial-card text-center h-100">
          <div class="card-img-top-wrapper">
            <img src="images/client2.jpeg" alt="فاطمة الدوسري" class="rounded-circle mx-auto d-block testimonial-img">
          </div>
          <div class="card-body">
            <div class="mb-2" style="color: var(--secondary-color);">
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
            </div>
            <h5 class="fw-bold mb-1" style="color: var(--primary-color);">فاطمة الدوسري</h5>
            <small class="d-block mb-3" style="color: var(--text-muted);">حي النرجس - الرياض</small>
            <blockquote class="mb-0">
              <p class="fs-6" style="color: var(--text-color);">"أعمال ديكور الجبس في منزلي كانت رائعة! التصميم العصري والتنفيذ الدقيق جعلوا النتيجة أفضل مما توقعت."</p>
            </blockquote>
          </div>
        </div>
      </div>

      <!-- Testimonial 3 -->
      <div class="col-md-6 col-lg-4">
        <div class="card testimonial-card text-center h-100">
          <div class="card-img-top-wrapper">
            <img src="images/client3.jpeg" alt="محمد المطيري" class="rounded-circle mx-auto d-block testimonial-img">
          </div>
          <div class="card-body">
            <div class="mb-2" style="color: var(--secondary-color);">
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
            </div>
            <h5 class="fw-bold mb-1" style="color: var(--primary-color);">محمد المطيري</h5>
            <small class="d-block mb-3" style="color: var(--text-muted);">حي الروابي - الرياض</small>
            <blockquote class="mb-0">
              <p class="fs-6" style="color: var(--text-color);">"أسعارهم مناسبة وجودة العمل ممتازة. نفذوا لي مشروع جبس بورد كامل في الفيلا باحترافية شديدة. شكراً لكم!"</p>
            </blockquote>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<style>
  .testimonial-card {
    border: none;
    border-radius: 12px;
    overflow: hidden;
    background: white;
    box-shadow: 0 5px 15px rgba(0,0,0,0.05);
    transition: transform 0.3s, box-shadow 0.3s;
    padding-top: 40px;
    border: 1px solid var(--border-color);
  }

  .testimonial-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 15px 25px rgba(90, 78, 60, 0.1);
  }

  .testimonial-img {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    object-fit: cover;
    border: 3px solid var(--secondary-color);
    margin-top: -40px;
  }

  .testimonial-card blockquote p {
    font-style: italic;
    color: var(--text-color);
    position: relative;
    padding: 10px 20px;
  }

  .testimonial-card blockquote p::before {
    content: "“";
    font-size: 3rem;
    color: var(--secondary-color);
    position: absolute;
    top: -20px;
    right: 10px;
    opacity: 0.15;
    line-height: 1;
  }

  @media (max-width: 576px) {
    .testimonial-img {
      width: 60px;
      height: 60px;
      margin-top: -30px;
    }
  }
</style>

<section class="py-5" style="background-color: var(--highlight-color);">
  <div class="container">
    <div class="text-center mb-5">
      <div class="d-flex justify-content-center align-items-center mb-3">
        <svg width="16" height="16" viewBox="0 0 16 16" fill="var(--secondary-color)" xmlns="http://www.w3.org/2000/svg" class="me-2">
          <path d="M11.9367 5.9528C12.1626 6.01733 12.3783 6.07787 12.7693 6.07787C13.5946 6.07787 14.4218 5.73787 15.0389 5.1208C15.8285 4.33093 16.1661 3.19973 15.9199 2.16827C15.9089 2.12215 15.8858 2.07981 15.8529 2.04563C15.82 2.01146 15.7786 1.98668 15.733 1.97387C15.6874 1.96077 15.6391 1.96016 15.5931 1.97213C15.5472 1.98409 15.5053 2.00818 15.4719 2.04187L14.8413 2.67253C14.6394 2.87413 14.3706 2.98533 14.0839 2.98533C13.7973 2.98533 13.5285 2.8744 13.3269 2.67253C13.1262 2.47155 13.0136 2.19918 13.0136 1.9152C13.0136 1.63122 13.1262 1.35885 13.3269 1.15787L13.9573 0.527466C13.9909 0.493964 14.015 0.452081 14.027 0.406152C14.039 0.360223 14.0385 0.311916 14.0256 0.266232C14.0127 0.220547 13.9878 0.179144 13.9535 0.146308C13.9192 0.113471 13.8768 0.0903949 13.8306 0.0794661C12.7991 -0.166934 11.6682 0.170933 10.8783 0.960533C10.1042 1.7344 9.71058 2.888 10.0463 4.06267L7.99858 6.11013L5.95218 4.06373C6.28712 2.89093 5.89565 1.73573 5.12018 0.960533C4.33058 0.170666 3.19938 -0.167467 2.16818 0.0794661C2.12214 0.0906185 2.07989 0.113812 2.04576 0.146671C2.01163 0.179529 1.98685 0.220871 1.97396 0.266459C1.96107 0.312048 1.96054 0.360243 1.97241 0.406108C1.98428 0.451972 2.00813 0.493855 2.04152 0.527466L2.67192 1.15787C2.87254 1.35885 2.98522 1.63122 2.98522 1.9152C2.98522 2.19918 2.87254 2.47155 2.67192 2.67253C2.47032 2.8744 2.20152 2.98533 1.91485 2.98533C1.62818 2.98533 1.35938 2.87413 1.15752 2.67253L0.527118 2.0416C0.493597 2.00804 0.451734 1.98404 0.405844 1.97205C0.359953 1.96007 0.311697 1.96054 0.26605 1.97342C0.220403 1.9863 0.179016 2.01112 0.146158 2.04532C0.113299 2.07952 0.0901572 2.12187 0.079118 2.168C-0.167015 3.19947 0.170585 4.33067 0.960185 5.12053C1.57778 5.73787 2.40552 6.07813 3.22952 6.07813C3.61965 6.07813 3.85512 6.012 4.06312 5.95227L6.10978 7.99867L4.06232 10.0461C2.89138 9.71227 1.73725 10.1013 0.960185 10.8781C0.170585 11.668 -0.167015 12.7992 0.079118 13.8307C0.0901342 13.8768 0.113271 13.9191 0.146136 13.9533C0.179001 13.9875 0.2204 14.0123 0.266051 14.0251C0.358851 14.0509 0.458851 14.0251 0.527118 13.9571L1.15778 13.3264C1.35886 13.1261 1.63114 13.0136 1.91498 13.0136C2.19883 13.0136 2.47111 13.1261 2.67218 13.3264C2.87405 13.5283 2.98498 13.7973 2.98498 14.0837C2.98498 14.3701 2.87378 14.6392 2.67218 14.8411L2.04178 15.4715C2.00815 15.505 1.98407 15.5469 1.97205 15.5928C1.96004 15.6387 1.96051 15.687 1.97343 15.7327C1.98634 15.7784 2.01123 15.8198 2.04552 15.8526C2.07981 15.8855 2.12225 15.9085 2.16845 15.9195C2.39138 15.9728 2.61912 15.9987 2.84685 15.9987C3.67272 15.9987 4.50178 15.6576 5.12072 15.0384C5.89485 14.2645 6.28845 13.1109 5.95272 11.9363L8.00045 9.8888L10.0469 11.9352C9.71192 13.108 10.1034 14.2632 10.8789 15.0384C11.4981 15.6573 12.3269 15.9987 13.1527 15.9987C13.3805 15.9987 13.6082 15.9728 13.8311 15.9195C13.8772 15.9083 13.9194 15.8851 13.9535 15.8523C13.9877 15.8194 14.0124 15.7781 14.0253 15.7325C14.0382 15.6869 14.0388 15.6387 14.0269 15.5928C14.015 15.547 13.9912 15.5051 13.9578 15.4715L13.3274 14.8411C13.1255 14.6392 13.0146 14.3701 13.0146 14.0837C13.0146 13.7973 13.1258 13.5283 13.3274 13.3264C13.5285 13.1261 13.8007 13.0136 14.0846 13.0136C14.3684 13.0136 14.6407 13.1261 14.8418 13.3264L15.4725 13.9571C15.506 13.9905 15.5479 14.0143 15.5938 14.0262C15.6396 14.0381 15.6878 14.0376 15.7334 14.0247C15.779 14.0119 15.8203 13.9871 15.8532 13.953C15.886 13.9189 15.9093 13.8767 15.9205 13.8307C16.1666 12.7992 15.829 11.668 15.0394 10.8781Z"/>
        </svg>
        <h6 class="text-uppercase mb-0" style="color: var(--secondary-color);">مميزاتنا</h6>
        <svg width="16" height="16" viewBox="0 0 16 16" fill="var(--secondary-color)" xmlns="http://www.w3.org/2000/svg" class="ms-2">
          <path d="M11.9367 5.9528C12.1626 6.01733 12.3783 6.07787 12.7693 6.07787C13.5946 6.07787 14.4218 5.73787 15.0389 5.1208C15.8285 4.33093 16.1661 3.19973 15.9199 2.16827C15.9089 2.12215 15.8858 2.07981 15.8529 2.04563C15.82 2.01146 15.7786 1.98668 15.733 1.97387C15.6874 1.96077 15.6391 1.96016 15.5931 1.97213C15.5472 1.98409 15.5053 2.00818 15.4719 2.04187L14.8413 2.67253C14.6394 2.87413 14.3706 2.98533 14.0839 2.98533C13.7973 2.98533 13.5285 2.8744 13.3269 2.67253C13.1262 2.47155 13.0136 2.19918 13.0136 1.9152C13.0136 1.63122 13.1262 1.35885 13.3269 1.15787L13.9573 0.527466C13.9909 0.493964 14.015 0.452081 14.027 0.406152C14.039 0.360223 14.0385 0.311916 14.0256 0.266232C14.0127 0.220547 13.9878 0.179144 13.9535 0.146308C13.9192 0.113471 13.8768 0.0903949 13.8306 0.0794661C12.7991 -0.166934 11.6682 0.170933 10.8783 0.960533C10.1042 1.7344 9.71058 2.888 10.0463 4.06267L7.99858 6.11013L5.95218 4.06373C6.28712 2.89093 5.89565 1.73573 5.12018 0.960533C4.33058 0.170666 3.19938 -0.167467 2.16818 0.0794661C2.12214 0.0906185 2.07989 0.113812 2.04576 0.146671C2.01163 0.179529 1.98685 0.220871 1.97396 0.266459C1.96107 0.312048 1.96054 0.360243 1.97241 0.406108C1.98428 0.451972 2.00813 0.493855 2.04152 0.527466L2.67192 1.15787C2.87254 1.35885 2.98522 1.63122 2.98522 1.9152C2.98522 2.19918 2.87254 2.47155 2.67192 2.67253C2.47032 2.8744 2.20152 2.98533 1.91485 2.98533C1.62818 2.98533 1.35938 2.87413 1.15752 2.67253L0.527118 2.0416C0.493597 2.00804 0.451734 1.98404 0.405844 1.97205C0.359953 1.96007 0.311697 1.96054 0.26605 1.97342C0.220403 1.9863 0.179016 2.01112 0.146158 2.04532C0.113299 2.07952 0.0901572 2.12187 0.079118 2.168C-0.167015 3.19947 0.170585 4.33067 0.960185 5.12053C1.57778 5.73787 2.40552 6.07813 3.22952 6.07813C3.61965 6.07813 3.85512 6.012 4.06312 5.95227L6.10978 7.99867L4.06232 10.0461C2.89138 9.71227 1.73725 10.1013 0.960185 10.8781C0.170585 11.668 -0.167015 12.7992 0.079118 13.8307C0.0901342 13.8768 0.113271 13.9191 0.146136 13.9533C0.179001 13.9875 0.2204 14.0123 0.266051 14.0251C0.358851 14.0509 0.458851 14.0251 0.527118 13.9571L1.15778 13.3264C1.35886 13.1261 1.63114 13.0136 1.91498 13.0136C2.19883 13.0136 2.47111 13.1261 2.67218 13.3264C2.87405 13.5283 2.98498 13.7973 2.98498 14.0837C2.98498 14.3701 2.87378 14.6392 2.67218 14.8411L2.04178 15.4715C2.00815 15.505 1.98407 15.5469 1.97205 15.5928C1.96004 15.6387 1.96051 15.687 1.97343 15.7327C1.98634 15.7784 2.01123 15.8198 2.04552 15.8526C2.07981 15.8855 2.12225 15.9085 2.16845 15.9195C2.39138 15.9728 2.61912 15.9987 2.84685 15.9987C3.67272 15.9987 4.50178 15.6576 5.12072 15.0384C5.89485 14.2645 6.28845 13.1109 5.95272 11.9363L8.00045 9.8888L10.0469 11.9352C9.71192 13.108 10.1034 14.2632 10.8789 15.0384C11.4981 15.6573 12.3269 15.9987 13.1527 15.9987C13.3805 15.9987 13.6082 15.9728 13.8311 15.9195C13.8772 15.9083 13.9194 15.8851 13.9535 15.8523C13.9877 15.8194 14.0124 15.7781 14.0253 15.7325C14.0382 15.6869 14.0388 15.6387 14.0269 15.5928C14.015 15.547 13.9912 15.5051 13.9578 15.4715L13.3274 14.8411C13.1255 14.6392 13.0146 14.3701 13.0146 14.0837C13.0146 13.7973 13.1258 13.5283 13.3274 13.3264C13.5285 13.1261 13.8007 13.0136 14.0846 13.0136C14.3684 13.0136 14.6407 13.1261 14.8418 13.3264L15.4725 13.9571C15.506 13.9905 15.5479 14.0143 15.5938 14.0262C15.6396 14.0381 15.6878 14.0376 15.7334 14.0247C15.779 14.0119 15.8203 13.9871 15.8532 13.953C15.886 13.9189 15.9093 13.8767 15.9205 13.8307C16.1666 12.7992 15.829 11.668 15.0394 10.8781Z"/>
        </svg>
      </div>
      <h2 class="mb-4" style="color: var(--primary-color);">خدمات الجبس بورد والأسقف المعلقة بالرياض</h2>
      <p class="w-75 mx-auto" style="color: var(--text-color);">نقدم حلولاً متكاملة لأعمال الجبس بورد والديكور الداخلي بجودة عالية وأسعار تنافسية في الرياض</p>
    </div>
    <div class="row g-4">
      
      <!-- Card 1 -->
      <div class="col-xl-3 col-md-6">
        <div class="gypsum-card">
          <div class="gypsum-card-body">
            <div class="gypsum-card-img mb-4">
              <img src="images/WhatsApp Image 2025-07-29 at 12.08.14_e8bc9db2.jpg" loading="lazy" alt="تركيب الجبس بورد" class="img-fluid">
            </div>
            <h5 class="mb-3" style="color: var(--primary-color);">تركيب محترف</h5>
            <p style="color: var(--text-color);">فريق متخصص في تركيب ألواح الجبس بورد باحترافية عالية، مع الالتزام بأعلى معايير الجودة والدقة في التنفيذ.</p>
            
          </div>
        </div>
      </div>

      <!-- Card 2 -->
      <div class="col-xl-3 col-md-6">
        <div class="gypsum-card">
          <div class="gypsum-card-body">
            <div class="gypsum-card-img mb-4">
              <img src="images/WhatsApp Image 2025-07-29 at 12.08.16_d756d5bc.jpg" loading="lazy" alt="تصاميم الأسقف" class="img-fluid">
            </div>
            <h5 class="mb-3" style="color: var(--primary-color);">تصاميم عصرية</h5>
            <p style="color: var(--text-color);">أحدث تصاميم الأسقف المعلقة والجدران الجبسية التي تضفي لمسة جمالية وأناقة على مساحتك الداخلية.</p>

          </div>
        </div>
      </div>

      <!-- Card 3 -->
      <div class="col-xl-3 col-md-6">
        <div class="gypsum-card">
          <div class="gypsum-card-body">
            <div class="gypsum-card-img mb-4">
              <img src="images/WhatsApp Image 2025-07-29 at 12.08.16_1ab2b6fa.jpg" loading="lazy" alt="مواد عالية الجودة" class="img-fluid">
            </div>
            <h5 class="mb-3" style="color: var(--primary-color);">مواد ممتازة</h5>
            <p style="color: var(--text-color);">نستخدم ألواح جبس بورد سعودي عالية الجودة، مقاومة للرطوبة والحريق، لضمان متانة وديمومة الأعمال.</p>

          </div>
        </div>
      </div>

      <!-- Card 4 -->
      <div class="col-xl-3 col-md-6">
        <div class="gypsum-card">
          <div class="gypsum-card-body">
            <div class="gypsum-card-img mb-4">
              <img src="images/WhatsApp Image 2025-07-29 at 12.08.14_22a1be8a.jpg" loading="lazy" alt="أسعار تنافسية" class="img-fluid">
            </div>
            <h5 class="mb-3" style="color: var(--primary-color);">أسعار مناسبة</h5>
            <p style="color: var(--text-color);">نقدم أفضل أسعار ألواح الجبس بورد في الرياض مع ضمان الجودة، بدءًا من 10 ريال للمتر.</p>
           
          </div>
        </div>
      </div>

    </div>
  </div>
</section>

<style>
  .gypsum-card {
    background-color: white;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 5px 15px rgba(0,0,0,0.05);
    transition: all 0.3s ease;
    height: 100%;
    border: 1px solid var(--border-color);
  }

  .gypsum-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 15px 30px rgba(90, 78, 60, 0.1);
  }

  .gypsum-card-body {
    padding: 25px;
    text-align: center;
    display: flex;
    flex-direction: column;
    height: 100%;
  }

  .gypsum-card-img img {
    max-width: 100px;
    height: auto;
    transition: all 0.3s ease;
    border-radius: 8px;
  }

  .gypsum-card:hover .gypsum-card-img img {
    transform: scale(1.1);
  }

  .gypsum-card h5 {
    font-weight: 700;
    font-size: 1.2rem;
    margin-bottom: 15px;
  }

  .gypsum-card p {
    font-size: 0.95rem;
    line-height: 1.6;
    margin-bottom: 20px;
    flex-grow: 1;
  }

  .gypsum-card .btn {
    border-radius: 6px;
    padding: 8px 20px;
    font-weight: 500;
    transition: all 0.3s ease;
    align-self: center;
  }

  .gypsum-card .btn:hover {
    background-color: var(--accent-color) !important;
    transform: translateY(-2px);
  }

  @media (max-width: 767px) {
    .gypsum-card {
      margin-bottom: 20px;
    }
  }
</style>

<?php echo $__env->make('footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

 
    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- WOW.js for animations -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/wow/1.1.2/wow.min.js"></script>
<script>
        new WOW().init();
    </script>
<script>
  document.addEventListener('DOMContentLoaded', function() {
    const container = document.querySelector('.ba-container');
    const before = container.querySelector('.ba-before');
    const handle = container.querySelector('.ba-handle');

    const onMove = e => {
      const rect = container.getBoundingClientRect();
      const x = (e.touches ? e.touches[0].clientX : e.clientX) - rect.left;
      const pct = Math.max(0, Math.min(x, rect.width));
      before.style.width = pct + 'px';
      handle.style.left = pct + 'px';
    };
    handle.addEventListener('mousedown', () => {
      document.addEventListener('mousemove', onMove);
    });
    document.addEventListener('mouseup', () => {
      document.removeEventListener('mousemove', onMove);
    });
    // Touch events
    handle.addEventListener('touchstart', () => {
      document.addEventListener('touchmove', onMove);
    });
    document.addEventListener('touchend', () => {
      document.removeEventListener('touchmove', onMove);
    });
  });
</script>


    <script>
        // Initialize WOW.js
        new WOW().init();
        
        // Auto-rotate carousel every 5 seconds
        document.addEventListener('DOMContentLoaded', function() {
            var myCarousel = document.getElementById('heroCarousel');
            var carousel = new bootstrap.Carousel(myCarousel, {
                interval: 5000,
                ride: 'carousel'
            });
        });
    </script>
    <!-- Add this JavaScript -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const dropdownElement = document.getElementById('servicesDropdown');
    const dropdownLink = document.getElementById('servicesDropdownLink');
    
    // Hover functionality
    dropdownElement.addEventListener('mouseenter', function() {
        const dropdown = new bootstrap.Dropdown(dropdownLink);
        dropdown.show();
    });
    
    dropdownElement.addEventListener('mouseleave', function() {
        const dropdown = bootstrap.Dropdown.getInstance(dropdownLink);
        dropdown.hide();
    });
    
    // Click functionality - navigate to services page
    dropdownLink.addEventListener('click', function(e) {
        // Only navigate if clicking directly on the main link (not when dropdown is open)
        if (!dropdownElement.classList.contains('show')) {
            window.location.href = this.href;
        }
    });
});
</script>

</body>
</html><?php /**PATH E:\project\3thMonths\Gypsum board\resources\views/index.blade.php ENDPATH**/ ?>