<style>
    /* Custom CSS with professional color scheme */
    :root {
        --primary-color: #2c5fa5;
        --secondary-color: #ffc107;
        --accent-color: #28a745;
        --text-color: #333;
        --text-muted: #666;
        --border-color: #e9ecef;
        --bg-color: #f8f9fa;
    }

    .cs_height_80, .cs_height_lg_80 { height: 80px; }
    .cs_height_60 { height: 60px; }
    
    .cs_section_subtitle {
        font-size: 18px;
        margin-bottom: 12px;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        text-transform: uppercase;
        color: var(--secondary-color);
    }
    
    .cs_section_title {
        font-size: 40px;
        margin-bottom: 0;
        font-weight: 700;
        color: var(--primary-color);
    }
    
    .cs_row_gap_60 { row-gap: 60px; }
    
    .cs_card {
        position: relative;
        height: 100%;
        transition: all 0.3s ease;
        background-color: white;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.08);
    }
    
    .cs_card_thumbnail {
        position: relative;
        display: block;
        overflow: hidden;
        border-radius: 15px 15px 0 0;
    }
    
    .cs_card_thumbnail img {
        width: 100%;
        height: auto;
        transition: transform 0.3s ease;
    }
    
    .cs_card:hover .cs_card_thumbnail img {
        transform: scale(1.05);
    }
    
    .cs_card_info {
        padding: 25px;
    }
    
    .cs_card_title {
        font-size: 20px;
        margin-bottom: 15px;
        font-weight: 600;
        color: var(--primary-color);
    }
    
    .cs_card_subtitle {
        color: var(--text-color);
        margin-bottom: 20px;
        line-height: 1.6;
    }

    /* Contact Section Styling */
    .contact-section {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        border-radius: 20px;
        margin-top: -120px;
        position: relative;
        z-index: 2;
    }

    .contact-info-card {
        background: white;
        border-radius: 15px;
        padding: 40px;
        box-shadow: 0 15px 40px rgba(44, 95, 165, 0.1);
        height: 100%;
        border: 1px solid var(--border-color);
    }

    .contact-icon {
        width: 50px;
        height: 50px;
        border-radius: 12px;
        background: linear-gradient(135deg, var(--primary-color), #1e4a8d);
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 1.2rem;
        margin-left: 15px;
    }

    .service-badge {
        background: var(--secondary-color);
        color: var(--primary-color);
        padding: 8px 16px;
        border-radius: 25px;
        font-size: 14px;
        font-weight: 600;
        display: inline-block;
        margin-bottom: 15px;
    }

    /* Form Styling */
    #cs_form {
        background: white;
        border-radius: 20px;
        padding: 40px;
        box-shadow: 0 20px 50px rgba(44, 95, 165, 0.15);
        border: 1px solid var(--border-color);
        height: 100%;
    }
    
    #cs_form .form-control {
        border: 2px solid #e9ecef;
        border-radius: 12px;
        padding: 15px 20px;
        font-size: 16px;
        transition: all 0.3s ease;
        height: 55px;
        background: #f8f9fa;
    }
    
    #cs_form .form-control:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(44, 95, 165, 0.1);
        background: white;
    }
    
    #cs_form textarea.form-control {
        height: auto;
        min-height: 140px;
        resize: vertical;
    }
    
    #cs_form select.form-control {
        appearance: none;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='%232c5fa5' d='M7.247 11.14L2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: left 15px center;
        background-size: 16px 12px;
        padding-left: 45px;
    }
    
    #cs_form label {
        display: block;
        margin-bottom: 10px;
        font-weight: 600;
        color: var(--primary-color);
        font-size: 15px;
    }
    
    #cs_form .form-group {
        margin-bottom: 25px;
    }
    
    #cs_form .btn-submit {
        background: linear-gradient(135deg, var(--primary-color), #1e4a8d);
        color: white;
        border: none;
        border-radius: 12px;
        padding: 16px 32px;
        font-weight: 700;
        font-size: 17px;
        transition: all 0.3s ease;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 100%;
        box-shadow: 0 8px 25px rgba(44, 95, 165, 0.3);
    }
    
    #cs_form .btn-submit:hover {
        transform: translateY(-3px);
        box-shadow: 0 12px 35px rgba(44, 95, 165, 0.4);
    }
    
    #cs_form .btn-submit i {
        margin-right: 10px;
        transition: transform 0.3s ease;
    }
    
    #cs_form .btn-submit:hover i {
        transform: translateX(5px);
    }
    
    /* Form Header */
    .form-header {
        text-align: center;
        margin-bottom: 35px;
    }
    
    .form-header h3 {
        color: var(--primary-color);
        font-weight: 800;
        margin-bottom: 12px;
        font-size: 28px;
    }
    
    .form-header p {
        color: var(--text-muted);
        font-size: 16px;
        line-height: 1.6;
    }

    /* Service Features */
    .service-features {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 15px;
        margin-top: 25px;
    }

    .feature-item {
        display: flex;
        align-items: center;
        gap: 10px;
        font-size: 14px;
        color: var(--text-color);
    }

    .feature-item i {
        color: var(--accent-color);
        font-size: 16px;
    }

    /* Responsive adjustments */
    @media (max-width: 991px) {
        .contact-section {
            margin-top: -80px;
        }
        
        .contact-info-card,
        #cs_form {
            padding: 30px;
        }
    }
    
    @media (max-width: 767px) {
        .contact-section {
            margin-top: -60px;
            border-radius: 15px;
        }
        
        .contact-info-card,
        #cs_form {
            padding: 25px;
            border-radius: 12px;
        }
        
        .service-features {
            grid-template-columns: 1fr;
        }
        
        .form-header h3 {
            font-size: 24px;
        }
    }

    @media (max-width: 575px) {
        .contact-info-card,
        #cs_form {
            padding: 20px;
        }
        
        #cs_form .form-control {
            padding: 12px 15px;
            height: 50px;
        }
    }
</style>

<section class="position-relative contact-section" style="direction: rtl;">
  <div class="container">
    <div class="row g-5 align-items-stretch">
      <!-- Contact Information -->
      <div class="col-lg-6">
        <div class="contact-info-card">
          <div class="service-badge">
            <i class="bi bi-star-fill me-2"></i>خدمة 24 ساعة
          </div>
          
          <h1 class="h2 mb-4 fw-bold" style="color: var(--primary-color);">
            مركز الصيانة المتكامل 
            <span class="d-block text-muted fs-4 mt-2">لصيانة المكيفات والغسالات بالرياض</span>
          </h1>
          
          <p class="mb-4 fs-6" style="color: var(--text-color); line-height: 1.8;">
            نقدم خدمات <strong>صيانة مكيفات الرياض</strong> و<strong>تصليح الغسالات الأتوماتيك</strong> بجودة عالية وقطع غيار أصلية. فريقنا من <strong>فنيي المكيفات</strong> المتخصصين جاهز لخدمتك <strong>24 ساعة</strong> في جميع مناطق الرياض.
          </p>
          
          <!-- Contact Details -->
          <div class="contact-details">
            <div class="d-flex mb-4 align-items-start">
              <div class="contact-icon">
                <i class="bi bi-geo-alt-fill"></i>
              </div>
              <div>
                <h6 class="fw-bold mb-1" style="color: var(--primary-color);">موقعنا</h6>
                <p class="mb-0" style="color: var(--text-color);">الرياض <br>
                <small class="text-muted">شمال الرياض، غرب الرياض، شرق الرياض</small></p>
              </div>
            </div>
            
            <div class="d-flex mb-4 align-items-start">
              <div class="contact-icon">
                <i class="bi bi-envelope-fill"></i>
              </div>
              <div>
                <h6 class="fw-bold mb-1" style="color: var(--primary-color);">البريد الإلكتروني</h6>
                <a href="mailto:info@washingmachineandacrepairriyadh.shop" 
                   style="color: var(--text-color); text-decoration: none; font-size: 15px;">
                  info@washingmachine<br>andacrepairriyadh.shop
                </a>
              </div>
            </div>
            
            <div class="d-flex align-items-start">
              <div class="contact-icon">
                <i class="bi bi-telephone-fill"></i>
              </div>
              <div>
                <h6 class="fw-bold mb-1" style="color: var(--primary-color);">اتصل بنا</h6>
                <a href="tel:+966583907768" 
                   style="color: var(--primary-color); text-decoration: none; font-size: 18px; font-weight: 700;"dir="ltr">
                  +966 58 390 7768
                </a>
                <p class="mb-0 text-muted small">خدمة طوارئ على مدار الساعة</p>
              </div>
            </div>
          </div>

          <!-- Service Features -->
          <div class="service-features mt-4">
            <div class="feature-item">
              <i class="bi bi-check-circle-fill"></i>
              <span>صيانة مكيفات سبليت</span>
            </div>
            <div class="feature-item">
              <i class="bi bi-check-circle-fill"></i>
              <span>إصلاح غسالات أتوماتيك</span>
            </div>
            <div class="feature-item">
              <i class="bi bi-check-circle-fill"></i>
              <span>فنيون متخصصون</span>
            </div>
            <div class="feature-item">
              <i class="bi bi-check-circle-fill"></i>
              <span>قطع غيار أصلية</span>
            </div>
            <div class="feature-item">
              <i class="bi bi-check-circle-fill"></i>
              <span>ضمان على الصيانة</span>
            </div>
            <div class="feature-item">
              <i class="bi bi-check-circle-fill"></i>
              <span>خدمة 24/7</span>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Contact Form -->
      <div class="col-lg-6">
        <form id="cs_form">
          <div class="form-header">
            <h3>طلب خدمة الصيانة</h3>
            <p>املأ النموذج وسنتصل بك خلال ساعة</p>
          </div>
          
          <div class="row g-3">
            <div class="col-md-6">
              <div class="form-group">
                <label for="name">الاسم الكامل</label>
                <input type="text" id="name" name="name" class="form-control" placeholder="أدخل اسمك بالكامل" required>
              </div>
            </div>
            
            <div class="col-md-6">
              <div class="form-group">
                <label for="phone">رقم الهاتف</label>
                <input type="tel" id="phone" name="phone" class="form-control" placeholder="مثال: 0583907768" required>
              </div>
            </div>
            
            <div class="col-12">
              <div class="form-group">
                <label for="service">نوع الخدمة المطلوبة</label>
                <select id="service" name="service" class="form-control" required>
                  <option value="" disabled selected>اختر نوع الخدمة</option>
                  <option value="صيانة مكيفات سبليت">صيانة مكيفات سبليت</option>
                  <option value="صيانة مكيفات مركزي">صيانة مكيفات مركزي</option>
                  <option value="إصلاح غسالات أتوماتيك">إصلاح غسالات أتوماتيك</option>
                  <option value="إصلاح غسالة سامسونج">إصلاح غسالة سامسونج</option>
                  <option value="تنظيف مكيفات">تنظيف وتعقيم المكيفات</option>
                  <option value="إصلاح موتور النشافة">إصلاح موتور النشافة</option>
                  <option value="استشارة فنية">استشارة فنية مجانية</option>
                </select>
              </div>
            </div>

            <div class="col-12">
              <div class="form-group">
                <label for="area">المنطقة</label>
                <select id="area" name="area" class="form-control" required>
                  <option value="" disabled selected>اختر منطقتك</option>
                  <option value="شمال الرياض">شمال الرياض</option>
                  <option value="غرب الرياض">غرب الرياض</option>
                  <option value="شرق الرياض">شرق الرياض</option>
                  <option value="جنوب الرياض">جنوب الرياض</option>
                  <option value="وسط الرياض">وسط الرياض</option>
                </select>
              </div>
            </div>
            
            <div class="col-12">
              <div class="form-group">
                <label for="message">تفاصيل المشكلة</label>
                <textarea id="message" name="message" class="form-control" rows="4" 
                          placeholder="صف المشكلة التي تواجهها بالتفصيل..." required></textarea>
              </div>
            </div>
            
            <div class="col-12 mt-2">
              <button type="submit" class="btn-submit">
                <i class="bi bi-tools"></i>
                إرسال طلب الصيانة
              </button>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</section><?php /**PATH E:\project\3thMonths\falseceilingandgypsumwork.shop\resources\views/newSection2.blade.php ENDPATH**/ ?>