 
 
 <style>
 :root {
            --primary-color: #3D6B63;   /* main brand color (buttons, headings, links) */
            --secondary-color: #B85C38; /* accent / highlights (badges, icons) */
            --accent-color: #E6C66A;    /* support / call-to-action (buttons hover, highlights) */

            /* --- Neutrals derived from only these three colors --- */
            --bg-color: #FFF9F4;         /* use as background, very light neutral */
            --text-color: #3D6B63;       /* primary text */
            --text-muted: #B85C38;       /* secondary text, subheadings */
        }

      
        footer {
            background: var(--primary-color);
            margin: 0;
            padding: 0;
            border-top: 4px solid var(--accent-color);
        }

        .footer-widget {
            padding: 10px 0;
        }

        .footer-logo {
            font-weight: 800;
            font-size: 2rem;
            color: var(--bg-color);
            text-decoration: none;
            margin-bottom: 20px;
            display: inline-block;
        }

        .footer-logo span {
            color: var(--accent-color);
        }

        .footer-separator {
            display: flex;
            margin-bottom: 20px;
        }

        .footer-separator span {
            height: 3px;
            border-radius: 2px;
        }

        .footer-separator span:nth-child(1) {
            background: var(--accent-color);
            width: 35px;
        }

        .footer-separator span:nth-child(2) {
            background: rgba(255, 255, 255, 0.3);
            width: 20px;
            margin: 0 4px;
        }

        .footer-separator span:nth-child(3) {
            background: rgba(255, 255, 255, 0.3);
            width: 10px;
        }

        .footer-description {
            color: rgba(255, 255, 255, 0.9);
            line-height: 1.8;
            margin-bottom: 25px;
            font-size: 1.05rem;
        }

        .footer-description strong {
            color: var(--accent-color);
        }

        .social-icons {
            display: flex;
            gap: 12px;
        }

        .social-icon {
            width: 45px;
            height: 45px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--bg-color) !important;
            text-decoration: none;
            transition: all 0.3s ease;
            border: 2px solid transparent;
        }

        .social-icon:hover {
            background: var(--accent-color);
            color: var(--text-color) !important;
            transform: translateY(-3px);
            border-color: var(--accent-color);
        }

        .footer-heading {
            color: var(--accent-color) !important;
            font-weight: 700;
            margin-bottom: 20px;
            font-size: 1.3rem;
        }

        .footer-link {
            color: rgba(255, 255, 255, 0.9) !important;
            text-decoration: none;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            padding: 8px 0;
            border-radius: 6px;
        }

        .footer-link:hover {
            color: var(--accent-color) !important;
            transform: translateX(-5px);
        }

        .footer-link i {
            color: var(--accent-color);
            margin-left: 10px;
            font-size: 1.1rem;
            transition: transform 0.3s ease;
        }

        .footer-link:hover i {
            transform: scale(1.2);
        }

        .service-link {
            color: rgba(255, 255, 255, 0.8) !important;
            text-decoration: none;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            padding: 6px 0;
            font-size: 0.95rem;
            border-radius: 4px;
        }

        .service-link:hover {
            color: var(--accent-color) !important;
            transform: translateX(-3px);
        }

        .service-link i {
            color: var(--accent-color);
            margin-left: 8px;
            font-size: 1rem;
        }
        

        .contact-item {
            color: rgba(255, 255, 255, 0.9);
            display: flex;
            align-items: flex-start;
            margin-bottom: 20px;
            padding: 12px 0;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .contact-item:last-child {
            border-bottom: none;
        }

        .contact-item i {
            color: var(--accent-color);
            margin-left: 12px;
            font-size: 1.2rem;
            margin-top: 2px;
        }

        .contact-item a {
            color: var(--bg-color) !important;
            text-decoration: none;
            transition: color 0.3s ease;
            font-weight: 600;
        }

        .contact-item a:hover {
            color: var(--accent-color) !important;
        }

        .footer-bottom {
            background: rgba(0, 0, 0, 0.2);
            border-top: 1px solid rgba(255, 255, 255, 0.1);
        }

        .footer-bottom-content {
            color: rgba(255, 255, 255, 0.8);
            font-size: 0.95rem;
        }

        .footer-bottom-content a {
            color: var(--accent-color) !important;
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .footer-bottom-content a:hover {
            color: var(--bg-color) !important;
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .footer-widget {
                text-align: center;
                margin-bottom: 30px;
            }

            .social-icons {
                justify-content: center;
            }

            .footer-separator {
                justify-content: center;
            }

            .footer-link, .service-link {
                justify-content: center;
            }

            .contact-item {
                justify-content: center;
                text-align: center;
            }
        }

        @media (max-width: 576px) {
            .footer-logo {
                font-size: 1.7rem;
            }

            .footer-heading {
                font-size: 1.2rem;
            }

            .footer-description {
                font-size: 1rem;
            }
        }
    </style>


    <!-- Demo content to show the footer in context -->
   
    <footer class="text-white">
        <div class="container py-5">
            <div class="row gy-5">
                
                <!-- About Column -->
                <div class="col-md-12 col-lg-4">
                    <div class="footer-widget">
                        
                        <!-- Logo -->
                       <div class="mb-4">
    <a href="/" class="footer-logo d-flex align-items-center">
        <img src="<?php echo e(asset('images/Curtains Maker & Supplier  Logo  B.png')); ?>" alt="ستائر الرياض Logo" style="height:50px; margin-right:10px;">
       
    </a>
</div>


                        <!-- Separator -->
                        <div class="footer-separator">
                            <span></span>
                            <span></span>
                            <span></span>
                        </div>

                        <!-- Business description -->
                        <p class="footer-description">
                            خبراء <strong>تفصيل وتركيب الستائر في الرياض</strong> لجميع أنواع الستائر الفاخرة،
                            ستائر بلاك أوت، ستائر حسب الطلب، مع خامات عالية الجودة وضمان على التركيب.
                        </p>

                        <!-- Social Media -->
                        <div class="social-icons">
                            <a href="#" class="social-icon"><i class="bi bi-instagram fs-5"></i></a>
                            <a href="https://wa.me/966533681853" class="social-icon"><i class="bi bi-whatsapp fs-5"></i></a>
                            <a href="#" class="social-icon"><i class="bi bi-youtube fs-5"></i></a>
                            <a href="#" class="social-icon"><i class="bi bi-facebook fs-5"></i></a>
                        </div>
                    </div>
                </div>

                <!-- Quick Links -->
                <div class="col-md-6 col-lg-2">
                    <div class="footer-widget">
                        <h4 class="footer-heading">روابط سريعة</h4>
                        <div class="footer-separator">
                            <span></span>
                            <span></span>
                            <span></span>
                        </div>
                        <ul class="list-unstyled">
                            <li><a href="/" class="footer-link"><i class="bi bi-house" style="margin-right:10px;"></i>الرئيسية</a></li>
                            <li><a href="/about" class="footer-link"><i class="bi bi-info-circle" style="margin-right:10px;"></i>من نحن</a></li>
                            <li><a href="/services" class="footer-link"><i class="bi bi-grid" style="margin-right:10px;"></i>خدماتنا</a></li>
                            <li><a href="https://wa.me/966533681853" class="footer-link" ><i class="bi bi-image" style="margin-right:10px;"></i>معرض الستائر</a></li>
                            <li><a href="/contact" class="footer-link"><i class="bi bi-telephone" style="margin-right:10px;"></i>اتصل بنا</a></li>
                        </ul>
                    </div>
                </div>

                <!-- Services / SEO keywords column -->
                <div class="col-md-6 col-lg-3">
                    <div class="footer-widget">
                        <h4 class="footer-heading">خدمات الستائر بالرياض</h4>
                        <div class="footer-separator">
                            <span></span>
                            <span></span>
                            <span></span>
                        </div>
                        <ul class="list-unstyled">
                            <li><a href="https://wa.me/966533681853" class="service-link"><i class="bi bi-brush" style="margin-right:10px;"></i>تفصيل ستائر حسب الطلب</a></li>
                            <li><a href="https://wa.me/966533681853" class="service-link"><i class="bi bi-tools" style="margin-right:10px;"></i>تركيب ستائر فاخرة الرياض</a></li>
                            <li><a href="https://wa.me/966533681853" class="service-link"><i class="bi bi-toggle-off" style="margin-right:10px;"></i>ستائر بلاك أوت بالرياض</a></li>
                            <li><a href="https://wa.me/966533681853" class="service-link"><i class="bi bi-check2-square" style="margin-right:10px;"></i>ستائر جاهزة بالرياض</a></li>
                            <li><a href="https://wa.me/966533681853" class="service-link"><i class="bi bi-house-check" style="margin-right:10px;"></i>محلات ستائر في الرياض</a></li>
                        </ul>
                    </div>
                </div>

                <!-- Contact Section -->
                <div class="col-md-6 col-lg-3">
                    <div class="footer-widget">
                        <h4 class="footer-heading">تواصل معنا</h4>
                        <div class="footer-separator">
                            <span></span>
                            <span></span>
                            <span></span>
                        </div>
                        <div class="contact-info">
                            <div class="contact-item">
                                <i class="bi bi-geo-alt-fill" style="margin-right:10px;"></i>
                                <span>الرياض - جميع المناطق</span>
                            </div>
                            <div class="contact-item">
                                <i class="bi bi-telephone-fill" style="margin-right:10px;"></i>
                                <a href="tel:966533681853">053 368 1853</a>
                            </div>
                            <div class="contact-item">
                                <i class="bi bi-envelope-fill" style="margin-right:10px;"></i>
                                <a href="mailto:info@curtainsupplierandmaker.shop">
                                    info@curtainsupplierandmaker.shop
                                </a>
                            </div>
                            <div class="contact-item">
                                <i class="bi bi-clock-fill" style="margin-right:10px;"></i>
                                <span>خدمة 24 ساعة | طوال الأسبوع</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Footer Bottom -->
        <div class="footer-bottom py-4">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-md-8 text-center text-md-start">
                        <span class="footer-bottom-content">
                            © 2025 ستائر الرياض - تفصيل وتركيب | جميع الحقوق محفوظة <a href="https://innovative-technologies.net/"class="text-warning text-decoration-none"><strong>Innovative Technologies</strong>></a>
                        </span>
                    </div>
                    <div class="col-md-4 text-center text-md-end mt-2 mt-md-0">
                        <a href="/privacy-policy" class="footer-bottom-content">
                            سياسة الخصوصية
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    
<!-- Fixed Floating Call & WhatsApp Buttons -->
<div class="floating-buttons">
  <!-- Call Button Left -->
   <div>
  <a href="tel:+966583907768" class="floating-btn call-btn">
    <i class="bi bi-telephone-fill"></i>
    <span class="floating-tooltip">اتصل الآن</span>
  </a>
   <a href="tel:+966533681853" class="call-label-link">
  <span class="call-label">053 368 1853</span>
  </a>
  </div>
  <style>
    .call-label {
  margin-left: 90px;
  margin-top: -70px;
  position: absolute;
  font-size: 18px;
  color: #333;
  font-weight: 600;
  background: #fff;
  padding: 8px 14px;
  border-radius: 25px;
  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.2);
}

  </style>

  <!-- WhatsApp Button Right -->
  <a href="https://wa.me/966533681853" target="_blank" class="floating-btn whatsapp-btn">
    <i class="bi bi-whatsapp"></i>
    <span class="floating-tooltip">واتساب</span>
  </a>
</div>

<style>
  .footer-widget {
    position: relative;
  }

  .footer-link, .service-link {
    transition: all 0.3s ease;
    padding: 5px 0;
    display: block;
    border-radius: 5px;
  }

  .footer-link:hover, .service-link:hover {
    color: #ffc107 !important;
    transform: translateX(-5px);
    padding-right: 10px;
  }

  .social-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    background: rgba(255,255,255,0.1);
    transition: all 0.3s ease;
  }

  .social-icon:hover {
    background: #ffc107;
    color: #2c5fa5 !important;
    transform: translateY(-3px);
  }

  .floating-buttons {
    position: fixed;
    bottom: 20px;
    left: 0;
    right: 0;
    width: 100%;
    pointer-events: none;
    z-index: 9999;
  }

  .floating-btn {
    position: absolute;
    bottom: 20px;
    width: 70px;
    height: 70px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #fff;
    font-size: 24px;
    text-decoration: none;
    pointer-events: auto;
    box-shadow: 0 8px 25px rgba(0,0,0,0.3);
    transition: all 0.3s ease;
    z-index: 9999;
    flex-direction: column;
  }

  .floating-btn:hover {
    transform: scale(1.1) translateY(-5px);
    box-shadow: 0 12px 30px rgba(0,0,0,0.4);
  }

  /* Call button on bottom left */
  .call-btn {
    left: 20px;
    background: linear-gradient(135deg, #2c5fa5, #1e4a8d);
  }

  /* WhatsApp button on bottom right */
  .whatsapp-btn {
    right: 20px;
    background: linear-gradient(135deg, #25d366, #128C7E);
  }

  .floating-tooltip {
    position: absolute;
    top: -40px;
    background: rgba(0,0,0,0.8);
    color: white;
    padding: 5px 10px;
    border-radius: 5px;
    font-size: 12px;
    opacity: 0;
    transition: all 0.3s ease;
    white-space: nowrap;
  }

  .floating-btn:hover .floating-tooltip {
    opacity: 1;
    transform: translateY(-5px);
  }

  /* Responsive sizing on mobile */
  @media (max-width: 768px) {
    .floating-btn {
      width: 60px;
      height: 60px;
      font-size: 20px;
    }
    
    .floating-tooltip {
      font-size: 10px;
      top: -35px;
    }
  }

  @media (max-width: 576px) {
    .floating-btn {
      width: 55px;
      height: 55px;
      font-size: 18px;
      bottom: 15px;
    }
    
    .call-btn {
      left: 15px;
    }
    
    .whatsapp-btn {
      right: 15px;
    }
  }
</style>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script><?php /**PATH E:\project\6thmonths\curtainsupplierandmaker.shop\resources\views/footer.blade.php ENDPATH**/ ?>