<section class="cs_about cs_style_1 position-relative py-5" style="direction: rtl; background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);">
    <div class="container">
        <div class="row g-5 align-items-center">
            <!-- Right Column - Images -->
            <div class="col-lg-6">
                <div class="position-relative">
                    <!-- Professional Image Grid -->
                    <div class="row g-4">
                        <div class="col-md-8 col-12">
                            <div class="cs_about_thumbnail overflow-hidden rounded-4">
                                <img src="images/washing-machine-repair-service.jpg" loading="lazy" alt="تصليح غسالات اتوماتيك بالرياض" class="img-fluid w-100 img-hover-animate">
                                <div class="image-overlay">
                                    <div class="overlay-content">
                                        <i class="bi bi-droplet fs-1 text-white"></i>
                                        <h5 class="text-white mt-2">تصليح الغسالات</h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-12">
                            <div class="cs_about_thumbnail overflow-hidden rounded-4">
                                <img src="images/ac-repair-technician.jpg" loading="lazy" alt="صيانة مكيفات سبليت الرياض" class="img-fluid w-100 img-hover-animate">
                                <div class="image-overlay">
                                    <div class="overlay-content">
                                        <i class="bi bi-snow fs-1 text-white"></i>
                                        <h5 class="text-white mt-2">صيانة المكيفات</h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Floating Badges -->
                    <div class="position-absolute" style="top: 20%; left: -10px; z-index: 2;">
                        <div class="floating-badge" style="background: linear-gradient(135deg, #2c5fa5, #1e4a8d);">
                            <i class="bi bi-star-fill"></i>
                            <span>ضمان الجودة</span>
                        </div>
                    </div>
                    <div class="position-absolute" style="bottom: 30%; right: -10px; z-index: 2;">
                        <div class="floating-badge" style="background: linear-gradient(135deg, #28a745, #1e7e34);">
                            <i class="bi bi-clock"></i>
                            <span>24/7</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Left Column - Content -->
            <div class="col-lg-6">
                <div class="pe-lg-4">
                    <!-- Section Heading -->
                    <div class="mb-4">
                        <div class="d-flex align-items-center mb-3">
                            <div class="section-line" style="background: linear-gradient(135deg, #2c5fa5, #1e4a8d);"></div>
                            <span class="section-badge">الرياض - مركز الصيانة المتكامل</span>
                            <div class="section-line" style="background: linear-gradient(135deg, #ffc107, #e0a800);"></div>
                        </div>
                        <h2 class="display-5 fw-bold mb-3" style="color: #2c5fa5; line-height: 1.2;">
                            خبراء <span style="color: #ffc107;">صيانة المكيفات</span> و<span style="color: #28a745;">تصليح الغسالات</span>
                        </h2>
                    </div>

                    <!-- Washing Machine Services Paragraph -->
                    <div class="service-paragraph mb-5">
                        <div class="service-header mb-3">
                            <div class="service-icon" style="background: linear-gradient(135deg, #28a745, #1e7e34);">
                                <i class="bi bi-droplet text-white"></i>
                            </div>
                            <h4 class="service-title" style="color: #28a745;">خدمات تصليح الغسالات المتكاملة</h4>
                        </div>
                        <p class="service-description" style="color: #555; line-height: 1.8; font-size: 16px;">
                            نقدم <strong>خدمات تصليح الغسالات الأتوماتيك</strong> بكافة أنواعها وموديلاتها، حيث نقوم بإصلاح غسالات سامسونج وهيتاشي وويرلبول وجميع الماركات العالمية. يتضمن ذلك <strong>تصليح حوض الغسالة ومجفف الغسالة</strong> وإصلاح موتور النشافة والغسالات العادية. نستخدم قطع غيار أصلية مع ضمان شامل على جميع أعمالنا، ونقوم بصيانة المحركات والأعطال الكهربائية والميكانيكية باحترافية عالية. فريقنا من <strong>فنيي الغسالات المحترفين</strong> جاهز لتقديم الحلول الفورية لأي عطل تواجهه في غسالتك.
                        </p>
                    </div>

                    <!-- AC Services Paragraph -->
                    <div class="service-paragraph mb-5">
                        <div class="service-header mb-3">
                            <div class="service-icon" style="background: linear-gradient(135deg, #2c5fa5, #1e4a8d);">
                                <i class="bi bi-snow text-white"></i>
                            </div>
                            <h4 class="service-title" style="color: #2c5fa5;">خدمات صيانة المكيفات الشاملة</h4>
                        </div>
                        <p class="service-description" style="color: #555; line-height: 1.8; font-size: 16px;">
                            نوفر <strong>خدمات صيانة مكيفات سبليت</strong> متكاملة لجميع مناطق الرياض بما في ذلك شمال الرياض، غرب الرياض، شرق الرياض وجميع الأحياء. نقدم <strong>خدمة طوارئ 24 ساعة</strong> للمكيفات مع فريق من <strong>فنيي المكيفات المتخصصين</strong> في صيانة مكيفات سامسونج والمركزي والصحراوي. تشمل خدماتنا <strong>تنظيف وتعقيم المكيفات</strong> بشكل احترافي، إصلاح الأعطال الفنية، صيانة دورية، واستبدال القطع التالفة بقطع أصلية. نضمن لك تكييفاً يعمل بكفاءة عالية في جميع الأجواء.
                        </p>
                    </div>

                    <!-- Contact CTA -->
                    <div class="cta-section">
                        <div class="cta-card">
                            <div class="cta-content">
                                <div class="cta-icon">
                                    <i class="bi bi-headset"></i>
                                </div>
                                <div class="cta-text">
                                    <h5 class="mb-1">دعم فني على مدار الساعة</h5>
                                    <p class="mb-2 text-muted">فريقنا جاهز لمساعدتك في أي وقت</p>
                                    <a href="tel:+966583907768" class="cta-phone" dir="ltr">+966 58 390 7768</a>
                                </div>
                            </div>
                            <div class="cta-buttons">
                                <a href="tel:+966583907768" class="btn cta-btn primary">
                                    <i class="bi bi-telephone me-2"></i>
                                    اتصل الآن
                                </a>
                                <a href="https://wa.me/966583907768" class="btn cta-btn success">
                                    <i class="bi bi-whatsapp me-2"></i>
                                    واتساب
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
/* Main image styling */
.cs_about_thumbnail {
    position: relative;
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
    height: 280px;
}

.cs_about_thumbnail:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 35px rgba(0,0,0,0.15);
}

.cs_about_thumbnail img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: all 0.3s ease;
}

.image-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(135deg, rgba(44, 95, 165, 0.9), rgba(30, 74, 141, 0.8));
    opacity: 0;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    justify-content: center;
}

.cs_about_thumbnail:hover .image-overlay {
    opacity: 1;
}

.overlay-content {
    text-align: center;
    transform: translateY(20px);
    transition: all 0.3s ease;
}

.cs_about_thumbnail:hover .overlay-content {
    transform: translateY(0);
}

/* Floating badges */
.floating-badge {
    padding: 8px 15px;
    border-radius: 25px;
    color: white;
    font-weight: 600;
    font-size: 14px;
    display: flex;
    align-items: center;
    gap: 8px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    animation: float 3s ease-in-out infinite;
}

@keyframes float {
    0%, 100% { transform: translateY(0); }
    50% { transform: translateY(-10px); }
}

/* Section header */
.section-line {
    width: 40px;
    height: 3px;
    border-radius: 2px;
}

.section-badge {
    background: linear-gradient(135deg, #2c5fa5, #1e4a8d);
    color: white;
    padding: 8px 20px;
    border-radius: 25px;
    font-weight: 600;
    font-size: 14px;
    margin: 0 15px;
}

/* Service Paragraph Styling */
.service-paragraph {
    background: white;
    padding: 25px;
    border-radius: 16px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.08);
    border-right: 4px solid transparent;
    transition: all 0.3s ease;
}

.service-paragraph:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.12);
}

.service-paragraph:first-child {
    border-right-color: #28a745;
}

.service-paragraph:last-child {
    border-right-color: #2c5fa5;
}

.service-header {
    display: flex;
    align-items: center;
    gap: 15px;
}

.service-icon {
    width: 50px;
    height: 50px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
}

.service-title {
    font-weight: 700;
    margin: 0;
}

.service-description {
    text-align: justify;
    margin: 0;
}

/* CTA Section */
.cta-card {
    background: white;
    border-radius: 16px;
    padding: 25px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    border-left: 4px solid #2c5fa5;
}

.cta-content {
    display: flex;
    align-items: center;
    gap: 15px;
    margin-bottom: 20px;
}

.cta-icon {
    width: 60px;
    height: 60px;
    background: linear-gradient(135deg, #2c5fa5, #1e4a8d);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 24px;
}

.cta-phone {
    font-size: 18px;
    font-weight: 700;
    color: #2c5fa5;
    text-decoration: none;
}

.cta-buttons {
    display: flex;
    gap: 10px;
}

.cta-btn {
    flex: 1;
    padding: 12px 20px;
    border: none;
    border-radius: 8px;
    font-weight: 600;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    justify-content: center;
}

.cta-btn.primary {
    background: linear-gradient(135deg, #2c5fa5, #1e4a8d);
    color: white;
}

.cta-btn.success {
    background: linear-gradient(135deg, #28a745, #1e7e34);
    color: white;
}

.cta-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
}

/* Responsive */
@media (max-width: 768px) {
    .cta-buttons {
        flex-direction: column;
    }
    
    .service-paragraph {
        padding: 20px;
    }
    
    .cs_about_thumbnail {
        height: 220px;
    }
    
    .floating-badge {
        display: none;
    }
    
    .service-header {
        flex-direction: column;
        text-align: center;
        gap: 10px;
    }
}
</style><?php /**PATH E:\project\3thMonths\falseceilingandgypsumwork.shop\resources\views/aboutSection.blade.php ENDPATH**/ ?>